/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview.patternCells;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import com.kevalpatel.passcodeview.PasscodeView;
import com.kevalpatel.passcodeview.PatternView;

public abstract class PatternCell {
    private PatternView mPatternView;
    private Rect mBound;
    private Point mPoint;

    private PatternCell() {
    }

    protected PatternCell(@NonNull PatternView pinView, @NonNull Rect bound, @NonNull Builder builder, Point location) {
        this.mPatternView = pinView;
        this.mBound = bound;
        this.mPoint = location;
    }

    protected final PasscodeView getRootView() {
        return this.mPatternView;
    }

    protected final Context getContext() {
        return this.mPatternView.getContext();
    }

    public abstract void draw(@NonNull Canvas var1);

    public abstract void onAuthFailed();

    public abstract void onAuthSuccess();

    public float getCenterX() {
        return this.getBound().exactCenterX();
    }

    public float getCenterY() {
        return this.getBound().exactCenterY();
    }

    @NonNull
    public Rect getBound() {
        return this.mBound;
    }

    public abstract boolean isIndicatorTouched(float var1, float var2);

    public Point getPoint() {
        return this.mPoint;
    }

    public static abstract class Builder {
        private PatternView mPatternView;

        private Builder() {
        }

        public Builder(@NonNull PatternView pinView) {
            this.mPatternView = pinView;
            this.setDefaults(pinView.getContext());
        }

        @NonNull
        protected final PatternView getRootView() {
            return this.mPatternView;
        }

        @NonNull
        protected final Context getContext() {
            return this.mPatternView.getContext();
        }

        @Dimension
        public abstract float getCellRadius();

        public abstract Builder build();

        protected abstract void setDefaults(@NonNull Context var1);

        public abstract PatternCell getCell(@NonNull Rect var1, Point var2);
    }
}

