/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview.patternCells;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import com.kevalpatel.passcodeview.PatternView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.patternCells.PatternCell;

public final class DotPatternCell
extends PatternCell {
    private Builder mBuilder;
    private float mTouchRadius;
    private boolean isDisplayError;

    DotPatternCell(@NonNull PatternView patternView, @NonNull Rect bound, @NonNull Builder builder, Point point) {
        super(patternView, bound, builder, point);
        this.mBuilder = builder;
        this.mTouchRadius = this.mBuilder.getRadius() < this.getContext().getResources().getDimension(R.dimen.lib_min_touch_radius) ? this.mBuilder.getRadius() + 20.0f : this.mBuilder.getRadius();
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        canvas.drawCircle(this.getBound().exactCenterX(), this.getBound().exactCenterY(), this.mBuilder.getRadius(), this.isDisplayError ? this.mBuilder.getErrorCellPaint() : this.mBuilder.getNormalCellPaint());
    }

    @Override
    public void onAuthFailed() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                DotPatternCell.this.isDisplayError = false;
                DotPatternCell.this.getRootView().invalidate();
            }
        }, 400L);
        this.isDisplayError = true;
    }

    @Override
    public void onAuthSuccess() {
    }

    @Override
    public boolean isIndicatorTouched(float touchX, float touchY) {
        return touchX > this.getBound().exactCenterX() - this.mTouchRadius && touchX < this.getBound().exactCenterX() + this.mTouchRadius && touchY > this.getBound().exactCenterY() - this.mTouchRadius && touchY < this.getBound().exactCenterY() + this.mTouchRadius;
    }

    public static class Builder
    extends PatternCell.Builder {
        @ColorInt
        private int mCellColor;
        @Dimension
        private float mRadius;
        private Paint mCellPaint;
        private Paint mErrorCellPaint;

        public Builder(@NonNull PatternView patternView) {
            super(patternView);
        }

        @Override
        @Dimension
        public float getCellRadius() {
            return this.mRadius * 2.0f;
        }

        @Override
        public Builder build() {
            this.mCellPaint = new Paint(1);
            this.mCellPaint.setColor(this.mCellColor);
            this.mErrorCellPaint = new Paint(1);
            this.mErrorCellPaint.setColor(-65536);
            return this;
        }

        @Override
        protected void setDefaults(@NonNull Context context) {
            this.mRadius = this.getContext().getResources().getDimension(R.dimen.lib_dot_cell_radius_radius);
            this.mCellColor = this.getContext().getResources().getColor(R.color.lib_indicator_stroke_color);
        }

        @Override
        public PatternCell getCell(@NonNull Rect bound, Point point) {
            return new DotPatternCell(this.getRootView(), bound, this, point);
        }

        @ColorInt
        public int getCellColor() {
            return this.mCellColor;
        }

        @NonNull
        public Builder setCellColor(@ColorInt int normalColor) {
            this.mCellColor = normalColor;
            return this;
        }

        @NonNull
        public Builder setCellColorResource(@ColorRes int indicatorStrokeColor) {
            this.mCellColor = this.getContext().getResources().getColor(indicatorStrokeColor);
            return this;
        }

        @Dimension
        public float getRadius() {
            return this.mRadius;
        }

        @NonNull
        public Builder setRadius(@DimenRes int indicatorRadius) {
            this.mRadius = this.getContext().getResources().getDimension(indicatorRadius);
            return this;
        }

        @NonNull
        public Builder setRadius(@Dimension float radius) {
            this.mRadius = radius;
            return this;
        }

        @NonNull
        public Paint getNormalCellPaint() {
            return this.mCellPaint;
        }

        @NonNull
        public Paint getErrorCellPaint() {
            return this.mErrorCellPaint;
        }
    }
}

