/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.kevalpatel.passcodeview.BoxKeypad;
import com.kevalpatel.passcodeview.BoxTitleIndicator;
import com.kevalpatel.passcodeview.InteractiveArrayList;
import com.kevalpatel.passcodeview.KeyNamesBuilder;
import com.kevalpatel.passcodeview.PasscodeView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.Utils;
import com.kevalpatel.passcodeview.indicators.Indicator;
import com.kevalpatel.passcodeview.keys.Key;

public final class PinView
extends PasscodeView
implements InteractiveArrayList.ChangeListener {
    private float mDownKeyX;
    private float mDownKeyY;
    private int[] mCorrectPin;
    private InteractiveArrayList<Integer> mPinTyped;
    private BoxKeypad mBoxKeypad;
    private BoxTitleIndicator mBoxIndicator;

    public PinView(Context context) {
        super(context);
    }

    public PinView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PinView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.mPinTyped = new InteractiveArrayList();
        this.mPinTyped.setChangeListener(this);
        this.mBoxKeypad = new BoxKeypad(this);
        this.mBoxIndicator = new BoxTitleIndicator(this);
    }

    @Override
    protected void setDefaultParams() {
        this.mBoxIndicator.setDefaults();
        this.mBoxKeypad.setDefaults();
    }

    @Override
    protected void preparePaint() {
        this.mBoxKeypad.preparePaint();
        this.mBoxIndicator.preparePaint();
    }

    @Override
    protected void parseTypeArr(@NonNull AttributeSet typedArray) {
        TypedArray a = this.mContext.getTheme().obtainStyledAttributes(typedArray, R.styleable.PinView, 0, 0);
        try {
            this.mBoxIndicator.setTitle(a.hasValue(R.styleable.PinView_pin_titleText) ? a.getString(R.styleable.PinView_pin_titleText) : "Enter PIN");
            this.mBoxIndicator.setTitleColor(a.getColor(R.styleable.PinView_pin_titleTextColor, this.mContext.getResources().getColor(R.color.lib_key_default_color)));
        }
        finally {
            a.recycle();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mBoxKeypad.draw(canvas);
        this.mBoxIndicator.draw(canvas);
        this.mBoxFingerprint.draw(canvas);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mBoxKeypad.measure(this.mRootViewBound);
        this.mBoxIndicator.measure(this.mRootViewBound);
        this.mBoxFingerprint.measure(this.mRootViewBound);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mDownKeyX = event.getX();
                this.mDownKeyY = event.getY();
                break;
            }
            case 1: {
                this.onKeyPressed(this.mBoxKeypad.findKeyPressed(this.mDownKeyX, this.mDownKeyY, event.getX(), event.getY()));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void onKeyPressed(@Nullable String newDigit) {
        if (newDigit == null) {
            return;
        }
        if (this.mAuthenticationListener == null) {
            throw new IllegalStateException("Set AuthenticationListener to receive callbacks.");
        }
        if (this.mCorrectPin == null || this.mCorrectPin.length == 0) {
            throw new IllegalStateException("Please set current PIN to check with the entered value.");
        }
        if (newDigit.equals("-1")) {
            if (this.mPinTyped.size() > 0) {
                this.mPinTyped.remove(this.mPinTyped.size() - 1);
            }
        } else {
            this.mPinTyped.add(this.mBoxKeypad.getKeyNameBuilder().getValueOfKey(newDigit));
        }
        this.invalidate();
        if (this.mCorrectPin.length == this.mPinTyped.size()) {
            if (Utils.isPINMatched(this.mCorrectPin, this.mPinTyped)) {
                if (this.isTactileFeedbackEnable()) {
                    Utils.giveTactileFeedbackForAuthSuccess(this.mContext);
                }
                this.mAuthenticationListener.onAuthenticationSuccessful();
                this.mBoxKeypad.onAuthenticationSuccess();
                this.mBoxIndicator.onAuthenticationSuccess();
                this.mBoxFingerprint.onAuthenticationSuccess();
            } else {
                if (this.isTactileFeedbackEnable()) {
                    Utils.giveTactileFeedbackForAuthFail(this.mContext);
                }
                this.mAuthenticationListener.onAuthenticationFailed();
                this.mBoxFingerprint.onAuthenticationFail();
                this.mBoxKeypad.onAuthenticationFail();
                this.mBoxIndicator.onAuthenticationFail();
            }
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    PinView.this.reset();
                }
            }, 350L);
        } else if (this.isTactileFeedbackEnable()) {
            Utils.giveTactileFeedbackForKeyPress(this.mContext);
        }
    }

    @Override
    public void reset() {
        this.mPinTyped.clear();
        this.invalidate();
    }

    @Override
    public void onArrayValueChange(int size) {
        this.mBoxIndicator.onPinDigitEntered(size);
    }

    public boolean isOneHandOperationEnabled() {
        return this.mBoxKeypad.isOneHandOperation();
    }

    public void enableOneHandOperation(boolean isEnable) {
        this.mBoxKeypad.setOneHandOperation(isEnable);
        this.requestLayout();
        this.invalidate();
    }

    public void setCorrectPin(@NonNull int[] correctPin) {
        if (!Utils.isValidPin(correctPin)) {
            throw new IllegalArgumentException("Invalid PIN.");
        }
        this.mCorrectPin = correctPin;
        this.mBoxIndicator.setPinLength(this.mCorrectPin.length);
        this.mPinTyped.clear();
        this.invalidate();
    }

    @ColorInt
    public int getTitleColor() {
        return this.mBoxIndicator.getTitleColor();
    }

    public void setTitleColor(@ColorInt int titleColor) {
        this.mBoxIndicator.setTitleColor(titleColor);
        this.invalidate();
    }

    public void setTitleColorResource(@ColorRes int titleColor) {
        this.mBoxIndicator.setTitleColor(this.mContext.getResources().getColor(titleColor));
        this.invalidate();
    }

    public String getTitle() {
        return this.mBoxIndicator.getTitle();
    }

    public void setTitle(@NonNull String title) {
        this.mBoxIndicator.setTitle(title);
        this.invalidate();
    }

    @Nullable
    public Key.Builder getKeyBuilder() {
        return this.mBoxKeypad.getKeyBuilder();
    }

    public void setIndicator(@NonNull Indicator.Builder indicatorBuilder) {
        this.mBoxIndicator.setIndicatorBuilder(indicatorBuilder);
        this.requestLayout();
        this.invalidate();
    }

    @Nullable
    public Indicator.Builder getIndicatorBuilder() {
        return this.mBoxIndicator.getIndicatorBuilder();
    }

    public void setKey(@NonNull Key.Builder keyBuilder) {
        this.mBoxKeypad.setKeyBuilder(keyBuilder);
        this.requestLayout();
        this.invalidate();
    }

    public void setKeyNames(@NonNull KeyNamesBuilder keyNames) {
        BoxKeypad.setKeyNames(keyNames);
        this.mPinTyped.clear();
        this.requestLayout();
        this.invalidate();
    }

    public int[] getCurrentTypedPin() {
        int[] arr = new int[this.mPinTyped.size()];
        for (int i = 0; i < this.mPinTyped.size(); ++i) {
            arr[i] = (Integer)this.mPinTyped.get(i);
        }
        return arr;
    }

    public void setCurrentTypedPin(int[] currentTypedPin) {
        if (this.mCorrectPin.length == 0) {
            throw new IllegalStateException("You must call setCorrectPattern() before calling this method.");
        }
        if (currentTypedPin.length > this.mCorrectPin.length) {
            throw new IllegalArgumentException("Invalid pin length.");
        }
        this.mPinTyped.clear();
        for (int i : currentTypedPin) {
            this.mPinTyped.add(i);
        }
        this.requestLayout();
        this.invalidate();
    }
}

