/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.kevalpatel.passcodeview.Box;
import com.kevalpatel.passcodeview.PasscodeView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.indicators.Indicator;
import java.util.ArrayList;

final class BoxTitleIndicator
extends Box {
    static final String DEF_TITLE_TEXT = "Enter PIN";
    private int mPinLength;
    private int mTypedPinLength;
    @ColorInt
    private int mTitleColor;
    private String mTitle;
    private Paint mTitlePaint;
    private ArrayList<Indicator> mIndicators;
    private Rect mDotsIndicatorBound;
    private Indicator.Builder mIndicatorBuilder;

    BoxTitleIndicator(@NonNull PasscodeView view) {
        super(view);
    }

    @Override
    void setDefaults() {
        this.mTitle = DEF_TITLE_TEXT;
        this.mTitleColor = this.getContext().getResources().getColor(R.color.lib_key_default_color);
    }

    @Override
    void onAuthenticationFail() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                for (Indicator indicator : BoxTitleIndicator.this.mIndicators) {
                    indicator.onAuthFailed();
                }
                BoxTitleIndicator.this.getRootView().invalidate();
            }
        }, 100L);
    }

    @Override
    void onAuthenticationSuccess() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                for (Indicator indicator : BoxTitleIndicator.this.mIndicators) {
                    indicator.onAuthSuccess();
                }
                BoxTitleIndicator.this.getRootView().invalidate();
            }
        }, 100L);
    }

    @Override
    void draw(@NonNull Canvas canvas) {
        if (this.mIndicatorBuilder == null) {
            throw new NullPointerException("Build indicator before using it.");
        }
        canvas.drawText(this.mTitle, this.mDotsIndicatorBound.exactCenterX(), (float)(this.mDotsIndicatorBound.top - (int)this.getContext().getResources().getDimension(R.dimen.lib_divider_vertical_margin)), this.mTitlePaint);
        for (int i = 0; i < this.mPinLength; ++i) {
            this.mIndicators.get(i).draw(canvas, i < this.mTypedPinLength);
        }
    }

    @Override
    void measure(@NonNull Rect rootViewBounds) {
        int indicatorWidth = (int)(this.mIndicatorBuilder.getIndicatorWidth() + 2.0f * this.getContext().getResources().getDimension(R.dimen.lib_indicator_padding));
        int totalSpace = indicatorWidth * this.mPinLength;
        this.mDotsIndicatorBound = new Rect();
        this.mDotsIndicatorBound.left = (rootViewBounds.width() - totalSpace) / 2;
        this.mDotsIndicatorBound.right = this.mDotsIndicatorBound.left + totalSpace;
        this.mDotsIndicatorBound.bottom = rootViewBounds.top + (int)((float)rootViewBounds.height() * 0.2f - 2.0f * this.getContext().getResources().getDimension(R.dimen.lib_divider_vertical_margin));
        this.mDotsIndicatorBound.top = this.mDotsIndicatorBound.bottom - indicatorWidth;
        this.mIndicators = new ArrayList();
        for (int i = 0; i < this.mPinLength; ++i) {
            Rect rect = new Rect();
            rect.left = this.mDotsIndicatorBound.left + i * indicatorWidth;
            rect.right = rect.left + indicatorWidth;
            rect.top = this.mDotsIndicatorBound.top;
            rect.bottom = this.mDotsIndicatorBound.bottom;
            this.mIndicators.add(this.mIndicatorBuilder.getIndicator(rect));
        }
    }

    @Override
    void preparePaint() {
        this.mTitlePaint = new Paint(1);
        this.mTitlePaint.setColor(this.mTitleColor);
        this.mTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mTitlePaint.setTextSize(this.getContext().getResources().getDimension(R.dimen.lib_title_text_size));
    }

    void onPinDigitEntered(int newLength) {
        this.mTypedPinLength = newLength;
    }

    void setPinLength(int pinLength) {
        this.mPinLength = pinLength;
    }

    String getTitle() {
        return this.mTitle;
    }

    void setTitle(String title) {
        this.mTitle = title;
    }

    int getTitleColor() {
        return this.mTitleColor;
    }

    void setTitleColor(@ColorInt int titleColor) {
        this.mTitleColor = titleColor;
        this.preparePaint();
    }

    Indicator.Builder getIndicatorBuilder() {
        return this.mIndicatorBuilder;
    }

    void setIndicatorBuilder(@NonNull Indicator.Builder mIndicatorBuilder) {
        this.mIndicatorBuilder = mIndicatorBuilder;
    }
}

