/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.kevalpatel.passcodeview.Box;
import com.kevalpatel.passcodeview.PasscodeView;
import com.kevalpatel.passcodeview.R;

final class BoxTitle
extends Box {
    private static final String DEF_TITLE_TEXT = "Enter pattern";
    @ColorInt
    private int mTitleColor;
    private String mTitle;
    private Paint mTitlePaint;
    private Rect mBounds;

    BoxTitle(@NonNull PasscodeView view) {
        super(view);
    }

    @Override
    void setDefaults() {
        this.mTitle = DEF_TITLE_TEXT;
        this.mTitleColor = this.getContext().getResources().getColor(R.color.lib_key_default_color);
    }

    @Override
    void onAuthenticationFail() {
    }

    @Override
    void onAuthenticationSuccess() {
    }

    @Override
    void draw(@NonNull Canvas canvas) {
        canvas.drawText(this.mTitle, this.mBounds.exactCenterX(), (float)(this.mBounds.top - (int)this.getContext().getResources().getDimension(R.dimen.lib_divider_vertical_margin)), this.mTitlePaint);
    }

    @Override
    void measure(@NonNull Rect rootViewBounds) {
        this.mBounds = new Rect();
        this.mBounds.left = rootViewBounds.left;
        this.mBounds.right = rootViewBounds.right;
        this.mBounds.bottom = rootViewBounds.top + (int)((float)rootViewBounds.height() * 0.2f - 2.0f * this.getContext().getResources().getDimension(R.dimen.lib_divider_vertical_margin));
        this.mBounds.top = (int)((float)this.mBounds.bottom - this.mTitlePaint.getTextSize());
    }

    @Override
    void preparePaint() {
        this.mTitlePaint = new Paint(1);
        this.mTitlePaint.setColor(this.mTitleColor);
        this.mTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mTitlePaint.setTextSize(this.getContext().getResources().getDimension(R.dimen.lib_title_text_size));
    }

    String getTitle() {
        return this.mTitle;
    }

    void setTitle(String title) {
        this.mTitle = title;
    }

    int getTitleColor() {
        return this.mTitleColor;
    }

    void setTitleColor(int titleColor) {
        this.mTitleColor = titleColor;
        this.preparePaint();
    }
}

