/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.kevalpatel.passcodeview.Box;
import com.kevalpatel.passcodeview.KeyNamesBuilder;
import com.kevalpatel.passcodeview.PasscodeView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.keys.Key;
import java.util.ArrayList;

final class BoxKeypad
extends Box {
    @Size(value=12L)
    private static String[][] sKeyNames;
    private static KeyNamesBuilder sKeyNamesBuilder;
    private boolean mIsOneHandOperation = false;
    private ArrayList<Key> mKeys;
    private Rect mKeyBoxBound = new Rect();
    private Key.Builder mKeyBuilder;

    BoxKeypad(@NonNull PasscodeView passcodeView) {
        super(passcodeView);
        sKeyNamesBuilder = new KeyNamesBuilder();
        sKeyNames = sKeyNamesBuilder.build();
    }

    static void setKeyNames(@NonNull KeyNamesBuilder keyNames) {
        sKeyNamesBuilder = keyNames;
        sKeyNames = keyNames.build();
    }

    KeyNamesBuilder getKeyNameBuilder() {
        return sKeyNamesBuilder;
    }

    @Override
    void measure(@NonNull Rect rootViewBound) {
        if (this.mKeyBuilder == null) {
            throw new NullPointerException("Set key using KeyBuilder first.");
        }
        this.mKeyBoxBound.left = this.mIsOneHandOperation ? (int)((double)rootViewBound.width() * 0.3) : 0;
        this.mKeyBoxBound.right = rootViewBound.width();
        this.mKeyBoxBound.top = (int)((float)rootViewBound.top + (float)rootViewBound.height() * 0.2f);
        this.mKeyBoxBound.bottom = (int)((float)rootViewBound.bottom - (float)rootViewBound.height() * (this.getRootView().isFingerPrintEnable() != false ? 0.14f : 0.0f));
        float singleKeyHeight = this.mKeyBoxBound.height() / 4;
        float singleKeyWidth = this.mKeyBoxBound.width() / 3;
        this.mKeys = new ArrayList();
        for (int colNo = 0; colNo < 3; ++colNo) {
            for (int rowNo = 0; rowNo < 4; ++rowNo) {
                Rect keyBound = new Rect();
                keyBound.left = (int)((float)colNo * singleKeyWidth + (float)this.mKeyBoxBound.left);
                keyBound.right = (int)((float)keyBound.left + singleKeyWidth);
                keyBound.top = (int)((float)rowNo * singleKeyHeight + (float)this.mKeyBoxBound.top);
                keyBound.bottom = (int)((float)keyBound.top + singleKeyHeight);
                this.mKeys.add(this.mKeyBuilder.getKey(sKeyNames[colNo][rowNo], keyBound));
            }
        }
    }

    @Override
    void preparePaint() {
    }

    @Override
    void setDefaults() {
    }

    @Override
    void onAuthenticationFail() {
        for (Key key : this.mKeys) {
            key.onAuthFail();
        }
        this.getRootView().invalidate();
    }

    @Override
    void onAuthenticationSuccess() {
        for (Key key : this.mKeys) {
            key.onAuthSuccess();
        }
        this.getRootView().invalidate();
    }

    @Override
    void draw(@NonNull Canvas canvas) {
        Drawable d = this.getContext().getResources().getDrawable(R.drawable.ic_back_space);
        d.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.mKeyBuilder.getKeyTextPaint().getColor(), PorterDuff.Mode.SRC_ATOP));
        for (Key key : this.mKeys) {
            if (key.getDigit().isEmpty()) continue;
            key.drawShape(canvas);
            if (key.getDigit().equals("-1")) {
                key.drawBackSpace(canvas, d);
                continue;
            }
            key.drawText(canvas);
        }
    }

    @Nullable
    String findKeyPressed(float downEventX, float downEventY, float upEventX, float upEventY) {
        for (Key key : this.mKeys) {
            if (key.getDigit().isEmpty() || !key.isKeyPressed(downEventX, downEventY) || !key.isKeyPressed(upEventX, upEventY)) continue;
            key.playClickAnimation();
            return key.getDigit();
        }
        return null;
    }

    ArrayList<Key> getKeys() {
        return this.mKeys;
    }

    Rect getBounds() {
        return this.mKeyBoxBound;
    }

    boolean isOneHandOperation() {
        return this.mIsOneHandOperation;
    }

    void setOneHandOperation(boolean oneHandOperation) {
        this.mIsOneHandOperation = oneHandOperation;
    }

    Key.Builder getKeyBuilder() {
        return this.mKeyBuilder;
    }

    void setKeyBuilder(Key.Builder keyBuilder) {
        this.mKeyBuilder = keyBuilder;
    }
}

