/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview.keys;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.view.View;
import android.view.animation.CycleInterpolator;
import com.kevalpatel.passcodeview.PinView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.keys.Key;

public final class RoundKey
extends Key {
    private static final int MAX_RIPPLE_ALPHA = 100;
    private static final int RIPPLE_DURATION = 350;
    private final Rect mBounds;
    private final View mView;
    private final float mKeyRadius;
    private Builder mBuilder;
    private ValueAnimator mRippleValueAnimator;
    private ValueAnimator mErrorAnimator;
    private boolean isRippleEffectRunning = false;
    private int mCurrentRippleRadius = 0;
    private int mCurrentAlpha;

    private RoundKey(@NonNull PinView view, @NonNull String digit, @NonNull Rect bounds, @NonNull Builder builder) {
        super(view, digit, bounds, builder);
        this.mBounds = bounds;
        this.mView = view;
        this.mBuilder = builder;
        this.mKeyRadius = this.calculateKeyRadius(bounds, this.mBuilder.getKeyPadding());
        this.setUpAnimator();
    }

    private void setUpAnimator() {
        final int circleAlphaOffset = (int)(100.0f / this.mKeyRadius);
        this.mRippleValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, this.mKeyRadius});
        this.mRippleValueAnimator.setDuration(350L);
        this.mRippleValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (RoundKey.this.isRippleEffectRunning) {
                    float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
                    RoundKey.this.mCurrentRippleRadius = (int)animatedValue;
                    RoundKey.this.mCurrentAlpha = (int)(100.0f - animatedValue * (float)circleAlphaOffset);
                    RoundKey.this.mView.invalidate();
                }
            }
        });
        this.mRippleValueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                RoundKey.this.isRippleEffectRunning = true;
            }

            public void onAnimationEnd(Animator animation) {
                RoundKey.this.isRippleEffectRunning = false;
                RoundKey.this.mCurrentRippleRadius = 0;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mErrorAnimator = ValueAnimator.ofInt((int[])new int[]{0, 10});
        this.mErrorAnimator.setInterpolator((TimeInterpolator)new CycleInterpolator(2.0f));
        this.mErrorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((RoundKey)RoundKey.this).mBounds.left += ((Integer)animation.getAnimatedValue()).intValue();
                ((RoundKey)RoundKey.this).mBounds.right += ((Integer)animation.getAnimatedValue()).intValue();
                RoundKey.this.mView.invalidate();
            }
        });
    }

    private float calculateKeyRadius(Rect bounds, float padding) {
        return (float)(Math.min(bounds.height(), bounds.width()) / 2) - padding;
    }

    @Override
    public void playClickAnimation() {
        this.mRippleValueAnimator.start();
    }

    @Override
    public void onAuthFail() {
        this.mErrorAnimator.start();
    }

    @Override
    public void onAuthSuccess() {
    }

    @Override
    public void drawText(@NonNull Canvas canvas) {
        canvas.drawText(this.getDigit() + "", this.mBounds.exactCenterX(), this.mBounds.exactCenterY() - (this.mBuilder.getKeyTextPaint().descent() + this.mBuilder.getKeyTextPaint().ascent()) / 2.0f, this.mBuilder.getKeyTextPaint());
    }

    @Override
    public void drawShape(@NonNull Canvas canvas) {
        canvas.drawCircle(this.mBounds.exactCenterX(), this.mBounds.exactCenterY(), this.mKeyRadius, this.mBuilder.getKeyPaint());
        if (this.isRippleEffectRunning) {
            this.mBuilder.getRipplePaint().setAlpha(this.mCurrentAlpha);
            canvas.drawCircle(this.mBounds.exactCenterX(), this.mBounds.exactCenterY(), (float)this.mCurrentRippleRadius, this.mBuilder.getRipplePaint());
        }
    }

    @Override
    public void drawBackSpace(@NonNull Canvas canvas, @NonNull Drawable backSpaceIcon) {
        backSpaceIcon.setBounds((int)(this.mBounds.exactCenterX() - this.mKeyRadius / 2.0f), (int)(this.mBounds.exactCenterY() - this.mKeyRadius / 2.0f), (int)(this.mBounds.exactCenterX() + this.mKeyRadius / 2.0f), (int)(this.mBounds.exactCenterY() + this.mKeyRadius / 2.0f));
        backSpaceIcon.draw(canvas);
    }

    @Override
    public boolean isKeyPressed(float touchX, float touchY) {
        if (this.getDigit().isEmpty()) {
            return false;
        }
        return touchX > this.mBounds.exactCenterX() - this.mKeyRadius && touchX < this.mBounds.exactCenterX() + this.mKeyRadius && touchY > this.mBounds.exactCenterY() - this.mKeyRadius && touchY < this.mBounds.exactCenterY() + this.mKeyRadius;
    }

    public static class Builder
    extends Key.Builder {
        @Dimension
        private float mKeyPadding;
        @Dimension
        private float mKeyTextSize;
        @Dimension
        private float mKeyStrokeWidth;
        @ColorInt
        private int mKeyStrokeColor;
        @ColorInt
        private int mKeyTextColor;
        @NonNull
        private Paint mKeyPaint;
        @NonNull
        private TextPaint mKeyTextPaint;
        @NonNull
        private Paint mRipplePaint;

        public Builder(@NonNull PinView pinView) {
            super(pinView);
        }

        @Dimension
        public float getKeyPadding() {
            return this.mKeyPadding;
        }

        public Builder setKeyPadding(@Dimension float keyPadding) {
            this.mKeyPadding = keyPadding;
            return this;
        }

        public Builder setKeyPadding(@DimenRes int keyPaddingRes) {
            this.mKeyPadding = this.getContext().getResources().getDimension(keyPaddingRes);
            return this;
        }

        public float getKeyTextSize() {
            return this.mKeyTextSize;
        }

        public Builder setKeyTextSize(float keyTextSize) {
            this.mKeyTextSize = keyTextSize;
            return this;
        }

        public Builder setKeyTextSize(@DimenRes int keyTextSize) {
            this.mKeyTextSize = this.getContext().getResources().getDimension(keyTextSize);
            return this;
        }

        public float getKeyStrokeWidth() {
            return this.mKeyStrokeWidth;
        }

        @Dimension
        public Builder setKeyStrokeWidth(float keyStrokeWidth) {
            this.mKeyStrokeWidth = keyStrokeWidth;
            return this;
        }

        @Dimension
        public Builder setKeyStrokeWidth(@DimenRes int keyStrokeWidth) {
            this.mKeyStrokeWidth = this.getContext().getResources().getDimension(keyStrokeWidth);
            return this;
        }

        @ColorInt
        public int getKeyStrokeColor() {
            return this.mKeyStrokeColor;
        }

        public Builder setKeyStrokeColor(@ColorInt int keyStrokeColor) {
            this.mKeyStrokeColor = keyStrokeColor;
            return this;
        }

        public Builder setKeyStrokeColorResource(@ColorRes int keyStrokeColor) {
            this.mKeyStrokeColor = this.getContext().getResources().getColor(keyStrokeColor);
            return this;
        }

        @ColorInt
        public int getKeyTextColor() {
            return this.mKeyTextColor;
        }

        public Builder setKeyTextColor(@ColorInt int keyTextColor) {
            this.mKeyTextColor = keyTextColor;
            return this;
        }

        public Builder setKeyTextColorResource(@ColorRes int keyTextColor) {
            this.mKeyTextColor = this.getContext().getResources().getColor(keyTextColor);
            return this;
        }

        @Override
        public Builder build() {
            this.mKeyPaint = new Paint(1);
            this.mKeyPaint.setStyle(Paint.Style.STROKE);
            this.mKeyPaint.setColor(this.mKeyStrokeColor);
            this.mKeyPaint.setTextSize(this.mKeyTextSize);
            this.mKeyPaint.setStrokeWidth(this.mKeyStrokeWidth);
            this.mKeyTextPaint = new TextPaint(1);
            this.mKeyTextPaint.setColor(this.mKeyTextColor);
            this.mKeyTextPaint.setTextSize(this.mKeyTextSize);
            this.mKeyTextPaint.setFakeBoldText(true);
            this.mKeyTextPaint.setTextAlign(Paint.Align.CENTER);
            return this;
        }

        @Override
        protected void setDefaults(@NonNull Context context) {
            this.mKeyTextColor = context.getResources().getColor(R.color.lib_key_default_color);
            this.mKeyStrokeColor = context.getResources().getColor(R.color.lib_key_background_color);
            this.mKeyTextSize = context.getResources().getDimension(R.dimen.lib_key_text_size);
            this.mKeyStrokeWidth = context.getResources().getDimension(R.dimen.lib_key_stroke_width);
            this.mKeyPadding = this.getContext().getResources().getDimension(R.dimen.lib_key_padding);
            this.mRipplePaint = new Paint(1);
            this.mRipplePaint.setStyle(Paint.Style.FILL);
        }

        @Override
        @NonNull
        public Paint getKeyPaint() {
            return this.mKeyPaint;
        }

        @Override
        @NonNull
        public Paint getKeyTextPaint() {
            return this.mKeyTextPaint;
        }

        @NonNull
        protected Paint getRipplePaint() {
            return this.mRipplePaint;
        }

        @Override
        @NonNull
        public RoundKey getKey(@NonNull String digit, @NonNull Rect bound) {
            return new RoundKey(super.getPinView(), digit, bound, this);
        }
    }
}

