/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview.indicators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import com.kevalpatel.passcodeview.PinView;

public abstract class Indicator {
    private PinView mPinView;
    private Rect mBound;

    private Indicator() {
    }

    Indicator(@NonNull PinView pinView, @NonNull Rect bound, @NonNull Builder builder) {
        this.mPinView = pinView;
        this.mBound = bound;
    }

    protected final PinView getRootView() {
        return this.mPinView;
    }

    protected final Context getContext() {
        return this.mPinView.getContext();
    }

    public abstract void draw(@NonNull Canvas var1, boolean var2);

    public abstract void onAuthFailed();

    public abstract void onAuthSuccess();

    @NonNull
    public Rect getBound() {
        return this.mBound;
    }

    public static abstract class Builder {
        private PinView mPinView;

        private Builder() {
        }

        public Builder(@NonNull PinView pinView) {
            this.mPinView = pinView;
            this.setDefaults(pinView.getContext());
        }

        @NonNull
        protected final PinView getRootView() {
            return this.mPinView;
        }

        @NonNull
        protected final Context getContext() {
            return this.mPinView.getContext();
        }

        @Dimension
        public abstract float getIndicatorWidth();

        public abstract Builder build();

        protected abstract void setDefaults(@NonNull Context var1);

        public abstract Indicator getIndicator(@NonNull Rect var1);
    }
}

