/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview.indicators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import com.kevalpatel.passcodeview.PinView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.indicators.Indicator;

public final class DotIndicator
extends Indicator {
    @NonNull
    private final Builder mBuilder;
    private boolean isDisplayError;

    private DotIndicator(@NonNull PinView pinView, @NonNull Rect bound, @NonNull Builder builder) {
        super(pinView, bound, builder);
        this.mBuilder = builder;
    }

    @Override
    public void draw(@NonNull Canvas canvas, boolean isSelected) {
        canvas.drawCircle(this.getBound().exactCenterX(), this.getBound().exactCenterY(), this.mBuilder.getIndicatorRadius(), this.isDisplayError ? this.mBuilder.getErrorIndicatorPaint() : (isSelected ? this.mBuilder.getSelectedIndicatorPaint() : this.mBuilder.getNormalIndicatorPaint()));
    }

    @Override
    public void onAuthFailed() {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                DotIndicator.this.isDisplayError = false;
                DotIndicator.this.getRootView().invalidate();
            }
        }, 400L);
        this.isDisplayError = true;
    }

    @Override
    public void onAuthSuccess() {
    }

    public static class Builder
    extends Indicator.Builder {
        @ColorInt
        private int mIndicatorStrokeColor;
        @ColorInt
        private int mIndicatorFilledColor;
        @Dimension
        private float mIndicatorRadius;
        private Paint mEmptyIndicatorPaint;
        private Paint mSolidIndicatorPaint;
        private Paint mErrorIndicatorPaint;

        public Builder(@NonNull PinView pinView) {
            super(pinView);
        }

        @Override
        @Dimension
        public float getIndicatorWidth() {
            return this.mIndicatorRadius * 2.0f;
        }

        @Override
        public Builder build() {
            this.mEmptyIndicatorPaint = new Paint(1);
            this.mEmptyIndicatorPaint.setColor(this.mIndicatorStrokeColor);
            this.mSolidIndicatorPaint = new Paint(1);
            this.mSolidIndicatorPaint.setColor(this.mIndicatorFilledColor);
            this.mErrorIndicatorPaint = new Paint(1);
            this.mErrorIndicatorPaint.setColor(-65536);
            return this;
        }

        @Override
        protected void setDefaults(@NonNull Context context) {
            this.mIndicatorRadius = this.getContext().getResources().getDimension(R.dimen.lib_indicator_radius);
            this.mIndicatorFilledColor = this.getContext().getResources().getColor(R.color.lib_indicator_filled_color);
            this.mIndicatorStrokeColor = this.getContext().getResources().getColor(R.color.lib_indicator_stroke_color);
        }

        @Override
        public Indicator getIndicator(@NonNull Rect bound) {
            return new DotIndicator(this.getRootView(), bound, this);
        }

        @ColorInt
        public int getIndicatorStrokeColor() {
            return this.mIndicatorStrokeColor;
        }

        @NonNull
        public Builder setIndicatorStrokeColor(@ColorInt int indicatorStrokeColor) {
            this.mIndicatorStrokeColor = indicatorStrokeColor;
            return this;
        }

        @NonNull
        public Builder setIndicatorEmptyColorResource(@ColorRes int indicatorStrokeColor) {
            this.mIndicatorStrokeColor = this.getContext().getResources().getColor(indicatorStrokeColor);
            return this;
        }

        @ColorInt
        public int getIndicatorFilledColor() {
            return this.mIndicatorFilledColor;
        }

        @NonNull
        public Builder setIndicatorFilledColor(@ColorInt int indicatorFilledColor) {
            this.mIndicatorFilledColor = indicatorFilledColor;
            return this;
        }

        @NonNull
        public Builder setIndicatorFilledColorResource(@ColorRes int indicatorFilledColor) {
            this.mIndicatorFilledColor = this.getContext().getResources().getColor(indicatorFilledColor);
            return this;
        }

        @Dimension
        public float getIndicatorRadius() {
            return this.mIndicatorRadius;
        }

        @NonNull
        public Builder setIndicatorRadius(@DimenRes int indicatorRadius) {
            this.mIndicatorRadius = this.getContext().getResources().getDimension(indicatorRadius);
            return this;
        }

        @NonNull
        public Builder setIndicatorRadius(@Dimension float indicatorRadius) {
            this.mIndicatorRadius = indicatorRadius;
            return this;
        }

        @NonNull
        public Paint getNormalIndicatorPaint() {
            return this.mEmptyIndicatorPaint;
        }

        @NonNull
        public Paint getSelectedIndicatorPaint() {
            return this.mSolidIndicatorPaint;
        }

        @NonNull
        public Paint getErrorIndicatorPaint() {
            return this.mErrorIndicatorPaint;
        }
    }
}

