/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.kevalpatel.passcodeview.BoxPattern;
import com.kevalpatel.passcodeview.BoxTitle;
import com.kevalpatel.passcodeview.PasscodeView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.Utils;
import com.kevalpatel.passcodeview.patternCells.PatternCell;
import com.kevalpatel.passcodeview.patternCells.PatternPoint;
import java.util.ArrayList;

public final class PatternView
extends PasscodeView {
    private PatternPoint[] mCorrectPattern;
    private ArrayList<PatternCell> mPatternTyped;
    private float mPathEndX;
    private float mPathEndY;
    @ColorInt
    private int mPathColor;
    private BoxPattern mBoxPattern;
    private BoxTitle mBoxTitle;
    private Paint mNormalPaint;
    private Paint mErrorPaint;
    private boolean isErrorShowing = false;

    public PatternView(Context context) {
        super(context);
    }

    public PatternView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PatternView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        this.mPatternTyped = new ArrayList();
        this.mBoxPattern = new BoxPattern(this);
        this.mBoxTitle = new BoxTitle(this);
    }

    @Override
    protected void setDefaultParams() {
        this.mBoxTitle.setDefaults();
        this.mBoxPattern.setDefaults();
        this.mPathColor = this.mContext.getResources().getColor(17170453);
    }

    @Override
    protected void preparePaint() {
        this.mNormalPaint = new Paint(1);
        this.mNormalPaint.setStrokeWidth(10.0f);
        this.mNormalPaint.setColor(this.mPathColor);
        this.mErrorPaint = new Paint(1);
        this.mErrorPaint.setStrokeWidth(10.0f);
        this.mErrorPaint.setColor(-65536);
        this.mBoxPattern.preparePaint();
        this.mBoxTitle.preparePaint();
    }

    @Override
    protected void parseTypeArr(@NonNull AttributeSet typedArray) {
        TypedArray a = this.mContext.getTheme().obtainStyledAttributes(typedArray, R.styleable.PatternView, 0, 0);
        try {
            this.mBoxTitle.setTitle(a.hasValue(R.styleable.PatternView_titleText) ? a.getString(R.styleable.PatternView_titleText) : "Enter PIN");
            this.mBoxTitle.setTitleColor(a.getColor(R.styleable.PatternView_titleTextColor, this.mContext.getResources().getColor(R.color.lib_key_default_color)));
            this.mBoxPattern.setNoOfRows(a.getInt(R.styleable.PatternView_noOfRows, 3));
            this.mBoxPattern.setNoOfColumn(a.getInt(R.styleable.PatternView_noOfColumns, 3));
            this.mPathColor = a.getColor(R.styleable.PatternView_patternLineColor, this.mContext.getResources().getColor(17170453));
        }
        finally {
            a.recycle();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mBoxPattern.draw(canvas);
        this.mBoxTitle.draw(canvas);
        this.mBoxFingerprint.draw(canvas);
        this.drawPaths(canvas);
    }

    private void drawPaths(Canvas canvas) {
        if (this.mPatternTyped.size() == 0) {
            return;
        }
        int lastElementPos = this.mPatternTyped.size() - 1;
        for (int i = 0; i < lastElementPos; ++i) {
            PatternCell startCell = this.mPatternTyped.get(i);
            PatternCell endCell = this.mPatternTyped.get(i + 1);
            canvas.drawLine(startCell.getCenterX(), startCell.getCenterY(), endCell.getCenterX(), endCell.getCenterY(), this.isErrorShowing ? this.mErrorPaint : this.mNormalPaint);
        }
        canvas.drawLine(this.mPatternTyped.get(lastElementPos).getCenterX(), this.mPatternTyped.get(lastElementPos).getCenterY(), this.mPathEndX, this.mPathEndY, this.isErrorShowing ? this.mErrorPaint : this.mNormalPaint);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mBoxPattern.measure(this.mRootViewBound);
        this.mBoxTitle.measure(this.mRootViewBound);
        this.mBoxFingerprint.measure(this.mRootViewBound);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float touchX = event.getX();
        float touchY = event.getY();
        switch (event.getActionMasked()) {
            case 0: {
                this.reset();
            }
            case 2: {
                PatternCell cellNumber = this.mBoxPattern.findCell(touchX, touchY);
                if (cellNumber != null && !this.mPatternTyped.contains(cellNumber)) {
                    this.mPatternTyped.add(cellNumber);
                    if (this.isTactileFeedbackEnable()) {
                        Utils.giveTactileFeedbackForKeyPress(this.mContext);
                    }
                }
                this.mPathEndX = touchX;
                this.mPathEndY = touchY;
                this.invalidate();
                break;
            }
            case 1: {
                if (this.mPatternTyped.size() == 0) {
                    return true;
                }
                this.validatePattern();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        PatternView.this.reset();
                    }
                }, 350L);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void validatePattern() {
        if (this.mCorrectPattern.length == this.mPatternTyped.size() && Utils.isPatternMatched(this.mCorrectPattern, this.mPatternTyped)) {
            this.mBoxPattern.onAuthenticationSuccess();
            this.mBoxTitle.onAuthenticationSuccess();
            this.isErrorShowing = false;
            this.mAuthenticationListener.onAuthenticationSuccessful();
            if (this.isTactileFeedbackEnable()) {
                Utils.giveTactileFeedbackForAuthSuccess(this.mContext);
            }
        } else {
            this.mBoxPattern.onAuthenticationFail();
            this.mBoxTitle.onAuthenticationFail();
            this.isErrorShowing = true;
            this.mAuthenticationListener.onAuthenticationFailed();
            if (this.isTactileFeedbackEnable()) {
                Utils.giveTactileFeedbackForAuthFail(this.mContext);
            }
        }
        this.invalidate();
    }

    @Override
    public void reset() {
        this.isErrorShowing = false;
        this.mPatternTyped.clear();
        this.invalidate();
    }

    public boolean isOneHandOperationEnabled() {
        return this.mBoxPattern.isOneHandOperation();
    }

    public void enableOneHandOperation(boolean isEnable) {
        this.mBoxPattern.setOneHandOperation(isEnable);
        this.requestLayout();
        this.invalidate();
    }

    public void setCorrectPattern(@NonNull PatternPoint[] correctPattern) {
        this.mCorrectPattern = correctPattern;
        this.mPatternTyped.clear();
        this.invalidate();
    }

    public int getTitleColor() {
        return this.mBoxTitle.getTitleColor();
    }

    public void setTitleColor(@ColorInt int titleColor) {
        this.mBoxTitle.setTitleColor(titleColor);
        this.invalidate();
    }

    public void setTitleColorResource(@ColorRes int titleColor) {
        this.mBoxTitle.setTitleColor(this.mContext.getResources().getColor(titleColor));
        this.invalidate();
    }

    public int getPatternPathColor() {
        return this.mPathColor;
    }

    public void setPatternPathColor(@ColorInt int pathColor) {
        this.mPathColor = pathColor;
        this.invalidate();
    }

    public void setPatternPathColorResource(@ColorRes int pathColor) {
        this.mPathColor = this.mContext.getResources().getColor(pathColor);
        this.invalidate();
    }

    public String getTitle() {
        return this.mBoxTitle.getTitle();
    }

    public void setTitle(@NonNull String title) {
        this.mBoxTitle.setTitle(title);
        this.invalidate();
    }

    public void setPatternCell(@NonNull PatternCell.Builder indicatorBuilder) {
        this.mBoxPattern.setCellBuilder(indicatorBuilder);
        this.requestLayout();
        this.invalidate();
    }

    @Nullable
    public PatternCell.Builder getPatternCellBuilder() {
        return this.mBoxPattern.getCellBuilder();
    }

    public int getNoOfColumn() {
        return this.mBoxPattern.getNoOfColumn();
    }

    public void setNoOfColumn(int noOfColumn) {
        this.mBoxPattern.setNoOfColumn(noOfColumn);
        this.requestLayout();
        this.invalidate();
    }

    public int getNoOfRows() {
        return this.mBoxPattern.getNoOfRows();
    }

    public void setNoOfRows(int noOfRows) {
        this.mBoxPattern.setNoOfRows(noOfRows);
        this.requestLayout();
        this.invalidate();
    }
}

