/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.kevalpatel.passcodeview.BoxFingerprint;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.interfaces.AuthenticationListener;

public abstract class PasscodeView
extends View {
    protected final Context mContext;
    protected Rect mRootViewBound = new Rect();
    protected AuthenticationListener mAuthenticationListener;
    protected BoxFingerprint mBoxFingerprint;
    @ColorInt
    private int mDividerColor;
    private Paint mDividerPaint;
    private Rect mDividerBound = new Rect();
    private boolean mIsTactileFeedbackEnabled = true;

    public PasscodeView(Context context) {
        super(context);
        this.mContext = context;
        this.init(null);
    }

    public PasscodeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(attrs);
    }

    public PasscodeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init(attrs);
    }

    @RequiresApi(api=21)
    public PasscodeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mContext = context;
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        this.mBoxFingerprint = new BoxFingerprint(this);
        this.init();
        if (attrs != null) {
            TypedArray a = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.PasscodeView, 0, 0);
            try {
                this.mIsTactileFeedbackEnabled = a.getBoolean(R.styleable.PasscodeView_giveTactileFeedback, true);
                this.mDividerColor = a.getColor(R.styleable.PasscodeView_dividerColor, this.mContext.getResources().getColor(R.color.lib_divider_color));
                this.mBoxFingerprint.setStatusText(a.hasValue(R.styleable.PasscodeView_fingerprintDefaultText) ? a.getString(R.styleable.PasscodeView_fingerprintDefaultText) : "Scan your finger to authenticate");
                this.mBoxFingerprint.setStatusTextColor(a.getColor(R.styleable.PasscodeView_fingerprintTextColor, this.mContext.getResources().getColor(R.color.lib_key_default_color)));
                this.mBoxFingerprint.setStatusTextSize(a.getDimension(R.styleable.PasscodeView_fingerprintTextSize, (float)((int)this.mContext.getResources().getDimension(R.dimen.lib_fingerprint_status_text_size))));
                this.mBoxFingerprint.setFingerPrintEnable(a.getBoolean(R.styleable.PasscodeView_fingerprintEnable, true));
                this.parseTypeArr(attrs);
            }
            finally {
                a.recycle();
            }
        } else {
            this.setDividerColor(this.getResources().getColor(R.color.lib_divider_color));
            this.mBoxFingerprint.setDefaults();
            this.setDefaultParams();
        }
        this.prepareDividerPaint();
        this.mBoxFingerprint.preparePaint();
        this.preparePaint();
    }

    protected abstract void init();

    protected abstract void setDefaultParams();

    protected abstract void preparePaint();

    protected abstract void parseTypeArr(@NonNull AttributeSet var1);

    private void prepareDividerPaint() {
        this.mDividerPaint = new Paint(1);
        this.mDividerPaint.setColor(this.mDividerColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureMainView();
        this.measureDivider();
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void measureMainView() {
        this.getLocalVisibleRect(this.mRootViewBound);
        TypedValue tv = new TypedValue();
        if (this.mContext.getTheme().resolveAttribute(16843499, tv, true)) {
            this.mRootViewBound.top += TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
    }

    private void measureDivider() {
        this.mDividerBound.left = (int)((float)this.mRootViewBound.left + this.mContext.getResources().getDimension(R.dimen.lib_divider_horizontal_margin));
        this.mDividerBound.right = (int)((float)this.mRootViewBound.right - this.mContext.getResources().getDimension(R.dimen.lib_divider_horizontal_margin));
        this.mDividerBound.top = (int)((float)this.mRootViewBound.top + (float)this.mRootViewBound.height() * 0.2f - this.mContext.getResources().getDimension(R.dimen.lib_divider_vertical_margin));
        this.mDividerBound.bottom = (int)((float)this.mRootViewBound.top + (float)this.mRootViewBound.height() * 0.2f - this.mContext.getResources().getDimension(R.dimen.lib_divider_vertical_margin));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawDivider(canvas);
    }

    private void drawDivider(Canvas canvas) {
        canvas.drawLine((float)this.mDividerBound.left, (float)this.mDividerBound.top, (float)this.mDividerBound.right, (float)this.mDividerBound.bottom, this.mDividerPaint);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBoxFingerprint.stopFingerprintScanner();
    }

    public abstract void reset();

    @Nullable
    public AuthenticationListener getAuthenticationListener() {
        return this.mAuthenticationListener;
    }

    public void setAuthenticationListener(@NonNull AuthenticationListener authenticationListener) {
        this.mAuthenticationListener = authenticationListener;
        this.mBoxFingerprint.setAuthListener(authenticationListener);
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(@ColorInt int dividerColor) {
        this.mDividerColor = dividerColor;
        this.prepareDividerPaint();
        this.invalidate();
    }

    public boolean isTactileFeedbackEnable() {
        return this.mIsTactileFeedbackEnabled;
    }

    public void setTactileFeedback(boolean enable) {
        this.mIsTactileFeedbackEnabled = enable;
    }

    @NonNull
    public String getFingerPrintStatusText() {
        return this.mBoxFingerprint.getStatusText();
    }

    public void setFingerPrintStatusText(@NonNull String statusText) {
        this.mBoxFingerprint.setStatusText(statusText);
        this.invalidate();
    }

    public int getFingerPrintStatusTextColor() {
        return this.mBoxFingerprint.getStatusTextColor();
    }

    public void setFingerPrintStatusTextColor(@ColorInt int statusTextColor) {
        this.mBoxFingerprint.setStatusTextColor(statusTextColor);
        this.invalidate();
    }

    public void setFingerPrintStatusTextColorRes(@ColorRes int statusTextColor) {
        this.mBoxFingerprint.setStatusTextColor(this.mContext.getResources().getColor(statusTextColor));
        this.invalidate();
    }

    public float getFingerPrintStatusTextSize() {
        return this.mBoxFingerprint.getStatusTextSize();
    }

    public void setFingerPrintStatusTextSize(@Dimension float statusTextSize) {
        this.mBoxFingerprint.setStatusTextSize(statusTextSize);
        this.invalidate();
    }

    public void setFingerPrintStatusTextSize(@DimenRes int statusTextSize) {
        this.mBoxFingerprint.setStatusTextSize(this.getResources().getDimension(statusTextSize));
        this.invalidate();
    }

    public Boolean isFingerPrintEnable() {
        return this.mBoxFingerprint.isFingerPrintEnable();
    }

    public void setIsFingerPrintEnable(boolean isEnable) {
        this.mBoxFingerprint.setFingerPrintEnable(isEnable);
        this.requestLayout();
        this.invalidate();
    }
}

