/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.kevalpatel.passcodeview.Box;
import com.kevalpatel.passcodeview.PasscodeView;
import com.kevalpatel.passcodeview.patternCells.PatternCell;
import java.util.ArrayList;

final class BoxPattern
extends Box {
    private boolean mIsOneHandOperation = false;
    private int mNoOfColumn;
    private int mNoOfRows;
    private ArrayList<PatternCell> mPatternCells;
    private Rect mPatternBoxBound = new Rect();
    private PatternCell.Builder mCellBuilder;

    BoxPattern(@NonNull PasscodeView passcodeView) {
        super(passcodeView);
    }

    @Override
    void measure(@NonNull Rect rootViewBound) {
        this.mPatternBoxBound.left = this.mIsOneHandOperation ? (int)((double)rootViewBound.width() * 0.3) : 0;
        this.mPatternBoxBound.right = rootViewBound.width();
        this.mPatternBoxBound.top = (int)((float)rootViewBound.top + (float)rootViewBound.height() * 0.2f);
        this.mPatternBoxBound.bottom = (int)((float)rootViewBound.bottom - (float)rootViewBound.height() * (this.getRootView().isFingerPrintEnable() != false ? 0.14f : 0.0f));
        float singleIndicatorHeight = this.mPatternBoxBound.height() / this.mNoOfRows;
        float singleIndicatorWidth = this.mPatternBoxBound.width() / this.mNoOfColumn;
        this.mPatternCells = new ArrayList();
        int i = 0;
        for (int colNo = 0; colNo < this.mNoOfColumn; ++colNo) {
            for (int rowNo = 0; rowNo < this.mNoOfRows; ++rowNo) {
                Rect indicatorBound = new Rect();
                indicatorBound.left = (int)((float)colNo * singleIndicatorWidth + (float)this.mPatternBoxBound.left);
                indicatorBound.right = (int)((float)indicatorBound.left + singleIndicatorWidth);
                indicatorBound.top = (int)((float)rowNo * singleIndicatorHeight + (float)this.mPatternBoxBound.top);
                indicatorBound.bottom = (int)((float)indicatorBound.top + singleIndicatorHeight);
                this.mPatternCells.add(this.mCellBuilder.getCell(indicatorBound, new Point(rowNo, colNo)));
                ++i;
            }
        }
    }

    @Override
    void preparePaint() {
    }

    @Override
    void setDefaults() {
        this.mNoOfRows = 3;
        this.mNoOfColumn = 3;
    }

    @Override
    void onAuthenticationFail() {
        for (PatternCell patternCell : this.mPatternCells) {
            patternCell.onAuthFailed();
        }
        this.getRootView().invalidate();
    }

    @Override
    void onAuthenticationSuccess() {
        for (PatternCell patternCell : this.mPatternCells) {
            patternCell.onAuthSuccess();
        }
        this.getRootView().invalidate();
    }

    @Override
    void draw(@NonNull Canvas canvas) {
        for (PatternCell patternCell : this.mPatternCells) {
            patternCell.draw(canvas);
        }
    }

    @Nullable
    PatternCell findCell(float touchX, float touchY) {
        for (PatternCell patternCell : this.mPatternCells) {
            if (!patternCell.isIndicatorTouched(touchX, touchY)) continue;
            return patternCell;
        }
        return null;
    }

    ArrayList<PatternCell> getPatternCells() {
        return this.mPatternCells;
    }

    Rect getBounds() {
        return this.mPatternBoxBound;
    }

    boolean isOneHandOperation() {
        return this.mIsOneHandOperation;
    }

    void setOneHandOperation(boolean oneHandOperation) {
        this.mIsOneHandOperation = oneHandOperation;
    }

    PatternCell.Builder getCellBuilder() {
        return this.mCellBuilder;
    }

    void setCellBuilder(@NonNull PatternCell.Builder mIndicatorBuilder) {
        this.mCellBuilder = mIndicatorBuilder;
    }

    public int getNoOfColumn() {
        return this.mNoOfColumn;
    }

    public void setNoOfColumn(int noOfColumn) {
        this.mNoOfColumn = noOfColumn;
    }

    public int getNoOfRows() {
        return this.mNoOfRows;
    }

    public void setNoOfRows(int noOfRows) {
        this.mNoOfRows = noOfRows;
    }
}

