/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview.keys;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.view.animation.CycleInterpolator;
import com.kevalpatel.passcodeview.PinView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.Utils;
import com.kevalpatel.passcodeview.keys.Key;

public final class RectKey
extends Key {
    private final Rect mBounds;
    private final Builder mBuilder;
    private final ValueAnimator mErrorAnimator;
    private boolean isClickedAnimationRunning = false;

    private RectKey(@NonNull PinView pinView, @NonNull String digit, @NonNull Rect bounds, @NonNull Builder builder) {
        super(pinView, digit, bounds, builder);
        this.mBounds = bounds;
        this.mBuilder = builder;
        this.mErrorAnimator = ValueAnimator.ofInt((int[])new int[]{0, 10});
        this.mErrorAnimator.setInterpolator((TimeInterpolator)new CycleInterpolator(2.0f));
        this.mErrorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((RectKey)RectKey.this).mBounds.left += ((Integer)animation.getAnimatedValue()).intValue();
                ((RectKey)RectKey.this).mBounds.right += ((Integer)animation.getAnimatedValue()).intValue();
                RectKey.this.getPinView().invalidate();
            }
        });
    }

    @Override
    public void playClickAnimation() {
        this.isClickedAnimationRunning = true;
        this.getPinView().invalidate();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                RectKey.this.isClickedAnimationRunning = false;
                RectKey.this.getPinView().invalidate();
            }
        }, 200L);
    }

    @Override
    public void onAuthFail() {
        this.mErrorAnimator.start();
    }

    @Override
    public void drawText(@NonNull Canvas canvas) {
        canvas.drawText(this.getDigit() + "", this.mBounds.exactCenterX(), this.mBounds.exactCenterY() - (this.mBuilder.getKeyTextPaint().descent() + this.mBuilder.getKeyTextPaint().ascent()) / 2.0f, this.mBuilder.getKeyTextPaint());
    }

    @Override
    public void drawShape(@NonNull Canvas canvas) {
        canvas.drawRect((float)this.mBounds.left + this.mBuilder.getKeyPadding(), (float)this.mBounds.top + this.mBuilder.getKeyPadding(), (float)this.mBounds.right - this.mBuilder.getKeyPadding(), (float)this.mBounds.bottom - this.mBuilder.getKeyPadding(), this.isClickedAnimationRunning ? this.mBuilder.getClickPaint() : this.mBuilder.getKeyPaint());
    }

    @Override
    public void drawBackSpace(@NonNull Canvas canvas, @NonNull Drawable backSpaceIcon) {
        backSpaceIcon.setBounds((int)(this.mBounds.exactCenterX() - (float)(Math.min(this.mBounds.height(), this.mBounds.width()) / 3)), (int)(this.mBounds.exactCenterY() - (float)(Math.min(this.mBounds.height(), this.mBounds.width()) / 3)), (int)(this.mBounds.exactCenterX() + (float)(Math.min(this.mBounds.height(), this.mBounds.width()) / 3)), (int)(this.mBounds.exactCenterY() + (float)(Math.min(this.mBounds.height(), this.mBounds.width()) / 3)));
        backSpaceIcon.draw(canvas);
    }

    @Override
    public boolean isKeyPressed(float touchX, float touchY) {
        return touchX > (float)this.mBounds.left && touchX < (float)this.mBounds.right && touchY > (float)this.mBounds.top && touchY < (float)this.mBounds.bottom;
    }

    @Override
    public void onAuthSuccess() {
    }

    public static class Builder
    extends Key.Builder {
        @Dimension
        private float mKeyPadding;
        @Dimension
        private float mKeyTextSize;
        @Dimension
        private float mKeyStrokeWidth;
        @ColorInt
        private int mKeyStrokeColor;
        @ColorInt
        private int mKeyTextColor;
        @NonNull
        private Paint mKeyPaint;
        @NonNull
        private TextPaint mKeyTextPaint;
        private Paint mClickPaint;

        public Builder(@NonNull PinView pinView) {
            super(pinView);
        }

        @Dimension
        public float getKeyPadding() {
            return this.mKeyPadding;
        }

        public Builder setKeyPadding(@DimenRes int keyPaddingRes) {
            this.mKeyPadding = this.getContext().getResources().getDimension(keyPaddingRes);
            return this;
        }

        public Builder setKeyPadding(@Dimension float keyPadding) {
            this.mKeyPadding = keyPadding;
            return this;
        }

        public float getKeyTextSize() {
            return this.mKeyTextSize;
        }

        public Builder setKeyTextSize(@DimenRes int keyTextSize) {
            this.mKeyTextSize = this.getContext().getResources().getDimension(keyTextSize);
            return this;
        }

        public Builder setKeyTextSize(float keyTextSize) {
            this.mKeyTextSize = keyTextSize;
            return this;
        }

        public float getKeyStrokeWidth() {
            return this.mKeyStrokeWidth;
        }

        @Dimension
        public Builder setKeyStrokeWidth(@DimenRes int keyStrokeWidth) {
            this.mKeyStrokeWidth = this.getContext().getResources().getDimension(keyStrokeWidth);
            return this;
        }

        @Dimension
        public Builder setKeyStrokeWidth(float keyStrokeWidth) {
            this.mKeyStrokeWidth = keyStrokeWidth;
            return this;
        }

        @ColorInt
        public int getKeyStrokeColor() {
            return this.mKeyStrokeColor;
        }

        public Builder setKeyStrokeColor(@ColorInt int keyStrokeColor) {
            this.mKeyStrokeColor = keyStrokeColor;
            return this;
        }

        public Builder setKeyStrokeColorResource(@ColorRes int keyStrokeColor) {
            this.mKeyStrokeColor = this.getContext().getResources().getColor(keyStrokeColor);
            return this;
        }

        @ColorInt
        public int getKeyTextColor() {
            return this.mKeyTextColor;
        }

        public Builder setKeyTextColor(@ColorInt int keyTextColor) {
            this.mKeyTextColor = keyTextColor;
            return this;
        }

        public Builder setKeyTextColorResource(@ColorRes int keyTextColor) {
            this.mKeyTextColor = this.getContext().getResources().getColor(keyTextColor);
            return this;
        }

        @Override
        public Builder build() {
            this.mKeyPaint = new Paint(1);
            this.mKeyPaint.setStyle(Paint.Style.STROKE);
            this.mKeyPaint.setColor(this.mKeyStrokeColor);
            this.mKeyPaint.setTextSize(this.mKeyTextSize);
            this.mKeyPaint.setStrokeWidth(this.mKeyStrokeWidth);
            this.mKeyTextPaint = new TextPaint(1);
            this.mKeyTextPaint.setColor(this.mKeyTextColor);
            this.mKeyTextPaint.setTextSize(this.mKeyTextSize);
            this.mKeyTextPaint.setFakeBoldText(true);
            this.mKeyTextPaint.setTextAlign(Paint.Align.CENTER);
            this.mClickPaint = new Paint(1);
            this.mClickPaint.setStyle(Paint.Style.STROKE);
            this.mClickPaint.setColor(Utils.makeColorDark(this.mKeyStrokeColor));
            this.mClickPaint.setStrokeWidth(this.mKeyStrokeWidth);
            return this;
        }

        @Override
        protected void setDefaults(@NonNull Context context) {
            this.mKeyTextColor = context.getResources().getColor(R.color.lib_key_default_color);
            this.mKeyStrokeColor = context.getResources().getColor(R.color.lib_key_background_color);
            this.mKeyTextSize = context.getResources().getDimension(R.dimen.lib_key_text_size);
            this.mKeyStrokeWidth = context.getResources().getDimension(R.dimen.lib_key_stroke_width);
            this.mKeyPadding = this.getContext().getResources().getDimension(R.dimen.lib_key_padding);
        }

        @Override
        @NonNull
        public Paint getKeyPaint() {
            return this.mKeyPaint;
        }

        @Override
        @NonNull
        public Paint getKeyTextPaint() {
            return this.mKeyTextPaint;
        }

        @NonNull
        protected Paint getClickPaint() {
            return this.mClickPaint;
        }

        @Override
        @NonNull
        public RectKey getKey(@NonNull String digit, @NonNull Rect bound) {
            return new RectKey(super.getPinView(), digit, bound, this);
        }
    }
}

