/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview.keys;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import com.kevalpatel.passcodeview.PinView;

public abstract class Key {
    @NonNull
    private PinView mView;
    private String mDigit;

    private Key() {
    }

    protected Key(@NonNull PinView view, @NonNull String digit, @NonNull Rect bounds, @NonNull Builder builder) {
        this.mView = view;
        this.mDigit = digit;
    }

    public abstract void drawText(@NonNull Canvas var1);

    public abstract void drawShape(@NonNull Canvas var1);

    public abstract void drawBackSpace(@NonNull Canvas var1, @NonNull Drawable var2);

    public final String getDigit() {
        return this.mDigit;
    }

    @NonNull
    public final PinView getPinView() {
        return this.mView;
    }

    @NonNull
    public final Context getContext() {
        return this.mView.getContext();
    }

    public abstract void onAuthFail();

    public abstract void onAuthSuccess();

    public abstract boolean isKeyPressed(float var1, float var2);

    public abstract void playClickAnimation();

    public static abstract class Builder {
        private PinView mPinView;

        private Builder() {
        }

        protected Builder(PinView pinView) {
            this.mPinView = pinView;
            this.setDefaults(pinView.getContext());
        }

        @NonNull
        protected final PinView getPinView() {
            return this.mPinView;
        }

        @NonNull
        protected final Context getContext() {
            return this.mPinView.getContext();
        }

        public abstract Builder build();

        protected abstract void setDefaults(@NonNull Context var1);

        @NonNull
        public abstract Paint getKeyPaint();

        @NonNull
        public abstract Paint getKeyTextPaint();

        @NonNull
        public abstract Key getKey(@NonNull String var1, @NonNull Rect var2);
    }
}

