/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.RequiresPermission;
import java.util.ArrayList;

public final class Utils {
    private Utils() {
    }

    public static void openSecuritySettings(@NonNull Context context) {
        Intent intent = new Intent("android.settings.SECURITY_SETTINGS");
        context.startActivity(intent);
    }

    @RequiresApi(api=23)
    @RequiresPermission(allOf={"android.permission.USE_FINGERPRINT"})
    public static boolean isSupportedHardware(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        FingerprintManager fingerprintManager = (FingerprintManager)context.getSystemService("fingerprint");
        return fingerprintManager.isHardwareDetected();
    }

    public static boolean isFingerPrintEnrolled(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            FingerprintManager fingerprintManager = (FingerprintManager)context.getSystemService("fingerprint");
            return fingerprintManager.isHardwareDetected() && fingerprintManager.hasEnrolledFingerprints();
        }
        return false;
    }

    static boolean isValidPin(int[] pinToCheck) {
        for (int i : pinToCheck) {
            if (i <= 9 || i >= 0) continue;
            return false;
        }
        return true;
    }

    static boolean isPINMatched(int[] correctPin, ArrayList<Integer> pinToCheck) {
        for (int i = 0; i < correctPin.length; ++i) {
            if (correctPin[i] == pinToCheck.get(i)) continue;
            return false;
        }
        return correctPin.length == pinToCheck.size();
    }

    @ColorInt
    public static int makeColorDark(@ColorInt int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = 1.0f - 0.8f * hsv[2];
        return Color.HSVToColor((float[])hsv);
    }
}

