/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Vibrator;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.kevalpatel.passcodeview.BoxFingerprint;
import com.kevalpatel.passcodeview.BoxKeypad;
import com.kevalpatel.passcodeview.BoxTitleIndicator;
import com.kevalpatel.passcodeview.InteractiveArrayList;
import com.kevalpatel.passcodeview.KeyNamesBuilder;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.Utils;
import com.kevalpatel.passcodeview.indicators.Indicator;
import com.kevalpatel.passcodeview.interfaces.AuthenticationListener;
import com.kevalpatel.passcodeview.keys.Key;

public class PinView
extends View
implements InteractiveArrayList.ChangeListener {
    private Context mContext;
    private float mDownKeyX;
    private float mDownKeyY;
    private AuthenticationListener mAuthenticationListener;
    private int[] mCorrectPin;
    private InteractiveArrayList<Integer> mPinTyped = new InteractiveArrayList();
    private Rect mRootViewBound = new Rect();
    private Rect mDividerBound = new Rect();
    @ColorInt
    private int mDividerColor;
    private boolean mIsTactileFeedbackREnabled = true;
    private Paint mDividerPaint;
    private BoxKeypad mBoxKeypad;
    private BoxFingerprint mBoxFingerprint;
    private BoxTitleIndicator mBoxIndicator;

    public PinView(Context context) {
        super(context);
        this.init(context, null);
    }

    public PinView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PinView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        this.mContext = context;
        this.mPinTyped.setChangeListener(this);
        this.mBoxKeypad = new BoxKeypad(this);
        this.mBoxFingerprint = new BoxFingerprint(this);
        this.mBoxIndicator = new BoxTitleIndicator(this);
        if (attrs != null) {
            this.parseTypeArr(attrs);
        } else {
            this.mDividerColor = this.getResources().getColor(R.color.lib_divider_color);
            this.mBoxIndicator.setDefaults();
            this.mBoxKeypad.setDefaults();
            this.mBoxFingerprint.setDefaults();
        }
        this.prepareDividerPaint();
        this.mBoxKeypad.preparePaint();
        this.mBoxFingerprint.preparePaint();
        this.mBoxIndicator.preparePaint();
    }

    private void parseTypeArr(@Nullable AttributeSet attrs) {
        TypedArray a = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.PinView, 0, 0);
        try {
            this.mIsTactileFeedbackREnabled = a.getBoolean(R.styleable.PinView_giveTactileFeedback, true);
            this.mBoxIndicator.setTitle(a.hasValue(R.styleable.PinView_titleText) ? a.getString(R.styleable.PinView_titleText) : "Enter PIN");
            this.mBoxIndicator.setTitleColor(a.getColor(R.styleable.PinView_titleTextColor, this.mContext.getResources().getColor(R.color.lib_key_default_color)));
            this.mDividerColor = a.getColor(R.styleable.PinView_dividerColor, this.mContext.getResources().getColor(R.color.lib_divider_color));
            this.mBoxFingerprint.setStatusText(a.hasValue(R.styleable.PinView_titleText) ? a.getString(R.styleable.PinView_fingerprintDefaultText) : "Scan your finger to authenticate");
            this.mBoxFingerprint.setStatusTextColor(a.getColor(R.styleable.PinView_fingerprintTextColor, this.mContext.getResources().getColor(R.color.lib_key_default_color)));
            this.mBoxFingerprint.setStatusTextSize(a.getDimension(R.styleable.PinView_fingerprintTextSize, (float)((int)this.mContext.getResources().getDimension(R.dimen.lib_fingerprint_status_text_size))));
            this.mBoxFingerprint.setFingerPrintEnable(a.getBoolean(R.styleable.PinView_fingerprintEnable, true));
        }
        finally {
            a.recycle();
        }
    }

    private void prepareDividerPaint() {
        this.mDividerPaint = new Paint(1);
        this.mDividerPaint.setColor(this.mDividerColor);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mBoxKeypad.draw(canvas);
        this.drawDivider(canvas);
        this.mBoxIndicator.draw(canvas);
        this.mBoxFingerprint.draw(canvas);
    }

    private void drawDivider(Canvas canvas) {
        canvas.drawLine((float)this.mDividerBound.left, (float)this.mDividerBound.top, (float)this.mDividerBound.right, (float)this.mDividerBound.bottom, this.mDividerPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureMainView();
        this.mBoxKeypad.measure(this.mRootViewBound);
        this.measureDivider();
        this.mBoxIndicator.measure(this.mRootViewBound);
        this.mBoxFingerprint.measure(this.mRootViewBound);
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private Rect measureMainView() {
        this.getLocalVisibleRect(this.mRootViewBound);
        TypedValue tv = new TypedValue();
        if (this.mContext.getTheme().resolveAttribute(16843499, tv, true)) {
            this.mRootViewBound.top += TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
        return this.mRootViewBound;
    }

    private void measureDivider() {
        this.mDividerBound.left = (int)((float)this.mRootViewBound.left + this.mContext.getResources().getDimension(R.dimen.lib_divider_horizontal_margin));
        this.mDividerBound.right = (int)((float)this.mRootViewBound.right - this.mContext.getResources().getDimension(R.dimen.lib_divider_horizontal_margin));
        this.mDividerBound.top = (int)((float)this.mBoxKeypad.getBounds().top - this.mContext.getResources().getDimension(R.dimen.lib_divider_vertical_margin));
        this.mDividerBound.bottom = (int)((float)this.mBoxKeypad.getBounds().top - this.mContext.getResources().getDimension(R.dimen.lib_divider_vertical_margin));
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mDownKeyX = event.getX();
                this.mDownKeyY = event.getY();
                break;
            }
            case 1: {
                this.onKeyPressed(this.mBoxKeypad.findKeyPressed(this.mDownKeyX, this.mDownKeyY, event.getX(), event.getY()));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void onKeyPressed(@Nullable String newDigit) {
        if (newDigit == null) {
            return;
        }
        if (this.mAuthenticationListener == null) {
            throw new IllegalStateException("Set AuthenticationListener to receive callbacks.");
        }
        if (this.mCorrectPin == null || this.mCorrectPin.length == 0) {
            throw new IllegalStateException("Please set current PIN to check with the entered value.");
        }
        if (newDigit.equals("-1")) {
            if (this.mPinTyped.size() > 0) {
                this.mPinTyped.remove(this.mPinTyped.size() - 1);
            }
        } else {
            this.mPinTyped.add(this.mBoxKeypad.getKeyNameBuilder().getValueOfKey(newDigit));
        }
        this.invalidate();
        if (this.mCorrectPin.length == this.mPinTyped.size()) {
            if (Utils.isPINMatched(this.mCorrectPin, this.mPinTyped)) {
                this.giveTactileFeedbackForAuthSuccess();
                this.mAuthenticationListener.onAuthenticationSuccessful();
                this.mBoxKeypad.onAuthenticationSuccess();
                this.mBoxIndicator.onAuthenticationSuccess();
                this.mBoxFingerprint.onAuthenticationSuccess();
            } else {
                this.giveTactileFeedbackForAuthFail();
                this.mAuthenticationListener.onAuthenticationFailed();
                this.mBoxFingerprint.onAuthenticationFail();
                this.mBoxKeypad.onAuthenticationFail();
                this.mBoxIndicator.onAuthenticationFail();
            }
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    PinView.this.reset();
                }
            }, 350L);
        } else {
            this.giveTactileFeedbackForKeyPress();
        }
    }

    private void giveTactileFeedbackForKeyPress() {
        if (!this.mIsTactileFeedbackREnabled) {
            return;
        }
        Vibrator v = (Vibrator)this.mContext.getSystemService("vibrator");
        if (v.hasVibrator()) {
            v.vibrate(50L);
        }
    }

    private void giveTactileFeedbackForAuthFail() {
        if (!this.mIsTactileFeedbackREnabled) {
            return;
        }
        Vibrator v = (Vibrator)this.mContext.getSystemService("vibrator");
        if (v.hasVibrator()) {
            v.vibrate(350L);
        }
    }

    private void giveTactileFeedbackForAuthSuccess() {
        if (!this.mIsTactileFeedbackREnabled) {
            return;
        }
        Vibrator v = (Vibrator)this.mContext.getSystemService("vibrator");
        if (v.hasVibrator()) {
            v.vibrate(new long[]{50L, 100L, 50L, 100L}, -1);
        }
    }

    public void reset() {
        this.mPinTyped.clear();
        this.invalidate();
    }

    @Override
    public void onArrayValueChange(int size) {
        this.mBoxIndicator.onPinDigitEntered(size);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBoxFingerprint.stopFingerprintScanner();
    }

    public boolean isOneHandOperationEnabled() {
        return this.mBoxKeypad.isOneHandOperation();
    }

    public void enableOneHandOperation(boolean isEnable) {
        this.mBoxKeypad.setOneHandOperation(isEnable);
        this.requestLayout();
        this.invalidate();
    }

    public void setCorrectPin(@NonNull int[] correctPin) {
        if (!Utils.isValidPin(correctPin)) {
            throw new IllegalArgumentException("Invalid PIN.");
        }
        this.mCorrectPin = correctPin;
        this.mBoxIndicator.setPinLength(this.mCorrectPin.length);
        this.mPinTyped.clear();
        this.invalidate();
    }

    @Nullable
    public AuthenticationListener getAuthenticationListener() {
        return this.mAuthenticationListener;
    }

    public void setAuthenticationListener(@NonNull AuthenticationListener authenticationListener) {
        this.mAuthenticationListener = authenticationListener;
        this.mBoxFingerprint.setAuthListener(authenticationListener);
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(@ColorInt int dividerColor) {
        this.mDividerColor = dividerColor;
        this.prepareDividerPaint();
        this.invalidate();
    }

    public int getTitleColor() {
        return this.mBoxIndicator.getTitleColor();
    }

    public void setTitleColor(@ColorInt int titleColor) {
        this.mBoxIndicator.setTitleColor(titleColor);
        this.invalidate();
    }

    public String getTitle() {
        return this.mBoxIndicator.getTitle();
    }

    public void setTitle(@NonNull String title) {
        this.mBoxIndicator.setTitle(title);
        this.invalidate();
    }

    @NonNull
    public String getFingerPrintStatusText() {
        return this.mBoxFingerprint.getStatusText();
    }

    public void setFingerPrintStatusText(@NonNull String statusText) {
        this.mBoxFingerprint.setStatusText(statusText);
        this.invalidate();
    }

    public int getFingerPrintStatusTextColor() {
        return this.mBoxFingerprint.getStatusTextColor();
    }

    public void setFingerPrintStatusTextColor(@ColorInt int statusTextColor) {
        this.mBoxFingerprint.setStatusTextColor(statusTextColor);
        this.invalidate();
    }

    public void setFingerPrintStatusTextColorRes(@ColorRes int statusTextColor) {
        this.mBoxFingerprint.setStatusTextColor(this.mContext.getResources().getColor(statusTextColor));
        this.invalidate();
    }

    public float getFingerPrintStatusTextSize() {
        return this.mBoxFingerprint.getStatusTextSize();
    }

    public void setFingerPrintStatusTextSize(@Dimension float statusTextSize) {
        this.mBoxFingerprint.setStatusTextSize(statusTextSize);
        this.invalidate();
    }

    public void setFingerPrintStatusTextSize(@DimenRes int statusTextSize) {
        this.mBoxFingerprint.setStatusTextSize(this.getResources().getDimension(statusTextSize));
        this.invalidate();
    }

    public Boolean isFingerPrintEnable() {
        return this.mBoxFingerprint.isFingerPrintEnable();
    }

    public void setIsFingerPrintEnable(boolean isEnable) {
        this.mBoxFingerprint.setFingerPrintEnable(isEnable);
        this.invalidate();
    }

    @Nullable
    public Key.Builder getKeyBuilder() {
        return this.mBoxKeypad.getKeyBuilder();
    }

    public void setIndicator(@NonNull Indicator.Builder indicatorBuilder) {
        this.mBoxIndicator.setIndicatorBuilder(indicatorBuilder);
        this.requestLayout();
        this.invalidate();
    }

    @Nullable
    public Indicator.Builder getIndicatorBuilder() {
        return this.mBoxIndicator.getIndicatorBuilder();
    }

    public void setKey(@NonNull Key.Builder keyBuilder) {
        this.mBoxKeypad.setKeyBuilder(keyBuilder);
        this.requestLayout();
        this.invalidate();
    }

    public void setKeyNames(@NonNull KeyNamesBuilder keyNames) {
        BoxKeypad.setKeyNames(keyNames);
        this.mPinTyped.clear();
        this.requestLayout();
        this.invalidate();
    }

    public int[] getCurrentTypedPin() {
        int[] arr = new int[this.mPinTyped.size()];
        for (int i = 0; i < this.mPinTyped.size(); ++i) {
            arr[i] = (Integer)this.mPinTyped.get(i);
        }
        return arr;
    }

    public void setCurrentTypedPin(int[] currentTypedPin) {
        if (this.mCorrectPin.length == 0) {
            throw new IllegalStateException("You must call setCorrectPin() before calling this method.");
        }
        if (currentTypedPin.length > this.mCorrectPin.length) {
            throw new IllegalArgumentException("Invalid pin length.");
        }
        this.mPinTyped.clear();
        for (int i : currentTypedPin) {
            this.mPinTyped.add(i);
        }
        this.requestLayout();
        this.invalidate();
    }

    public boolean isTactileFeedbackEnable() {
        return this.mIsTactileFeedbackREnabled;
    }

    public void setTactileFeedback(boolean enable) {
        this.mIsTactileFeedbackREnabled = enable;
    }
}

