/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.support.annotation.NonNull;
import java.util.ArrayList;

final class InteractiveArrayList<E>
extends ArrayList<E> {
    private ChangeListener mChangeListener;

    InteractiveArrayList() {
    }

    void setChangeListener(@NonNull ChangeListener listener) {
        this.mChangeListener = listener;
    }

    @Override
    public boolean add(E e) {
        boolean b = super.add(e);
        this.mChangeListener.onArrayValueChange(this.size());
        return b;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = super.remove(o);
        this.mChangeListener.onArrayValueChange(this.size());
        return b;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.mChangeListener.onArrayValueChange(this.size());
    }

    @Override
    public E remove(int index) {
        this.mChangeListener.onArrayValueChange(this.size() - 1);
        return super.remove(index);
    }

    @Override
    public void clear() {
        super.clear();
        this.mChangeListener.onArrayValueChange(this.size());
    }

    public static interface ChangeListener {
        public void onArrayValueChange(int var1);
    }
}

