/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.CancellationSignal;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

final class FingerPrintAuthHelper {
    static final int RECOVERABLE_ERROR = 843;
    static final int NON_RECOVERABLE_ERROR = 566;
    static final int CANNOT_RECOGNIZE_ERROR = 456;
    private static final String KEY_NAME = UUID.randomUUID().toString();
    private static final String ERROR_FAILED_TO_GENERATE_KEY = "Failed to generate secrete key for authentication.";
    private static final String ERROR_FAILED_TO_INIT_CHIPPER = "Failed to generate cipher key for authentication.";
    private KeyStore mKeyStore;
    private Cipher mCipher;
    private Context mContext;
    private FingerPrintAuthCallback mCallback;
    private CancellationSignal mCancellationSignal;
    private boolean isScanning;

    FingerPrintAuthHelper(@NonNull Context context, @NonNull FingerPrintAuthCallback callback) {
        this.mCallback = callback;
        this.mContext = context;
    }

    private FingerPrintAuthHelper() {
    }

    private boolean checkFingerPrintAvailability(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            FingerprintManager fingerprintManager = (FingerprintManager)context.getSystemService("fingerprint");
            if (!fingerprintManager.isHardwareDetected()) {
                return false;
            }
            return fingerprintManager.hasEnrolledFingerprints();
        }
        return false;
    }

    @TargetApi(value=23)
    private boolean generateKey() {
        KeyGenerator keyGenerator;
        this.mKeyStore = null;
        try {
            this.mKeyStore = KeyStore.getInstance("AndroidKeyStore");
            keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            return false;
        }
        catch (KeyStoreException e) {
            return false;
        }
        try {
            this.mKeyStore.load(null);
            keyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(KEY_NAME, 3).setBlockModes(new String[]{"CBC"}).setUserAuthenticationRequired(true).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build());
            keyGenerator.generateKey();
            return true;
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertificateException e) {
            return false;
        }
    }

    @TargetApi(value=23)
    private boolean cipherInit() {
        boolean isKeyGenerated = this.generateKey();
        if (!isKeyGenerated) {
            this.mCallback.onFingerprintAuthFailed(566, ERROR_FAILED_TO_GENERATE_KEY);
            return false;
        }
        try {
            this.mCipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            this.mCallback.onFingerprintAuthFailed(566, ERROR_FAILED_TO_GENERATE_KEY);
            return false;
        }
        try {
            this.mKeyStore.load(null);
            SecretKey key = (SecretKey)this.mKeyStore.getKey(KEY_NAME, null);
            this.mCipher.init(1, key);
            return true;
        }
        catch (KeyPermanentlyInvalidatedException e) {
            this.mCallback.onFingerprintAuthFailed(566, ERROR_FAILED_TO_INIT_CHIPPER);
            return false;
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            this.mCallback.onFingerprintAuthFailed(566, ERROR_FAILED_TO_INIT_CHIPPER);
            return false;
        }
    }

    @TargetApi(value=23)
    @Nullable
    private FingerprintManager.CryptoObject getCryptoObject() {
        return this.cipherInit() ? new FingerprintManager.CryptoObject(this.mCipher) : null;
    }

    @TargetApi(value=23)
    void startAuth() {
        if (this.isScanning) {
            this.stopAuth();
        }
        if (!this.checkFingerPrintAvailability(this.mContext)) {
            return;
        }
        FingerprintManager fingerprintManager = (FingerprintManager)this.mContext.getSystemService("fingerprint");
        FingerprintManager.CryptoObject cryptoObject = this.getCryptoObject();
        if (cryptoObject == null) {
            this.mCallback.onFingerprintAuthFailed(566, ERROR_FAILED_TO_INIT_CHIPPER);
        } else {
            this.mCancellationSignal = new CancellationSignal();
            fingerprintManager.authenticate(cryptoObject, this.mCancellationSignal, 0, new FingerprintManager.AuthenticationCallback(){

                public void onAuthenticationError(int errMsgId, CharSequence errString) {
                    FingerPrintAuthHelper.this.mCallback.onFingerprintAuthFailed(566, errString.toString());
                }

                public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
                    FingerPrintAuthHelper.this.mCallback.onFingerprintAuthFailed(843, helpString.toString());
                }

                public void onAuthenticationFailed() {
                    FingerPrintAuthHelper.this.mCallback.onFingerprintAuthFailed(456, "Cannot recognize the fingerprint.");
                }

                public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
                    FingerPrintAuthHelper.this.mCallback.onFingerprintAuthSuccess(result.getCryptoObject());
                }
            }, null);
        }
    }

    @RequiresApi(api=16)
    void stopAuth() {
        if (this.mCancellationSignal != null) {
            this.isScanning = true;
            this.mCancellationSignal.cancel();
            this.mCancellationSignal = null;
        }
    }

    public boolean isScanning() {
        return this.isScanning;
    }

    static interface FingerPrintAuthCallback {
        public void onFingerprintAuthSuccess(FingerprintManager.CryptoObject var1);

        public void onFingerprintAuthFailed(int var1, @Nullable String var2);
    }
}

