/*
 * Decompiled with CFR 0.152.
 */
package com.kevalpatel.passcodeview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Handler;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.view.animation.CycleInterpolator;
import com.kevalpatel.passcodeview.Box;
import com.kevalpatel.passcodeview.FingerPrintAuthHelper;
import com.kevalpatel.passcodeview.PinView;
import com.kevalpatel.passcodeview.R;
import com.kevalpatel.passcodeview.Utils;
import com.kevalpatel.passcodeview.interfaces.AuthenticationListener;

final class BoxFingerprint
extends Box
implements FingerPrintAuthHelper.FingerPrintAuthCallback {
    static final String DEF_FINGERPRINT_STATUS = "Scan your finger to authenticate";
    private Boolean isFingerPrintBoxVisible;
    private Rect mBounds = new Rect();
    @Nullable
    private AuthenticationListener mAuthListener;
    @ColorInt
    private int mStatusTextColor;
    @Dimension
    private float mStatusTextSize;
    private String mNormalStatusText;
    private String mCurrentStatusText;
    private TextPaint mStatusTextPaint;
    @Nullable
    private FingerPrintAuthHelper mFingerPrintAuthHelper;

    BoxFingerprint(@NonNull PinView view) {
        super(view);
        this.isFingerPrintBoxVisible = Utils.isFingerPrintEnrolled(this.getContext());
        if (this.isFingerPrintBoxVisible.booleanValue()) {
            this.mFingerPrintAuthHelper = new FingerPrintAuthHelper(this.getContext(), this);
            this.mFingerPrintAuthHelper.startAuth();
        }
    }

    void stopFingerprintScanner() {
        if (this.mFingerPrintAuthHelper != null) {
            this.mFingerPrintAuthHelper.stopAuth();
        }
    }

    @Override
    void setDefaults() {
        this.mStatusTextSize = this.getContext().getResources().getDimension(R.dimen.lib_fingerprint_status_text_size);
        this.mCurrentStatusText = this.mNormalStatusText = DEF_FINGERPRINT_STATUS;
        this.mStatusTextColor = this.getContext().getResources().getColor(R.color.lib_key_default_color);
    }

    @Override
    void onAuthenticationFail() {
    }

    @Override
    void onAuthenticationSuccess() {
    }

    @Override
    void draw(@NonNull Canvas canvas) {
        if (this.isFingerPrintBoxVisible.booleanValue()) {
            Drawable d = this.getContext().getResources().getDrawable(R.drawable.ic_fingerprint);
            d.setBounds((int)(this.mBounds.exactCenterX() - (float)(this.mBounds.height() / 4)), this.mBounds.top + 15, (int)(this.mBounds.exactCenterX() + (float)(this.mBounds.height() / 4)), this.mBounds.top + this.mBounds.height() / 2 + 15);
            d.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.mStatusTextPaint.getColor(), PorterDuff.Mode.SRC_ATOP));
            d.draw(canvas);
            canvas.drawText(this.mCurrentStatusText, this.mBounds.exactCenterX(), (float)((double)this.mBounds.top + (double)this.mBounds.height() / 1.3 - (double)((this.mStatusTextPaint.descent() + this.mStatusTextPaint.ascent()) / 2.0f)), (Paint)this.mStatusTextPaint);
        }
    }

    @Override
    void measure(@NonNull Rect rootViewBounds) {
        if (this.isFingerPrintBoxVisible.booleanValue()) {
            this.mBounds.left = rootViewBounds.left;
            this.mBounds.right = rootViewBounds.right;
            this.mBounds.top = (int)((float)rootViewBounds.bottom - (float)rootViewBounds.height() * 0.14f);
            this.mBounds.bottom = rootViewBounds.bottom;
        }
    }

    @Override
    void preparePaint() {
        this.mStatusTextPaint = new TextPaint(1);
        this.mStatusTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mStatusTextPaint.setTextSize(this.mStatusTextSize);
        this.mStatusTextPaint.setColor(this.mStatusTextColor);
    }

    @Override
    public void onFingerprintAuthSuccess(FingerprintManager.CryptoObject cryptoObject) {
        this.mCurrentStatusText = "Fingerprint recognized";
        this.getRootView().invalidate();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (BoxFingerprint.this.mAuthListener != null) {
                    BoxFingerprint.this.mAuthListener.onAuthenticationSuccessful();
                }
                BoxFingerprint.this.mCurrentStatusText = BoxFingerprint.this.mNormalStatusText;
                BoxFingerprint.this.getRootView().invalidate();
            }
        }, 1000L);
    }

    @Override
    public void onFingerprintAuthFailed(int errorCode, String errorMessage) {
        switch (errorCode) {
            case 456: 
            case 566: 
            case 843: {
                this.mStatusTextPaint.setColor(-65536);
                this.mCurrentStatusText = errorMessage;
                this.playErrorAnimation();
            }
        }
    }

    private void playErrorAnimation() {
        ValueAnimator goLeftAnimator = ValueAnimator.ofInt((int[])new int[]{0, 10});
        goLeftAnimator.setInterpolator((TimeInterpolator)new CycleInterpolator(2.0f));
        goLeftAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ((BoxFingerprint)BoxFingerprint.this).mBounds.left += ((Integer)animation.getAnimatedValue()).intValue();
                ((BoxFingerprint)BoxFingerprint.this).mBounds.right += ((Integer)animation.getAnimatedValue()).intValue();
                BoxFingerprint.this.getRootView().invalidate();
            }
        });
        goLeftAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BoxFingerprint.this.mCurrentStatusText = BoxFingerprint.this.mNormalStatusText;
                        BoxFingerprint.this.mStatusTextPaint.setColor(BoxFingerprint.this.mStatusTextColor);
                        BoxFingerprint.this.getRootView().invalidate();
                    }
                }, 1000L);
                if (BoxFingerprint.this.mAuthListener != null) {
                    BoxFingerprint.this.mAuthListener.onAuthenticationFailed();
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        goLeftAnimator.start();
    }

    @NonNull
    String getStatusText() {
        return this.mNormalStatusText;
    }

    void setStatusText(@NonNull String statusText) {
        this.mCurrentStatusText = this.mNormalStatusText = statusText;
    }

    int getStatusTextColor() {
        return this.mStatusTextColor;
    }

    void setStatusTextColor(@ColorInt int statusTextColor) {
        this.mStatusTextColor = statusTextColor;
    }

    float getStatusTextSize() {
        return this.mStatusTextSize;
    }

    void setStatusTextSize(float statusTextSize) {
        this.mStatusTextSize = statusTextSize;
    }

    Boolean isFingerPrintEnable() {
        return this.isFingerPrintBoxVisible;
    }

    void setFingerPrintEnable(boolean isEnable) {
        this.isFingerPrintBoxVisible = isEnable && Utils.isFingerPrintEnrolled(this.getContext());
    }

    void setAuthListener(@NonNull AuthenticationListener authListener) {
        this.mAuthListener = authListener;
    }
}

