/*
 * Decompiled with CFR 0.152.
 */
package com.androidhiddencamera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class HiddenCameraUtils {
    @SuppressLint(value={"NewApi"})
    public static boolean canOverDrawOtherApps(Context context) {
        return Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)context);
    }

    public static void openDrawOverPermissionSetting(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    @NonNull
    static File getCacheDir(Context context) {
        return context.getExternalCacheDir() == null ? context.getCacheDir() : context.getExternalCacheDir();
    }

    public static boolean isFrontCameraAvailable(@NonNull Context context) {
        int numCameras = Camera.getNumberOfCameras();
        return numCameras > 0 && context.getPackageManager().hasSystemFeature("android.hardware.camera.front");
    }

    @WorkerThread
    static Bitmap rotateBitmap(@NonNull Bitmap bitmap, int rotation) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotation);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean saveImageFromFile(@NonNull Bitmap bitmap, @NonNull File fileToSave, int imageFormat) {
        Bitmap.CompressFormat compressFormat;
        FileOutputStream out = null;
        boolean isSuccess = false;
        switch (imageFormat) {
            case 849: {
                compressFormat = Bitmap.CompressFormat.JPEG;
                break;
            }
            case 563: {
                compressFormat = Bitmap.CompressFormat.WEBP;
                break;
            }
            default: {
                compressFormat = Bitmap.CompressFormat.PNG;
            }
        }
        try {
            if (!fileToSave.exists()) {
                fileToSave.createNewFile();
            }
            out = new FileOutputStream(fileToSave);
            bitmap.compress(compressFormat, 100, (OutputStream)out);
            isSuccess = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            isSuccess = false;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return isSuccess;
    }
}

