/*
 * Decompiled with CFR 0.152.
 */
package com.androidhiddencamera;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.androidhiddencamera.HiddenCameraUtils;
import java.io.File;

public final class CameraConfig {
    private Context mContext;
    private int mResolution = 7895;
    private int mFacing = 0;
    private int mImageFormat = 849;
    private int mImageRotation = 0;
    private int mCameraFocus = 0;
    private File mImageFile;

    public Builder getBuilder(Context context) {
        this.mContext = context;
        return new Builder();
    }

    int getResolution() {
        return this.mResolution;
    }

    @Nullable
    String getFocusMode() {
        switch (this.mCameraFocus) {
            case 0: {
                return "auto";
            }
            case 1: {
                return "continuous-picture";
            }
            case 2: {
                return null;
            }
        }
        throw new RuntimeException("Invalid camera focus mode.");
    }

    int getFacing() {
        return this.mFacing;
    }

    int getImageFormat() {
        return this.mImageFormat;
    }

    File getImageFile() {
        return this.mImageFile;
    }

    int getImageRotation() {
        return this.mImageRotation;
    }

    public class Builder {
        public Builder setCameraResolution(int resolution) {
            if (resolution != 2006 && resolution != 7895 && resolution != 7821) {
                throw new RuntimeException("Invalid camera resolution.");
            }
            CameraConfig.this.mResolution = resolution;
            return this;
        }

        public Builder setCameraFacing(int cameraFacing) {
            if (cameraFacing != 0 && cameraFacing != 1) {
                throw new RuntimeException("Invalid camera facing value.");
            }
            CameraConfig.this.mFacing = cameraFacing;
            return this;
        }

        public Builder setCameraFocus(int focusMode) {
            if (focusMode != 0 && focusMode != 1 && focusMode != 2) {
                throw new RuntimeException("Invalid camera focus mode.");
            }
            CameraConfig.this.mCameraFocus = focusMode;
            return this;
        }

        public Builder setImageFormat(int imageFormat) {
            if (imageFormat != 849 && imageFormat != 545) {
                throw new RuntimeException("Invalid output image format.");
            }
            CameraConfig.this.mImageFormat = imageFormat;
            return this;
        }

        public Builder setImageRotation(int rotation) {
            if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
                throw new RuntimeException("Invalid image rotation.");
            }
            CameraConfig.this.mImageRotation = rotation;
            return this;
        }

        public Builder setImageFile(File imageFile) {
            CameraConfig.this.mImageFile = imageFile;
            return this;
        }

        public CameraConfig build() {
            if (CameraConfig.this.mImageFile == null) {
                CameraConfig.this.mImageFile = this.getDefaultStorageFile();
            }
            return CameraConfig.this;
        }

        @NonNull
        private File getDefaultStorageFile() {
            return new File(HiddenCameraUtils.getCacheDir(CameraConfig.this.mContext).getAbsolutePath() + File.separator + "IMG_" + System.currentTimeMillis() + (CameraConfig.this.mImageFormat == 849 ? ".jpeg" : ".png"));
        }
    }
}

