/*
 * Decompiled with CFR 0.152.
 */
package com.androidhiddencamera;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresPermission;
import android.support.v4.app.ActivityCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.androidhiddencamera.CameraCallbacks;
import com.androidhiddencamera.CameraConfig;
import com.androidhiddencamera.CameraPreview;
import com.androidhiddencamera.HiddenCameraUtils;

public abstract class HiddenCameraService
extends Service
implements CameraCallbacks {
    private WindowManager mWindowManager;
    private CameraPreview mCameraPreview;

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        this.stopCamera();
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopCamera();
    }

    @RequiresPermission(allOf={"android.permission.CAMERA", "android.permission.SYSTEM_ALERT_WINDOW"})
    protected void startCamera(CameraConfig cameraConfig) {
        if (!HiddenCameraUtils.canOverDrawOtherApps((Context)this)) {
            this.onCameraError(3136);
        } else if (ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.CAMERA") != 0) {
            this.onCameraError(5472);
        } else if (cameraConfig.getFacing() == 1 && !HiddenCameraUtils.isFrontCameraAvailable((Context)this)) {
            this.onCameraError(8722);
        } else {
            if (this.mCameraPreview == null) {
                this.mCameraPreview = this.addPreView();
            }
            this.mCameraPreview.startCameraInternal(cameraConfig);
        }
    }

    protected void takePicture() {
        if (this.mCameraPreview != null) {
            if (this.mCameraPreview.isSafeToTakePictureInternal()) {
                this.mCameraPreview.takePictureInternal();
            }
        } else {
            throw new RuntimeException("Background camera not initialized. Call startCamera() to initialize the camera.");
        }
    }

    protected void stopCamera() {
        if (this.mCameraPreview != null) {
            this.mWindowManager.removeView((View)this.mCameraPreview);
            this.mCameraPreview.stopPreviewAndFreeCamera();
        }
    }

    private CameraPreview addPreView() {
        CameraPreview cameraSourceCameraPreview = new CameraPreview((Context)this, this);
        cameraSourceCameraPreview.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mWindowManager = (WindowManager)this.getSystemService("window");
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(1, 1, Build.VERSION.SDK_INT < 26 ? 2006 : 2038, 262144, -3);
        this.mWindowManager.addView((View)cameraSourceCameraPreview, (ViewGroup.LayoutParams)params);
        return cameraSourceCameraPreview;
    }
}

