/*
 * Decompiled with CFR 0.152.
 */
package com.androidhiddencamera;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.androidhiddencamera.CameraCallbacks;
import com.androidhiddencamera.CameraConfig;
import com.androidhiddencamera.CameraPreview;
import com.androidhiddencamera.HiddenCameraUtils;

public abstract class HiddenCameraFragment
extends Fragment
implements CameraCallbacks {
    private CameraConfig mCachedCameraConfig;
    private CameraPreview mCameraPreview;

    @RequiresPermission(value="android.permission.CAMERA")
    public void startCamera(CameraConfig cameraConfig) {
        if (ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.CAMERA") != 0) {
            this.onCameraError(5472);
        } else if (cameraConfig.getFacing() == 1 && !HiddenCameraUtils.isFrontCameraAvailable((Context)this.getActivity())) {
            this.onCameraError(8722);
        } else {
            if (this.mCameraPreview == null) {
                this.mCameraPreview = this.addPreView();
            }
            this.mCameraPreview.startCameraInternal(cameraConfig);
            this.mCachedCameraConfig = cameraConfig;
        }
    }

    public void takePicture() {
        if (this.mCameraPreview != null) {
            if (this.mCameraPreview.isSafeToTakePictureInternal()) {
                this.mCameraPreview.takePictureInternal();
            }
        } else {
            throw new RuntimeException("Background camera not initialized. Call startCamera() to initialize the camera.");
        }
    }

    public void stopCamera() {
        this.mCachedCameraConfig = null;
        if (this.mCameraPreview != null) {
            this.mCameraPreview.stopPreviewAndFreeCamera();
        }
    }

    private CameraPreview addPreView() {
        CameraPreview cameraSourceCameraPreview = new CameraPreview((Context)this.getActivity(), this);
        cameraSourceCameraPreview.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        View view = ((ViewGroup)this.getActivity().getWindow().getDecorView().getRootView()).getChildAt(0);
        if (view instanceof LinearLayout) {
            LinearLayout linearLayout = (LinearLayout)view;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(1, 1);
            linearLayout.addView((View)cameraSourceCameraPreview, (ViewGroup.LayoutParams)params);
        } else if (view instanceof RelativeLayout) {
            RelativeLayout relativeLayout = (RelativeLayout)view;
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(1, 1);
            params.addRule(9, -1);
            params.addRule(12, -1);
            relativeLayout.addView((View)cameraSourceCameraPreview, (ViewGroup.LayoutParams)params);
        } else if (view instanceof FrameLayout) {
            FrameLayout frameLayout = (FrameLayout)view;
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(1, 1);
            frameLayout.addView((View)cameraSourceCameraPreview, (ViewGroup.LayoutParams)params);
        } else {
            throw new RuntimeException("Root view of the activity/fragment cannot be other than Linear/Relative or frame layout");
        }
        return cameraSourceCameraPreview;
    }

    public void onResume() {
        super.onResume();
        if (this.mCachedCameraConfig != null) {
            this.startCamera(this.mCachedCameraConfig);
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mCameraPreview != null) {
            this.mCameraPreview.stopPreviewAndFreeCamera();
        }
    }
}

