/*
 * Decompiled with CFR 0.152.
 */
package com.androidhiddencamera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.androidhiddencamera.CameraCallbacks;
import com.androidhiddencamera.CameraConfig;
import com.androidhiddencamera.HiddenCameraUtils;
import java.io.IOException;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private CameraCallbacks mCameraCallbacks;
    private SurfaceHolder mHolder;
    private Camera mCamera;
    private CameraConfig mCameraConfig;
    private boolean safeToTakePicture = false;

    CameraPreview(@NonNull Context context, CameraCallbacks cameraCallbacks) {
        super(context);
        this.mCameraCallbacks = cameraCallbacks;
        this.mHolder = this.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
    }

    protected void onLayout(boolean b, int i, int i1, int i2, int i3) {
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        try {
            this.mCamera.setDisplayOrientation(90);
            this.mCamera.setPreviewDisplay(surfaceHolder);
            this.mCamera.startPreview();
        }
        catch (IOException | NullPointerException e) {
            this.mCameraCallbacks.onCameraError(1122);
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i1, int i2) {
        Camera.Size cameraSize;
        this.safeToTakePicture = false;
        Camera.Parameters parameters = this.mCamera.getParameters();
        List pictureSizes = this.mCamera.getParameters().getSupportedPictureSizes();
        switch (this.mCameraConfig.getResolution()) {
            case 2006: {
                cameraSize = (Camera.Size)pictureSizes.get(0);
                break;
            }
            case 7895: {
                cameraSize = (Camera.Size)pictureSizes.get(pictureSizes.size() / 2);
                break;
            }
            case 7821: {
                cameraSize = (Camera.Size)pictureSizes.get(pictureSizes.size() - 1);
                break;
            }
            default: {
                throw new RuntimeException("Invalid camera resolution.");
            }
        }
        parameters.setPictureSize(cameraSize.width, cameraSize.height);
        this.requestLayout();
        this.mCamera.setParameters(parameters);
        this.mCamera.startPreview();
        this.safeToTakePicture = true;
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mCamera != null) {
            this.safeToTakePicture = false;
            this.mCamera.stopPreview();
        }
    }

    void startCameraInternal(@NonNull CameraConfig cameraConfig) {
        this.mCameraConfig = cameraConfig;
        if (this.safeCameraOpen(this.mCameraConfig.getFacing())) {
            if (this.mCamera != null) {
                this.requestLayout();
                try {
                    this.mCamera.setPreviewDisplay(this.mHolder);
                    this.mCamera.startPreview();
                    this.safeToTakePicture = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.mCameraCallbacks.onCameraError(1122);
                }
            }
        } else {
            this.mCameraCallbacks.onCameraError(1122);
        }
    }

    private boolean safeCameraOpen(int id) {
        boolean qOpened = false;
        try {
            this.stopPreviewAndFreeCamera();
            this.mCamera = Camera.open((int)id);
            qOpened = this.mCamera != null;
        }
        catch (Exception e) {
            Log.e((String)"CameraPreview", (String)"failed to open Camera");
            e.printStackTrace();
        }
        return qOpened;
    }

    boolean isSafeToTakePictureInternal() {
        return this.safeToTakePicture;
    }

    void takePictureInternal() {
        if (this.mCamera != null) {
            this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                public void onPictureTaken(final byte[] bytes, Camera camera) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Bitmap rotatedBitmap;
                            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
                            if (CameraPreview.this.mCameraConfig.getmImageRotation() != 0) {
                                rotatedBitmap = HiddenCameraUtils.rotateBitmap(bitmap, CameraPreview.this.mCameraConfig.getmImageRotation());
                                bitmap = null;
                            } else {
                                rotatedBitmap = bitmap;
                            }
                            if (HiddenCameraUtils.saveImageFromFile(rotatedBitmap, CameraPreview.this.mCameraConfig.getImageFile(), CameraPreview.this.mCameraConfig.getImageFormat())) {
                                new Handler(Looper.getMainLooper()).post(new Runnable(){

                                    @Override
                                    public void run() {
                                        CameraPreview.this.mCameraCallbacks.onImageCapture(CameraPreview.this.mCameraConfig.getImageFile());
                                    }
                                });
                            } else {
                                new Handler(Looper.getMainLooper()).post(new Runnable(){

                                    @Override
                                    public void run() {
                                        CameraPreview.this.mCameraCallbacks.onCameraError(9854);
                                    }
                                });
                            }
                        }
                    }).start();
                }
            });
        } else {
            this.mCameraCallbacks.onCameraError(1122);
        }
    }

    void stopPreviewAndFreeCamera() {
        this.safeToTakePicture = false;
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }
}

