/*
 * Decompiled with CFR 0.152.
 */
package com.androidhiddencamera;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.hardware.Camera;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import java.io.File;

public class HiddenCameraUtils {
    @SuppressLint(value={"NewApi"})
    public static boolean canOverDrawOtherApps(Context context) {
        return Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)context);
    }

    public static void openDrawOverPermissionSetting(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    @NonNull
    static File getCacheDir(Context context) {
        return context.getExternalCacheDir() == null ? context.getCacheDir() : context.getExternalCacheDir();
    }

    public static boolean isFrontCameraAvailable(Context context) {
        int numCameras = Camera.getNumberOfCameras();
        return numCameras > 0 && context.getPackageManager().hasSystemFeature("android.hardware.camera.front");
    }
}

