/*
 * Decompiled with CFR 0.152.
 */
package com.androidhiddencamera;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.androidhiddencamera.CameraCallbacks;
import com.androidhiddencamera.CameraConfig;
import com.androidhiddencamera.CameraPreview;
import com.androidhiddencamera.HiddenCameraUtils;

public abstract class HiddenCameraActivity
extends AppCompatActivity
implements CameraCallbacks {
    private CameraPreview mCameraPreview;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mCameraPreview = this.addPreView();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.stopCamera();
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void startCamera(CameraConfig cameraConfig) {
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            this.onCameraError(5472);
        } else if (cameraConfig.getFacing() == 1 && !HiddenCameraUtils.isFrontCameraAvailable((Context)this)) {
            this.onCameraError(8722);
        } else {
            this.mCameraPreview.startCameraInternal(cameraConfig);
        }
    }

    public void takePicture() {
        if (this.mCameraPreview == null || !this.mCameraPreview.isSafeToTakePictureInternal()) {
            throw new RuntimeException("Background camera not initialized. Call startCamera() to initialize the camera.");
        }
        this.mCameraPreview.takePictureInternal();
    }

    public void stopCamera() {
        if (this.mCameraPreview != null) {
            this.mCameraPreview.stopPreviewAndFreeCamera();
        }
    }

    private CameraPreview addPreView() {
        CameraPreview cameraSourceCameraPreview = new CameraPreview((Context)this, this);
        cameraSourceCameraPreview.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        View view = ((ViewGroup)this.getWindow().getDecorView().getRootView()).getChildAt(0);
        if (view instanceof LinearLayout) {
            LinearLayout linearLayout = (LinearLayout)view;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(1, 1);
            linearLayout.addView((View)cameraSourceCameraPreview, (ViewGroup.LayoutParams)params);
        } else if (view instanceof RelativeLayout) {
            RelativeLayout relativeLayout = (RelativeLayout)view;
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(1, 1);
            params.addRule(9, -1);
            params.addRule(12, -1);
            relativeLayout.addView((View)cameraSourceCameraPreview, (ViewGroup.LayoutParams)params);
        } else if (view instanceof FrameLayout) {
            FrameLayout frameLayout = (FrameLayout)view;
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(1, 1);
            frameLayout.addView((View)cameraSourceCameraPreview, (ViewGroup.LayoutParams)params);
        } else {
            throw new RuntimeException("Root view of the activity/fragment cannot be frame layout");
        }
        return cameraSourceCameraPreview;
    }
}

