/*
 * Decompiled with CFR 0.152.
 */
package com.androidhiddencamera;

import android.content.Context;
import android.support.annotation.NonNull;
import com.androidhiddencamera.HiddenCameraUtils;
import java.io.File;

public class CameraConfig {
    private Context mContext;
    private int mResolution = 7895;
    private int mFacing = 0;
    private int mImageFormat = 849;
    private File mImageFile;

    public Builder getBuilder(Context context) {
        this.mContext = context;
        return new Builder();
    }

    int getResolution() {
        return this.mResolution;
    }

    int getFacing() {
        return this.mFacing;
    }

    int getImageFormat() {
        return this.mImageFormat;
    }

    File getImageFile() {
        return this.mImageFile;
    }

    public class Builder {
        public Builder setCameraResolution(int resolution) {
            if (resolution != 2006 && resolution != 7895 && resolution != 7821) {
                throw new RuntimeException("Invalid camera resolution.");
            }
            CameraConfig.this.mResolution = resolution;
            return this;
        }

        public Builder setCameraFacing(int cameraFacing) {
            if (cameraFacing != 0 && cameraFacing != 1) {
                throw new RuntimeException("Invalid camera facing value.");
            }
            CameraConfig.this.mFacing = cameraFacing;
            return this;
        }

        public Builder setImageFormat(int imageFormat) {
            if (imageFormat != 849 && imageFormat != 545) {
                throw new RuntimeException("Invalid output image format.");
            }
            CameraConfig.this.mImageFormat = imageFormat;
            return this;
        }

        public Builder setImageFile(File imageFile) {
            CameraConfig.this.mImageFile = imageFile;
            return this;
        }

        public CameraConfig build() {
            if (CameraConfig.this.mImageFile == null) {
                CameraConfig.this.mImageFile = this.getDefaultStorageFile();
            }
            return CameraConfig.this;
        }

        @NonNull
        private File getDefaultStorageFile() {
            return new File(HiddenCameraUtils.getCacheDir(CameraConfig.this.mContext).getAbsolutePath() + File.pathSeparator + "IMG_" + System.currentTimeMillis() + (CameraConfig.this.mImageFormat == 849 ? ".jpeg" : ".png"));
        }
    }
}

