/*
 * Copyright 2017 Keval Patel.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package com.kevalpatel2106.emoticonpack.android7;

import java.util.HashMap;

/**
 * This class contains the list for Android 7.0 emoticons.
 */
class EmoticonList {
    static final HashMap<String, Integer> EMOTICONS = new HashMap<>();

    static {
        EMOTICONS.put("😀", R.drawable.emoji_android_7_0_1f600);
        EMOTICONS.put("😁", R.drawable.emoji_android_7_0_1f601);
        EMOTICONS.put("😂", R.drawable.emoji_android_7_0_1f602);
        EMOTICONS.put("🤣", R.drawable.emoji_android_7_0_1f923);
        EMOTICONS.put("😃", R.drawable.emoji_android_7_0_1f603);
        EMOTICONS.put("😄", R.drawable.emoji_android_7_0_1f604);
        EMOTICONS.put("😅", R.drawable.emoji_android_7_0_1f605);
        EMOTICONS.put("😆", R.drawable.emoji_android_7_0_1f606);
        EMOTICONS.put("😉", R.drawable.emoji_android_7_0_1f609);
        EMOTICONS.put("😊", R.drawable.emoji_android_7_0_1f60a);
        EMOTICONS.put("😋", R.drawable.emoji_android_7_0_1f60b);
        EMOTICONS.put("😎", R.drawable.emoji_android_7_0_1f60e);
        EMOTICONS.put("😍", R.drawable.emoji_android_7_0_1f60d);
        EMOTICONS.put("😘", R.drawable.emoji_android_7_0_1f618);
        EMOTICONS.put("😗", R.drawable.emoji_android_7_0_1f617);
        EMOTICONS.put("😙", R.drawable.emoji_android_7_0_1f619);
        EMOTICONS.put("😚", R.drawable.emoji_android_7_0_1f61a);
        EMOTICONS.put("☺️", R.drawable.emoji_android_7_0_263a);
        EMOTICONS.put("🙂", R.drawable.emoji_android_7_0_1f642);
        EMOTICONS.put("🤗", R.drawable.emoji_android_7_0_1f917);
        EMOTICONS.put("😐", R.drawable.emoji_android_7_0_1f610);
        EMOTICONS.put("😑", R.drawable.emoji_android_7_0_1f611);
        EMOTICONS.put("😶", R.drawable.emoji_android_7_0_1f636);
        EMOTICONS.put("😏", R.drawable.emoji_android_7_0_1f60f);
        EMOTICONS.put("😣", R.drawable.emoji_android_7_0_1f623);
        EMOTICONS.put("😥", R.drawable.emoji_android_7_0_1f625);
        EMOTICONS.put("😮", R.drawable.emoji_android_7_0_1f62e);
        EMOTICONS.put("😯", R.drawable.emoji_android_7_0_1f62f);
        EMOTICONS.put("😪", R.drawable.emoji_android_7_0_1f62a);
        EMOTICONS.put("😫", R.drawable.emoji_android_7_0_1f62b);
        EMOTICONS.put("😴", R.drawable.emoji_android_7_0_1f634);
        EMOTICONS.put("😌", R.drawable.emoji_android_7_0_1f60c);
        EMOTICONS.put("😛", R.drawable.emoji_android_7_0_1f61b);
        EMOTICONS.put("😜", R.drawable.emoji_android_7_0_1f61c);
        EMOTICONS.put("😝", R.drawable.emoji_android_7_0_1f61d);
        EMOTICONS.put("🤤", R.drawable.emoji_android_7_0_1f924);
        EMOTICONS.put("😒", R.drawable.emoji_android_7_0_1f612);
        EMOTICONS.put("😓", R.drawable.emoji_android_7_0_1f613);
        EMOTICONS.put("😔", R.drawable.emoji_android_7_0_1f614);
        EMOTICONS.put("😕", R.drawable.emoji_android_7_0_1f615);
        EMOTICONS.put("😲", R.drawable.emoji_android_7_0_1f632);
        EMOTICONS.put("😖", R.drawable.emoji_android_7_0_1f616);
        EMOTICONS.put("😞", R.drawable.emoji_android_7_0_1f61e);
        EMOTICONS.put("😟", R.drawable.emoji_android_7_0_1f61f);
        EMOTICONS.put("😤", R.drawable.emoji_android_7_0_1f624);
        EMOTICONS.put("😢", R.drawable.emoji_android_7_0_1f622);
        EMOTICONS.put("😭", R.drawable.emoji_android_7_0_1f62d);
        EMOTICONS.put("😦", R.drawable.emoji_android_7_0_1f626);
        EMOTICONS.put("😧", R.drawable.emoji_android_7_0_1f627);
        EMOTICONS.put("😨", R.drawable.emoji_android_7_0_1f628);
        EMOTICONS.put("😩", R.drawable.emoji_android_7_0_1f629);
        EMOTICONS.put("😬", R.drawable.emoji_android_7_0_1f62c);
        EMOTICONS.put("😰", R.drawable.emoji_android_7_0_1f630);
        EMOTICONS.put("😱", R.drawable.emoji_android_7_0_1f631);
        EMOTICONS.put("😳", R.drawable.emoji_android_7_0_1f633);
        EMOTICONS.put("😵", R.drawable.emoji_android_7_0_1f635);
        EMOTICONS.put("😡", R.drawable.emoji_android_7_0_1f621);
        EMOTICONS.put("😠", R.drawable.emoji_android_7_0_1f620);
        EMOTICONS.put("😷", R.drawable.emoji_android_7_0_1f637);
        EMOTICONS.put("🤢", R.drawable.emoji_android_7_0_1f922);
        EMOTICONS.put("🤧", R.drawable.emoji_android_7_0_1f927);
        EMOTICONS.put("😇", R.drawable.emoji_android_7_0_1f607);
        EMOTICONS.put("🤠", R.drawable.emoji_android_7_0_1f920);
        EMOTICONS.put("🤡", R.drawable.emoji_android_7_0_1f921);
        EMOTICONS.put("🤥", R.drawable.emoji_android_7_0_1f925);
        EMOTICONS.put("😈", R.drawable.emoji_android_7_0_1f608);
        EMOTICONS.put("👿", R.drawable.emoji_android_7_0_1f47f);
        EMOTICONS.put("👹", R.drawable.emoji_android_7_0_1f479);
        EMOTICONS.put("👺", R.drawable.emoji_android_7_0_1f47a);
        EMOTICONS.put("💀", R.drawable.emoji_android_7_0_1f480);
        EMOTICONS.put("👻", R.drawable.emoji_android_7_0_1f47b);
        EMOTICONS.put("👽", R.drawable.emoji_android_7_0_1f47d);
        EMOTICONS.put("💩", R.drawable.emoji_android_7_0_1f4a9);
        EMOTICONS.put("😺", R.drawable.emoji_android_7_0_1f63a);
        EMOTICONS.put("😸", R.drawable.emoji_android_7_0_1f638);
        EMOTICONS.put("😹", R.drawable.emoji_android_7_0_1f639);
        EMOTICONS.put("😻", R.drawable.emoji_android_7_0_1f63b);
        EMOTICONS.put("😼", R.drawable.emoji_android_7_0_1f63c);
        EMOTICONS.put("😽", R.drawable.emoji_android_7_0_1f63d);
        EMOTICONS.put("🙀", R.drawable.emoji_android_7_0_1f640);
        EMOTICONS.put("😿", R.drawable.emoji_android_7_0_1f63f);
        EMOTICONS.put("😾", R.drawable.emoji_android_7_0_1f63e);
        EMOTICONS.put("👶", R.drawable.emoji_android_7_0_1f476);
        EMOTICONS.put("👦", R.drawable.emoji_android_7_0_1f466);
        EMOTICONS.put("👧", R.drawable.emoji_android_7_0_1f467);
        EMOTICONS.put("👨", R.drawable.emoji_android_7_0_1f468);
        EMOTICONS.put("👩", R.drawable.emoji_android_7_0_1f469);
        EMOTICONS.put("👴", R.drawable.emoji_android_7_0_1f474);
        EMOTICONS.put("👵", R.drawable.emoji_android_7_0_1f475);
        EMOTICONS.put("👮", R.drawable.emoji_android_7_0_1f46e);
        EMOTICONS.put("🕵️", R.drawable.emoji_android_7_0_1f575);
        EMOTICONS.put("💂", R.drawable.emoji_android_7_0_1f482);
        EMOTICONS.put("👷", R.drawable.emoji_android_7_0_1f477);
        EMOTICONS.put("🤴", R.drawable.emoji_android_7_0_1f934);
        EMOTICONS.put("👸", R.drawable.emoji_android_7_0_1f478);
        EMOTICONS.put("👳", R.drawable.emoji_android_7_0_1f473);
        EMOTICONS.put("👲", R.drawable.emoji_android_7_0_1f472);
        EMOTICONS.put("👱", R.drawable.emoji_android_7_0_1f471);
        EMOTICONS.put("🤵", R.drawable.emoji_android_7_0_1f935);
        EMOTICONS.put("👰", R.drawable.emoji_android_7_0_1f470);
        EMOTICONS.put("🤰", R.drawable.emoji_android_7_0_1f930);
        EMOTICONS.put("👼", R.drawable.emoji_android_7_0_1f47c);
        EMOTICONS.put("🎅", R.drawable.emoji_android_7_0_1f385);
        EMOTICONS.put("🤶", R.drawable.emoji_android_7_0_1f936);
        EMOTICONS.put("🙍", R.drawable.emoji_android_7_0_1f64d);
        EMOTICONS.put("🙎", R.drawable.emoji_android_7_0_1f64e);
        EMOTICONS.put("🙅", R.drawable.emoji_android_7_0_1f645);
        EMOTICONS.put("🙆", R.drawable.emoji_android_7_0_1f646);
        EMOTICONS.put("💁", R.drawable.emoji_android_7_0_1f481);
        EMOTICONS.put("🙋", R.drawable.emoji_android_7_0_1f64b);
        EMOTICONS.put("🙇", R.drawable.emoji_android_7_0_1f647);
        EMOTICONS.put("🤦", R.drawable.emoji_android_7_0_1f926);
        EMOTICONS.put("🤷", R.drawable.emoji_android_7_0_1f937);
        EMOTICONS.put("💆", R.drawable.emoji_android_7_0_1f486);
        EMOTICONS.put("💇", R.drawable.emoji_android_7_0_1f487);
        EMOTICONS.put("🚶", R.drawable.emoji_android_7_0_1f6b6);
        EMOTICONS.put("🏃", R.drawable.emoji_android_7_0_1f3c3);
        EMOTICONS.put("💃", R.drawable.emoji_android_7_0_1f483);
        EMOTICONS.put("🕺", R.drawable.emoji_android_7_0_1f57a);
        EMOTICONS.put("👯", R.drawable.emoji_android_7_0_1f46f);
        EMOTICONS.put("👤", R.drawable.emoji_android_7_0_1f464);
        EMOTICONS.put("👥", R.drawable.emoji_android_7_0_1f465);
        EMOTICONS.put("👫", R.drawable.emoji_android_7_0_1f46b);
        EMOTICONS.put("👬", R.drawable.emoji_android_7_0_1f46c);
        EMOTICONS.put("👭", R.drawable.emoji_android_7_0_1f46d);
        EMOTICONS.put("💏", R.drawable.emoji_android_7_0_1f48f);
        EMOTICONS.put("👨‍❤️‍💋‍👨", R.drawable.emoji_android_7_0_1f468_200d_2764_fe0f_200d_1f48b_200d_1f468);
        EMOTICONS.put("👩‍❤️‍💋‍👩", R.drawable.emoji_android_7_0_1f469_200d_2764_fe0f_200d_1f48b_200d_1f469);
        EMOTICONS.put("💑", R.drawable.emoji_android_7_0_1f491);
        EMOTICONS.put("👨‍❤️‍👨", R.drawable.emoji_android_7_0_1f468_200d_2764_fe0f_200d_1f468);
        EMOTICONS.put("👩‍❤️‍👩", R.drawable.emoji_android_7_0_1f469_200d_2764_fe0f_200d_1f469);
        EMOTICONS.put("👪", R.drawable.emoji_android_7_0_1f46a);
        EMOTICONS.put("👨‍👩‍👧", R.drawable.emoji_android_7_0_1f468_200d_1f469_200d_1f467);
        EMOTICONS.put("👨‍👩‍👧‍👦", R.drawable.emoji_android_7_0_1f468_200d_1f469_200d_1f467_200d_1f466);
        EMOTICONS.put("👨‍👩‍👦‍👦", R.drawable.emoji_android_7_0_1f468_200d_1f469_200d_1f466_200d_1f466);
        EMOTICONS.put("👨‍👩‍👧‍👧", R.drawable.emoji_android_7_0_1f468_200d_1f469_200d_1f467_200d_1f467);
        EMOTICONS.put("👨‍👨‍👦", R.drawable.emoji_android_7_0_1f468_200d_1f468_200d_1f466);
        EMOTICONS.put("👨‍👨‍👧", R.drawable.emoji_android_7_0_1f468_200d_1f468_200d_1f467);
        EMOTICONS.put("👨‍👨‍👧‍👦", R.drawable.emoji_android_7_0_1f468_200d_1f468_200d_1f467_200d_1f466);
        EMOTICONS.put("👨‍👨‍👦‍👦", R.drawable.emoji_android_7_0_1f468_200d_1f468_200d_1f466_200d_1f466);
        EMOTICONS.put("👨‍👨‍👧‍👧", R.drawable.emoji_android_7_0_1f468_200d_1f468_200d_1f467_200d_1f467);
        EMOTICONS.put("👩‍👩‍👦", R.drawable.emoji_android_7_0_1f469_200d_1f469_200d_1f466);
        EMOTICONS.put("👩‍👩‍👧", R.drawable.emoji_android_7_0_1f469_200d_1f469_200d_1f467);
        EMOTICONS.put("👩‍👩‍👧‍👦", R.drawable.emoji_android_7_0_1f469_200d_1f469_200d_1f467_200d_1f466);
        EMOTICONS.put("👩‍👩‍👦‍👦", R.drawable.emoji_android_7_0_1f469_200d_1f469_200d_1f466_200d_1f466);
        EMOTICONS.put("👩‍👩‍👧‍👧", R.drawable.emoji_android_7_0_1f469_200d_1f469_200d_1f467_200d_1f467);
        EMOTICONS.put("🤳", R.drawable.emoji_android_7_0_1f933);
        EMOTICONS.put("💪", R.drawable.emoji_android_7_0_1f4aa);
        EMOTICONS.put("👈", R.drawable.emoji_android_7_0_1f448);
        EMOTICONS.put("👉", R.drawable.emoji_android_7_0_1f449);
        EMOTICONS.put("☝️", R.drawable.emoji_android_7_0_261d);
        EMOTICONS.put("👆", R.drawable.emoji_android_7_0_1f446);
        EMOTICONS.put("👇", R.drawable.emoji_android_7_0_1f447);
        EMOTICONS.put("✌️", R.drawable.emoji_android_7_0_270c);
        EMOTICONS.put("🤞", R.drawable.emoji_android_7_0_1f91e);
        EMOTICONS.put("✋", R.drawable.emoji_android_7_0_270b);
        EMOTICONS.put("👌", R.drawable.emoji_android_7_0_1f44c);
        EMOTICONS.put("👍", R.drawable.emoji_android_7_0_1f44d);
        EMOTICONS.put("👎", R.drawable.emoji_android_7_0_1f44e);
        EMOTICONS.put("✊", R.drawable.emoji_android_7_0_270a);
        EMOTICONS.put("👊", R.drawable.emoji_android_7_0_1f44a);
        EMOTICONS.put("🤛", R.drawable.emoji_android_7_0_1f91b);
        EMOTICONS.put("🤜", R.drawable.emoji_android_7_0_1f91c);
        EMOTICONS.put("🤚", R.drawable.emoji_android_7_0_1f91a);
        EMOTICONS.put("👋", R.drawable.emoji_android_7_0_1f44b);
        EMOTICONS.put("👏", R.drawable.emoji_android_7_0_1f44f);
        EMOTICONS.put("👐", R.drawable.emoji_android_7_0_1f450);
        EMOTICONS.put("🙌", R.drawable.emoji_android_7_0_1f64c);
        EMOTICONS.put("🙏", R.drawable.emoji_android_7_0_1f64f);
        EMOTICONS.put("🤝", R.drawable.emoji_android_7_0_1f91d);
        EMOTICONS.put("💅", R.drawable.emoji_android_7_0_1f485);
        EMOTICONS.put("👂", R.drawable.emoji_android_7_0_1f442);
        EMOTICONS.put("👃", R.drawable.emoji_android_7_0_1f443);
        EMOTICONS.put("👣", R.drawable.emoji_android_7_0_1f463);
        EMOTICONS.put("👀", R.drawable.emoji_android_7_0_1f440);
        EMOTICONS.put("👅", R.drawable.emoji_android_7_0_1f445);
        EMOTICONS.put("👄", R.drawable.emoji_android_7_0_1f444);
        EMOTICONS.put("💋", R.drawable.emoji_android_7_0_1f48b);
        EMOTICONS.put("👓", R.drawable.emoji_android_7_0_1f453);
        EMOTICONS.put("👔", R.drawable.emoji_android_7_0_1f454);
        EMOTICONS.put("👕", R.drawable.emoji_android_7_0_1f455);
        EMOTICONS.put("👖", R.drawable.emoji_android_7_0_1f456);
        EMOTICONS.put("👗", R.drawable.emoji_android_7_0_1f457);
        EMOTICONS.put("👘", R.drawable.emoji_android_7_0_1f458);
        EMOTICONS.put("👙", R.drawable.emoji_android_7_0_1f459);
        EMOTICONS.put("👚", R.drawable.emoji_android_7_0_1f45a);
        EMOTICONS.put("👛", R.drawable.emoji_android_7_0_1f45b);
        EMOTICONS.put("👜", R.drawable.emoji_android_7_0_1f45c);
        EMOTICONS.put("👝", R.drawable.emoji_android_7_0_1f45d);
        EMOTICONS.put("🎒", R.drawable.emoji_android_7_0_1f392);
        EMOTICONS.put("👞", R.drawable.emoji_android_7_0_1f45e);
        EMOTICONS.put("👟", R.drawable.emoji_android_7_0_1f45f);
        EMOTICONS.put("👠", R.drawable.emoji_android_7_0_1f460);
        EMOTICONS.put("👡", R.drawable.emoji_android_7_0_1f461);
        EMOTICONS.put("👢", R.drawable.emoji_android_7_0_1f462);
        EMOTICONS.put("👑", R.drawable.emoji_android_7_0_1f451);
        EMOTICONS.put("👒", R.drawable.emoji_android_7_0_1f452);
        EMOTICONS.put("🎩", R.drawable.emoji_android_7_0_1f3a9);
        EMOTICONS.put("🎓", R.drawable.emoji_android_7_0_1f393);
        EMOTICONS.put("💄", R.drawable.emoji_android_7_0_1f484);
        EMOTICONS.put("💍", R.drawable.emoji_android_7_0_1f48d);
        EMOTICONS.put("🌂", R.drawable.emoji_android_7_0_1f302);
        EMOTICONS.put("💼", R.drawable.emoji_android_7_0_1f4bc);
        EMOTICONS.put("🙈", R.drawable.emoji_android_7_0_1f648);
        EMOTICONS.put("🙉", R.drawable.emoji_android_7_0_1f649);
        EMOTICONS.put("🙊", R.drawable.emoji_android_7_0_1f64a);
        EMOTICONS.put("💥", R.drawable.emoji_android_7_0_1f4a5);
        EMOTICONS.put("💦", R.drawable.emoji_android_7_0_1f4a6);
        EMOTICONS.put("💨", R.drawable.emoji_android_7_0_1f4a8);
        EMOTICONS.put("💫", R.drawable.emoji_android_7_0_1f4ab);
        EMOTICONS.put("🐵", R.drawable.emoji_android_7_0_1f435);
        EMOTICONS.put("🐒", R.drawable.emoji_android_7_0_1f412);
        EMOTICONS.put("🦍", R.drawable.emoji_android_7_0_1f98d);
        EMOTICONS.put("🐶", R.drawable.emoji_android_7_0_1f436);
        EMOTICONS.put("🐕", R.drawable.emoji_android_7_0_1f415);
        EMOTICONS.put("🐩", R.drawable.emoji_android_7_0_1f429);
        EMOTICONS.put("🐺", R.drawable.emoji_android_7_0_1f43a);
        EMOTICONS.put("🦊", R.drawable.emoji_android_7_0_1f98a);
        EMOTICONS.put("🐱", R.drawable.emoji_android_7_0_1f431);
        EMOTICONS.put("🐈", R.drawable.emoji_android_7_0_1f408);
        EMOTICONS.put("🐯", R.drawable.emoji_android_7_0_1f42f);
        EMOTICONS.put("🐅", R.drawable.emoji_android_7_0_1f405);
        EMOTICONS.put("🐆", R.drawable.emoji_android_7_0_1f406);
        EMOTICONS.put("🐴", R.drawable.emoji_android_7_0_1f434);
        EMOTICONS.put("🐎", R.drawable.emoji_android_7_0_1f40e);
        EMOTICONS.put("🐮", R.drawable.emoji_android_7_0_1f42e);
        EMOTICONS.put("🐂", R.drawable.emoji_android_7_0_1f402);
        EMOTICONS.put("🐃", R.drawable.emoji_android_7_0_1f403);
        EMOTICONS.put("🐄", R.drawable.emoji_android_7_0_1f404);
        EMOTICONS.put("🐷", R.drawable.emoji_android_7_0_1f437);
        EMOTICONS.put("🐖", R.drawable.emoji_android_7_0_1f416);
        EMOTICONS.put("🐗", R.drawable.emoji_android_7_0_1f417);
        EMOTICONS.put("🐽", R.drawable.emoji_android_7_0_1f43d);
        EMOTICONS.put("🐏", R.drawable.emoji_android_7_0_1f40f);
        EMOTICONS.put("🐑", R.drawable.emoji_android_7_0_1f411);
        EMOTICONS.put("🐐", R.drawable.emoji_android_7_0_1f410);
        EMOTICONS.put("🐪", R.drawable.emoji_android_7_0_1f42a);
        EMOTICONS.put("🐫", R.drawable.emoji_android_7_0_1f42b);
        EMOTICONS.put("🐘", R.drawable.emoji_android_7_0_1f418);
        EMOTICONS.put("🦏", R.drawable.emoji_android_7_0_1f98f);
        EMOTICONS.put("🐭", R.drawable.emoji_android_7_0_1f42d);
        EMOTICONS.put("🐁", R.drawable.emoji_android_7_0_1f401);
        EMOTICONS.put("🐀", R.drawable.emoji_android_7_0_1f400);
        EMOTICONS.put("🐹", R.drawable.emoji_android_7_0_1f439);
        EMOTICONS.put("🐰", R.drawable.emoji_android_7_0_1f430);
        EMOTICONS.put("🐇", R.drawable.emoji_android_7_0_1f407);
        EMOTICONS.put("🦇", R.drawable.emoji_android_7_0_1f987);
        EMOTICONS.put("🐻", R.drawable.emoji_android_7_0_1f43b);
        EMOTICONS.put("🐨", R.drawable.emoji_android_7_0_1f428);
        EMOTICONS.put("🐼", R.drawable.emoji_android_7_0_1f43c);
        EMOTICONS.put("🐾", R.drawable.emoji_android_7_0_1f43e);
        EMOTICONS.put("🐔", R.drawable.emoji_android_7_0_1f414);
        EMOTICONS.put("🐓", R.drawable.emoji_android_7_0_1f413);
        EMOTICONS.put("🐣", R.drawable.emoji_android_7_0_1f423);
        EMOTICONS.put("🐤", R.drawable.emoji_android_7_0_1f424);
        EMOTICONS.put("🐥", R.drawable.emoji_android_7_0_1f425);
        EMOTICONS.put("🐦", R.drawable.emoji_android_7_0_1f426);
        EMOTICONS.put("🐧", R.drawable.emoji_android_7_0_1f427);
        EMOTICONS.put("🦅", R.drawable.emoji_android_7_0_1f985);
        EMOTICONS.put("🦆", R.drawable.emoji_android_7_0_1f986);
        EMOTICONS.put("🦉", R.drawable.emoji_android_7_0_1f989);
        EMOTICONS.put("🐸", R.drawable.emoji_android_7_0_1f438);
        EMOTICONS.put("🐊", R.drawable.emoji_android_7_0_1f40a);
        EMOTICONS.put("🐢", R.drawable.emoji_android_7_0_1f422);
        EMOTICONS.put("🦎", R.drawable.emoji_android_7_0_1f98e);
        EMOTICONS.put("🐍", R.drawable.emoji_android_7_0_1f40d);
        EMOTICONS.put("🐲", R.drawable.emoji_android_7_0_1f432);
        EMOTICONS.put("🐉", R.drawable.emoji_android_7_0_1f409);
        EMOTICONS.put("🐳", R.drawable.emoji_android_7_0_1f433);
        EMOTICONS.put("🐋", R.drawable.emoji_android_7_0_1f40b);
        EMOTICONS.put("🐬", R.drawable.emoji_android_7_0_1f42c);
        EMOTICONS.put("🐟", R.drawable.emoji_android_7_0_1f41f);
        EMOTICONS.put("🐠", R.drawable.emoji_android_7_0_1f420);
        EMOTICONS.put("🐡", R.drawable.emoji_android_7_0_1f421);
        EMOTICONS.put("🦈", R.drawable.emoji_android_7_0_1f988);
        EMOTICONS.put("🐙", R.drawable.emoji_android_7_0_1f419);
        EMOTICONS.put("🐚", R.drawable.emoji_android_7_0_1f41a);
        EMOTICONS.put("🦐", R.drawable.emoji_android_7_0_1f990);
        EMOTICONS.put("🦑", R.drawable.emoji_android_7_0_1f991);
        EMOTICONS.put("🐌", R.drawable.emoji_android_7_0_1f40c);
        EMOTICONS.put("🦋", R.drawable.emoji_android_7_0_1f98b);
        EMOTICONS.put("🐛", R.drawable.emoji_android_7_0_1f41b);
        EMOTICONS.put("🐜", R.drawable.emoji_android_7_0_1f41c);
        EMOTICONS.put("🐝", R.drawable.emoji_android_7_0_1f41d);
        EMOTICONS.put("🐞", R.drawable.emoji_android_7_0_1f41e);
        EMOTICONS.put("💐", R.drawable.emoji_android_7_0_1f490);
        EMOTICONS.put("🌸", R.drawable.emoji_android_7_0_1f338);
        EMOTICONS.put("💮", R.drawable.emoji_android_7_0_1f4ae);
        EMOTICONS.put("🌹", R.drawable.emoji_android_7_0_1f339);
        EMOTICONS.put("🥀", R.drawable.emoji_android_7_0_1f940);
        EMOTICONS.put("🌺", R.drawable.emoji_android_7_0_1f33a);
        EMOTICONS.put("🌻", R.drawable.emoji_android_7_0_1f33b);
        EMOTICONS.put("🌼", R.drawable.emoji_android_7_0_1f33c);
        EMOTICONS.put("🌷", R.drawable.emoji_android_7_0_1f337);
        EMOTICONS.put("🌱", R.drawable.emoji_android_7_0_1f331);
        EMOTICONS.put("🌲", R.drawable.emoji_android_7_0_1f332);
        EMOTICONS.put("🌳", R.drawable.emoji_android_7_0_1f333);
        EMOTICONS.put("🌴", R.drawable.emoji_android_7_0_1f334);
        EMOTICONS.put("🌵", R.drawable.emoji_android_7_0_1f335);
        EMOTICONS.put("🌾", R.drawable.emoji_android_7_0_1f33e);
        EMOTICONS.put("🌿", R.drawable.emoji_android_7_0_1f33f);
        EMOTICONS.put("🍀", R.drawable.emoji_android_7_0_1f340);
        EMOTICONS.put("🍁", R.drawable.emoji_android_7_0_1f341);
        EMOTICONS.put("🍂", R.drawable.emoji_android_7_0_1f342);
        EMOTICONS.put("🍃", R.drawable.emoji_android_7_0_1f343);
        EMOTICONS.put("🍄", R.drawable.emoji_android_7_0_1f344);
        EMOTICONS.put("🌰", R.drawable.emoji_android_7_0_1f330);
        EMOTICONS.put("🌍", R.drawable.emoji_android_7_0_1f30d);
        EMOTICONS.put("🌎", R.drawable.emoji_android_7_0_1f30e);
        EMOTICONS.put("🌏", R.drawable.emoji_android_7_0_1f30f);
        EMOTICONS.put("🌐", R.drawable.emoji_android_7_0_1f310);
        EMOTICONS.put("🌑", R.drawable.emoji_android_7_0_1f311);
        EMOTICONS.put("🌒", R.drawable.emoji_android_7_0_1f312);
        EMOTICONS.put("🌓", R.drawable.emoji_android_7_0_1f313);
        EMOTICONS.put("🌔", R.drawable.emoji_android_7_0_1f314);
        EMOTICONS.put("🌕", R.drawable.emoji_android_7_0_1f315);
        EMOTICONS.put("🌖", R.drawable.emoji_android_7_0_1f316);
        EMOTICONS.put("🌗", R.drawable.emoji_android_7_0_1f317);
        EMOTICONS.put("🌘", R.drawable.emoji_android_7_0_1f318);
        EMOTICONS.put("🌙", R.drawable.emoji_android_7_0_1f319);
        EMOTICONS.put("🌚", R.drawable.emoji_android_7_0_1f31a);
        EMOTICONS.put("🌛", R.drawable.emoji_android_7_0_1f31b);
        EMOTICONS.put("🌜", R.drawable.emoji_android_7_0_1f31c);
        EMOTICONS.put("☀️", R.drawable.emoji_android_7_0_2600);
        EMOTICONS.put("🌝", R.drawable.emoji_android_7_0_1f31d);
        EMOTICONS.put("🌞", R.drawable.emoji_android_7_0_1f31e);
        EMOTICONS.put("⭐", R.drawable.emoji_android_7_0_2b50);
        EMOTICONS.put("🌟", R.drawable.emoji_android_7_0_1f31f);
        EMOTICONS.put("🌠", R.drawable.emoji_android_7_0_1f320);
        EMOTICONS.put("☁️", R.drawable.emoji_android_7_0_2601);
        EMOTICONS.put("⛅", R.drawable.emoji_android_7_0_26c5);
        EMOTICONS.put("🌈", R.drawable.emoji_android_7_0_1f308);
        EMOTICONS.put("☔", R.drawable.emoji_android_7_0_2614);
        EMOTICONS.put("⚡", R.drawable.emoji_android_7_0_26a1);
        EMOTICONS.put("❄️", R.drawable.emoji_android_7_0_2744);
        EMOTICONS.put("⛄", R.drawable.emoji_android_7_0_26c4);
        EMOTICONS.put("🔥", R.drawable.emoji_android_7_0_1f525);
        EMOTICONS.put("💧", R.drawable.emoji_android_7_0_1f4a7);
        EMOTICONS.put("🌊", R.drawable.emoji_android_7_0_1f30a);
        EMOTICONS.put("🎄", R.drawable.emoji_android_7_0_1f384);
        EMOTICONS.put("✨", R.drawable.emoji_android_7_0_2728);
        EMOTICONS.put("🍇", R.drawable.emoji_android_7_0_1f347);
        EMOTICONS.put("🍈", R.drawable.emoji_android_7_0_1f348);
        EMOTICONS.put("🍉", R.drawable.emoji_android_7_0_1f349);
        EMOTICONS.put("🍊", R.drawable.emoji_android_7_0_1f34a);
        EMOTICONS.put("🍋", R.drawable.emoji_android_7_0_1f34b);
        EMOTICONS.put("🍌", R.drawable.emoji_android_7_0_1f34c);
        EMOTICONS.put("🍍", R.drawable.emoji_android_7_0_1f34d);
        EMOTICONS.put("🍎", R.drawable.emoji_android_7_0_1f34e);
        EMOTICONS.put("🍏", R.drawable.emoji_android_7_0_1f34f);
        EMOTICONS.put("🍐", R.drawable.emoji_android_7_0_1f350);
        EMOTICONS.put("🍑", R.drawable.emoji_android_7_0_1f351);
        EMOTICONS.put("🍒", R.drawable.emoji_android_7_0_1f352);
        EMOTICONS.put("🍓", R.drawable.emoji_android_7_0_1f353);
        EMOTICONS.put("🥝", R.drawable.emoji_android_7_0_1f95d);
        EMOTICONS.put("🍅", R.drawable.emoji_android_7_0_1f345);
        EMOTICONS.put("🥑", R.drawable.emoji_android_7_0_1f951);
        EMOTICONS.put("🍆", R.drawable.emoji_android_7_0_1f346);
        EMOTICONS.put("🥔", R.drawable.emoji_android_7_0_1f954);
        EMOTICONS.put("🥕", R.drawable.emoji_android_7_0_1f955);
        EMOTICONS.put("🌽", R.drawable.emoji_android_7_0_1f33d);
        EMOTICONS.put("🥒", R.drawable.emoji_android_7_0_1f952);
        EMOTICONS.put("🍄", R.drawable.emoji_android_7_0_1f344);
        EMOTICONS.put("🥜", R.drawable.emoji_android_7_0_1f95c);
        EMOTICONS.put("🌰", R.drawable.emoji_android_7_0_1f330);
        EMOTICONS.put("🍞", R.drawable.emoji_android_7_0_1f35e);
        EMOTICONS.put("🥐", R.drawable.emoji_android_7_0_1f950);
        EMOTICONS.put("🥖", R.drawable.emoji_android_7_0_1f956);
        EMOTICONS.put("🥞", R.drawable.emoji_android_7_0_1f95e);
        EMOTICONS.put("🍖", R.drawable.emoji_android_7_0_1f356);
        EMOTICONS.put("🍗", R.drawable.emoji_android_7_0_1f357);
        EMOTICONS.put("🥓", R.drawable.emoji_android_7_0_1f953);
        EMOTICONS.put("🍔", R.drawable.emoji_android_7_0_1f354);
        EMOTICONS.put("🍟", R.drawable.emoji_android_7_0_1f35f);
        EMOTICONS.put("🍕", R.drawable.emoji_android_7_0_1f355);
        EMOTICONS.put("🍳", R.drawable.emoji_android_7_0_1f373);
        EMOTICONS.put("🍲", R.drawable.emoji_android_7_0_1f372);
        EMOTICONS.put("🥗", R.drawable.emoji_android_7_0_1f957);
        EMOTICONS.put("🍱", R.drawable.emoji_android_7_0_1f371);
        EMOTICONS.put("🍘", R.drawable.emoji_android_7_0_1f358);
        EMOTICONS.put("🍙", R.drawable.emoji_android_7_0_1f359);
        EMOTICONS.put("🍚", R.drawable.emoji_android_7_0_1f35a);
        EMOTICONS.put("🍛", R.drawable.emoji_android_7_0_1f35b);
        EMOTICONS.put("🍜", R.drawable.emoji_android_7_0_1f35c);
        EMOTICONS.put("🍝", R.drawable.emoji_android_7_0_1f35d);
        EMOTICONS.put("🍠", R.drawable.emoji_android_7_0_1f360);
        EMOTICONS.put("🍢", R.drawable.emoji_android_7_0_1f362);
        EMOTICONS.put("🍣", R.drawable.emoji_android_7_0_1f363);
        EMOTICONS.put("🍤", R.drawable.emoji_android_7_0_1f364);
        EMOTICONS.put("🍥", R.drawable.emoji_android_7_0_1f365);
        EMOTICONS.put("🍡", R.drawable.emoji_android_7_0_1f361);
        EMOTICONS.put("🍦", R.drawable.emoji_android_7_0_1f366);
        EMOTICONS.put("🍧", R.drawable.emoji_android_7_0_1f367);
        EMOTICONS.put("🍨", R.drawable.emoji_android_7_0_1f368);
        EMOTICONS.put("🍩", R.drawable.emoji_android_7_0_1f369);
        EMOTICONS.put("🍪", R.drawable.emoji_android_7_0_1f36a);
        EMOTICONS.put("🎂", R.drawable.emoji_android_7_0_1f382);
        EMOTICONS.put("🍰", R.drawable.emoji_android_7_0_1f370);
        EMOTICONS.put("🍫", R.drawable.emoji_android_7_0_1f36b);
        EMOTICONS.put("🍬", R.drawable.emoji_android_7_0_1f36c);
        EMOTICONS.put("🍭", R.drawable.emoji_android_7_0_1f36d);
        EMOTICONS.put("🍮", R.drawable.emoji_android_7_0_1f36e);
        EMOTICONS.put("🍯", R.drawable.emoji_android_7_0_1f36f);
        EMOTICONS.put("🍼", R.drawable.emoji_android_7_0_1f37c);
        EMOTICONS.put("🥛", R.drawable.emoji_android_7_0_1f95b);
        EMOTICONS.put("☕", R.drawable.emoji_android_7_0_2615);
        EMOTICONS.put("🍵", R.drawable.emoji_android_7_0_1f375);
        EMOTICONS.put("🍶", R.drawable.emoji_android_7_0_1f376);
        EMOTICONS.put("🍷", R.drawable.emoji_android_7_0_1f377);
        EMOTICONS.put("🍸", R.drawable.emoji_android_7_0_1f378);
        EMOTICONS.put("🍹", R.drawable.emoji_android_7_0_1f379);
        EMOTICONS.put("🍺", R.drawable.emoji_android_7_0_1f37a);
        EMOTICONS.put("🍻", R.drawable.emoji_android_7_0_1f37b);
        EMOTICONS.put("🥂", R.drawable.emoji_android_7_0_1f942);
        EMOTICONS.put("🥃", R.drawable.emoji_android_7_0_1f943);
        EMOTICONS.put("🍴", R.drawable.emoji_android_7_0_1f374);
        EMOTICONS.put("🥄", R.drawable.emoji_android_7_0_1f944);
        EMOTICONS.put("👾", R.drawable.emoji_android_7_0_1f47e);
        EMOTICONS.put("🏇", R.drawable.emoji_android_7_0_1f3c7);
        EMOTICONS.put("⛷️", R.drawable.emoji_android_7_0_26f7);
        EMOTICONS.put("🏂", R.drawable.emoji_android_7_0_1f3c2);
        EMOTICONS.put("🏌️", R.drawable.emoji_android_7_0_1f3cc);
        EMOTICONS.put("🏄", R.drawable.emoji_android_7_0_1f3c4);
        EMOTICONS.put("🚣", R.drawable.emoji_android_7_0_1f6a3);
        EMOTICONS.put("🏊", R.drawable.emoji_android_7_0_1f3ca);
        EMOTICONS.put("⛹️", R.drawable.emoji_android_7_0_26f9);
        EMOTICONS.put("🏋️", R.drawable.emoji_android_7_0_1f3cb);
        EMOTICONS.put("🚴", R.drawable.emoji_android_7_0_1f6b4);
        EMOTICONS.put("🚵", R.drawable.emoji_android_7_0_1f6b5);
        EMOTICONS.put("🤸", R.drawable.emoji_android_7_0_1f938);
        EMOTICONS.put("🤼", R.drawable.emoji_android_7_0_1f93c);
        EMOTICONS.put("🤽", R.drawable.emoji_android_7_0_1f93d);
        EMOTICONS.put("🤾", R.drawable.emoji_android_7_0_1f93e);
        EMOTICONS.put("🤹", R.drawable.emoji_android_7_0_1f939);
        EMOTICONS.put("🎪", R.drawable.emoji_android_7_0_1f3aa);
        EMOTICONS.put("🎭", R.drawable.emoji_android_7_0_1f3ad);
        EMOTICONS.put("🎨", R.drawable.emoji_android_7_0_1f3a8);
        EMOTICONS.put("🎰", R.drawable.emoji_android_7_0_1f3b0);
        EMOTICONS.put("🥇", R.drawable.emoji_android_7_0_1f947);
        EMOTICONS.put("🥈", R.drawable.emoji_android_7_0_1f948);
        EMOTICONS.put("🥉", R.drawable.emoji_android_7_0_1f949);
        EMOTICONS.put("⚾", R.drawable.emoji_android_7_0_26be);
        EMOTICONS.put("🥊", R.drawable.emoji_android_7_0_1f94a);
        EMOTICONS.put("🥋", R.drawable.emoji_android_7_0_1f94b);
        EMOTICONS.put("⛳", R.drawable.emoji_android_7_0_26f3);
        EMOTICONS.put("🎲", R.drawable.emoji_android_7_0_1f3b2);
        EMOTICONS.put("🥁", R.drawable.emoji_android_7_0_1f941);
        EMOTICONS.put("🚣", R.drawable.emoji_android_7_0_1f6a3);
        EMOTICONS.put("🗾", R.drawable.emoji_android_7_0_1f5fe);
        EMOTICONS.put("🌋", R.drawable.emoji_android_7_0_1f30b);
        EMOTICONS.put("🗻", R.drawable.emoji_android_7_0_1f5fb);
        EMOTICONS.put("🏠", R.drawable.emoji_android_7_0_1f3e0);
        EMOTICONS.put("🏡", R.drawable.emoji_android_7_0_1f3e1);
        EMOTICONS.put("🏢", R.drawable.emoji_android_7_0_1f3e2);
        EMOTICONS.put("🏣", R.drawable.emoji_android_7_0_1f3e3);
        EMOTICONS.put("🏤", R.drawable.emoji_android_7_0_1f3e4);
        EMOTICONS.put("🏥", R.drawable.emoji_android_7_0_1f3e5);
        EMOTICONS.put("🏦", R.drawable.emoji_android_7_0_1f3e6);
        EMOTICONS.put("🏨", R.drawable.emoji_android_7_0_1f3e8);
        EMOTICONS.put("🏩", R.drawable.emoji_android_7_0_1f3e9);
        EMOTICONS.put("🏪", R.drawable.emoji_android_7_0_1f3ea);
        EMOTICONS.put("🏫", R.drawable.emoji_android_7_0_1f3eb);
        EMOTICONS.put("🏬", R.drawable.emoji_android_7_0_1f3ec);
        EMOTICONS.put("🏭", R.drawable.emoji_android_7_0_1f3ed);
        EMOTICONS.put("🏯", R.drawable.emoji_android_7_0_1f3ef);
        EMOTICONS.put("🏰", R.drawable.emoji_android_7_0_1f3f0);
        EMOTICONS.put("💒", R.drawable.emoji_android_7_0_1f492);
        EMOTICONS.put("🗼", R.drawable.emoji_android_7_0_1f5fc);
        EMOTICONS.put("🗽", R.drawable.emoji_android_7_0_1f5fd);
        EMOTICONS.put("⛪", R.drawable.emoji_android_7_0_26ea);
        EMOTICONS.put("⛲", R.drawable.emoji_android_7_0_26f2);
        EMOTICONS.put("⛺", R.drawable.emoji_android_7_0_26fa);
        EMOTICONS.put("🌁", R.drawable.emoji_android_7_0_1f301);
        EMOTICONS.put("🌃", R.drawable.emoji_android_7_0_1f303);
        EMOTICONS.put("🌄", R.drawable.emoji_android_7_0_1f304);
        EMOTICONS.put("🌅", R.drawable.emoji_android_7_0_1f305);
        EMOTICONS.put("🌆", R.drawable.emoji_android_7_0_1f306);
        EMOTICONS.put("🌇", R.drawable.emoji_android_7_0_1f307);
        EMOTICONS.put("🌉", R.drawable.emoji_android_7_0_1f309);
        EMOTICONS.put("🌌", R.drawable.emoji_android_7_0_1f30c);
        EMOTICONS.put("🎠", R.drawable.emoji_android_7_0_1f3a0);
        EMOTICONS.put("🎡", R.drawable.emoji_android_7_0_1f3a1);
        EMOTICONS.put("🎢", R.drawable.emoji_android_7_0_1f3a2);
        EMOTICONS.put("🚂", R.drawable.emoji_android_7_0_1f682);
        EMOTICONS.put("🚃", R.drawable.emoji_android_7_0_1f683);
        EMOTICONS.put("🚄", R.drawable.emoji_android_7_0_1f684);
        EMOTICONS.put("🚅", R.drawable.emoji_android_7_0_1f685);
        EMOTICONS.put("🚆", R.drawable.emoji_android_7_0_1f686);
        EMOTICONS.put("🚇", R.drawable.emoji_android_7_0_1f687);
        EMOTICONS.put("🚈", R.drawable.emoji_android_7_0_1f688);
        EMOTICONS.put("🚉", R.drawable.emoji_android_7_0_1f689);
        EMOTICONS.put("🚊", R.drawable.emoji_android_7_0_1f68a);
        EMOTICONS.put("🚝", R.drawable.emoji_android_7_0_1f69d);
        EMOTICONS.put("🚞", R.drawable.emoji_android_7_0_1f69e);
        EMOTICONS.put("🚋", R.drawable.emoji_android_7_0_1f68b);
        EMOTICONS.put("🚌", R.drawable.emoji_android_7_0_1f68c);
        EMOTICONS.put("🚍", R.drawable.emoji_android_7_0_1f68d);
        EMOTICONS.put("🚎", R.drawable.emoji_android_7_0_1f68e);
        EMOTICONS.put("🚐", R.drawable.emoji_android_7_0_1f690);
        EMOTICONS.put("🚑", R.drawable.emoji_android_7_0_1f691);
        EMOTICONS.put("🚒", R.drawable.emoji_android_7_0_1f692);
        EMOTICONS.put("🚓", R.drawable.emoji_android_7_0_1f693);
        EMOTICONS.put("🚔", R.drawable.emoji_android_7_0_1f694);
        EMOTICONS.put("🚕", R.drawable.emoji_android_7_0_1f695);
        EMOTICONS.put("🚖", R.drawable.emoji_android_7_0_1f696);
        EMOTICONS.put("🚗", R.drawable.emoji_android_7_0_1f697);
        EMOTICONS.put("🚘", R.drawable.emoji_android_7_0_1f698);
        EMOTICONS.put("🚚", R.drawable.emoji_android_7_0_1f69a);
        EMOTICONS.put("🚛", R.drawable.emoji_android_7_0_1f69b);
        EMOTICONS.put("🚜", R.drawable.emoji_android_7_0_1f69c);
        EMOTICONS.put("🚲", R.drawable.emoji_android_7_0_1f6b2);
        EMOTICONS.put("🛴", R.drawable.emoji_android_7_0_1f6f4);
        EMOTICONS.put("🛵", R.drawable.emoji_android_7_0_1f6f5);
        EMOTICONS.put("🚏", R.drawable.emoji_android_7_0_1f68f);
        EMOTICONS.put("⛽", R.drawable.emoji_android_7_0_26fd);
        EMOTICONS.put("🚨", R.drawable.emoji_android_7_0_1f6a8);
        EMOTICONS.put("🚥", R.drawable.emoji_android_7_0_1f6a5);
        EMOTICONS.put("🚦", R.drawable.emoji_android_7_0_1f6a6);
        EMOTICONS.put("🚧", R.drawable.emoji_android_7_0_1f6a7);
        EMOTICONS.put("⚓", R.drawable.emoji_android_7_0_2693);
        EMOTICONS.put("⛵", R.drawable.emoji_android_7_0_26f5);
        EMOTICONS.put("🚤", R.drawable.emoji_android_7_0_1f6a4);
        EMOTICONS.put("🚢", R.drawable.emoji_android_7_0_1f6a2);
        EMOTICONS.put("✈️", R.drawable.emoji_android_7_0_2708);
        EMOTICONS.put("💺", R.drawable.emoji_android_7_0_1f4ba);
        EMOTICONS.put("🚁", R.drawable.emoji_android_7_0_1f681);
        EMOTICONS.put("🚟", R.drawable.emoji_android_7_0_1f69f);
        EMOTICONS.put("🚠", R.drawable.emoji_android_7_0_1f6a0);
        EMOTICONS.put("🚡", R.drawable.emoji_android_7_0_1f6a1);
        EMOTICONS.put("🚀", R.drawable.emoji_android_7_0_1f680);
        EMOTICONS.put("🌠", R.drawable.emoji_android_7_0_1f320);
        EMOTICONS.put("🎆", R.drawable.emoji_android_7_0_1f386);
        EMOTICONS.put("🎇", R.drawable.emoji_android_7_0_1f387);
        EMOTICONS.put("💴", R.drawable.emoji_android_7_0_1f4b4);
        EMOTICONS.put("💵", R.drawable.emoji_android_7_0_1f4b5);
        EMOTICONS.put("💶", R.drawable.emoji_android_7_0_1f4b6);
        EMOTICONS.put("💷", R.drawable.emoji_android_7_0_1f4b7);
        EMOTICONS.put("🛂", R.drawable.emoji_android_7_0_1f6c2);
        EMOTICONS.put("🛃", R.drawable.emoji_android_7_0_1f6c3);
        EMOTICONS.put("🛀", R.drawable.emoji_android_7_0_1f6c0);
        EMOTICONS.put("💌", R.drawable.emoji_android_7_0_1f48c);
        EMOTICONS.put("💣", R.drawable.emoji_android_7_0_1f4a3);
        EMOTICONS.put("💎", R.drawable.emoji_android_7_0_1f48e);
        EMOTICONS.put("🔪", R.drawable.emoji_android_7_0_1f52a);
        EMOTICONS.put("💈", R.drawable.emoji_android_7_0_1f488);
        EMOTICONS.put("🚪", R.drawable.emoji_android_7_0_1f6aa);
        EMOTICONS.put("🚽", R.drawable.emoji_android_7_0_1f6bd);
        EMOTICONS.put("🚿", R.drawable.emoji_android_7_0_1f6bf);
        EMOTICONS.put("🛁", R.drawable.emoji_android_7_0_1f6c1);
        EMOTICONS.put("⌛", R.drawable.emoji_android_7_0_231b);
        EMOTICONS.put("⏳", R.drawable.emoji_android_7_0_23f3);
        EMOTICONS.put("⌚", R.drawable.emoji_android_7_0_231a);
        EMOTICONS.put("⏰", R.drawable.emoji_android_7_0_23f0);
        EMOTICONS.put("🎈", R.drawable.emoji_android_7_0_1f388);
        EMOTICONS.put("🔬", R.drawable.emoji_android_7_0_1f52c);
        EMOTICONS.put("📃", R.drawable.emoji_android_7_0_1f4c3);
        EMOTICONS.put("📜", R.drawable.emoji_android_7_0_1f4dc);
        EMOTICONS.put("📄", R.drawable.emoji_android_7_0_1f4c4);
        EMOTICONS.put("📰", R.drawable.emoji_android_7_0_1f4f0);
        EMOTICONS.put("💰", R.drawable.emoji_android_7_0_1f4b0);
        EMOTICONS.put("💴", R.drawable.emoji_android_7_0_1f4b4);
        EMOTICONS.put("💵", R.drawable.emoji_android_7_0_1f4b5);
        EMOTICONS.put("💶", R.drawable.emoji_android_7_0_1f4b6);
        EMOTICONS.put("💷", R.drawable.emoji_android_7_0_1f4b7);
        EMOTICONS.put("📝", R.drawable.emoji_android_7_0_1f4dd);
        EMOTICONS.put("📅", R.drawable.emoji_android_7_0_1f4c5);
        EMOTICONS.put("📆", R.drawable.emoji_android_7_0_1f4c6);
        EMOTICONS.put("🗒️", R.drawable.emoji_android_7_0_1f5d2);
        EMOTICONS.put("🗓️", R.drawable.emoji_android_7_0_1f5d3);
        EMOTICONS.put("🔫", R.drawable.emoji_android_7_0_1f52b);
        EMOTICONS.put("🚰", R.drawable.emoji_android_7_0_1f6b0);
        EMOTICONS.put("🎌", R.drawable.emoji_android_7_0_1f38c);
        EMOTICONS.put("🏳️", R.drawable.emoji_android_7_0_1f3f3);
        EMOTICONS.put("💘", R.drawable.emoji_android_7_0_1f498);
        EMOTICONS.put("❤️", R.drawable.emoji_android_7_0_2764);
        EMOTICONS.put("💓", R.drawable.emoji_android_7_0_1f493);
        EMOTICONS.put("💔", R.drawable.emoji_android_7_0_1f494);
        EMOTICONS.put("💕", R.drawable.emoji_android_7_0_1f495);
        EMOTICONS.put("💖", R.drawable.emoji_android_7_0_1f496);
        EMOTICONS.put("💗", R.drawable.emoji_android_7_0_1f497);
        EMOTICONS.put("💙", R.drawable.emoji_android_7_0_1f499);
        EMOTICONS.put("💚", R.drawable.emoji_android_7_0_1f49a);
        EMOTICONS.put("💛", R.drawable.emoji_android_7_0_1f49b);
        EMOTICONS.put("💜", R.drawable.emoji_android_7_0_1f49c);
        EMOTICONS.put("🖤", R.drawable.emoji_android_7_0_1f5a4);
        EMOTICONS.put("💝", R.drawable.emoji_android_7_0_1f49d);
        EMOTICONS.put("💞", R.drawable.emoji_android_7_0_1f49e);
        EMOTICONS.put("💟", R.drawable.emoji_android_7_0_1f49f);
        EMOTICONS.put("💤", R.drawable.emoji_android_7_0_1f4a4);
        EMOTICONS.put("💢", R.drawable.emoji_android_7_0_1f4a2);
        EMOTICONS.put("💬", R.drawable.emoji_android_7_0_1f4ac);
        EMOTICONS.put("💭", R.drawable.emoji_android_7_0_1f4ad);
        EMOTICONS.put("💮", R.drawable.emoji_android_7_0_1f4ae);
        EMOTICONS.put("♨️", R.drawable.emoji_android_7_0_2668);
        EMOTICONS.put("💈", R.drawable.emoji_android_7_0_1f488);
        EMOTICONS.put("🛑", R.drawable.emoji_android_7_0_1f6d1);
        EMOTICONS.put("🕛", R.drawable.emoji_android_7_0_1f55b);
        EMOTICONS.put("🕧", R.drawable.emoji_android_7_0_1f567);
        EMOTICONS.put("🕐", R.drawable.emoji_android_7_0_1f550);
        EMOTICONS.put("🕜", R.drawable.emoji_android_7_0_1f55c);
        EMOTICONS.put("🕑", R.drawable.emoji_android_7_0_1f551);
        EMOTICONS.put("🕝", R.drawable.emoji_android_7_0_1f55d);
        EMOTICONS.put("🕒", R.drawable.emoji_android_7_0_1f552);
        EMOTICONS.put("🕞", R.drawable.emoji_android_7_0_1f55e);
        EMOTICONS.put("🕓", R.drawable.emoji_android_7_0_1f553);
        EMOTICONS.put("🕟", R.drawable.emoji_android_7_0_1f55f);
        EMOTICONS.put("🕔", R.drawable.emoji_android_7_0_1f554);
        EMOTICONS.put("🕠", R.drawable.emoji_android_7_0_1f560);
        EMOTICONS.put("🕕", R.drawable.emoji_android_7_0_1f555);
        EMOTICONS.put("🕡", R.drawable.emoji_android_7_0_1f561);
        EMOTICONS.put("🕖", R.drawable.emoji_android_7_0_1f556);
        EMOTICONS.put("🕢", R.drawable.emoji_android_7_0_1f562);
        EMOTICONS.put("🕗", R.drawable.emoji_android_7_0_1f557);
        EMOTICONS.put("🕣", R.drawable.emoji_android_7_0_1f563);
        EMOTICONS.put("🕘", R.drawable.emoji_android_7_0_1f558);
        EMOTICONS.put("🕤", R.drawable.emoji_android_7_0_1f564);
        EMOTICONS.put("🕙", R.drawable.emoji_android_7_0_1f559);
        EMOTICONS.put("🕥", R.drawable.emoji_android_7_0_1f565);
        EMOTICONS.put("🕚", R.drawable.emoji_android_7_0_1f55a);
        EMOTICONS.put("🕦", R.drawable.emoji_android_7_0_1f566);
        EMOTICONS.put("🌀", R.drawable.emoji_android_7_0_1f300);
        EMOTICONS.put("♥️", R.drawable.emoji_android_7_0_2665);
        EMOTICONS.put("♦️", R.drawable.emoji_android_7_0_2666);
        EMOTICONS.put("🚮", R.drawable.emoji_android_7_0_1f6ae);
        EMOTICONS.put("🚰", R.drawable.emoji_android_7_0_1f6b0);
        EMOTICONS.put("♿", R.drawable.emoji_android_7_0_267f);
        EMOTICONS.put("🚹", R.drawable.emoji_android_7_0_1f6b9);
        EMOTICONS.put("🚺", R.drawable.emoji_android_7_0_1f6ba);
        EMOTICONS.put("🚻", R.drawable.emoji_android_7_0_1f6bb);
        EMOTICONS.put("🚼", R.drawable.emoji_android_7_0_1f6bc);
        EMOTICONS.put("🚾", R.drawable.emoji_android_7_0_1f6be);
        EMOTICONS.put("🚸", R.drawable.emoji_android_7_0_1f6b8);
        EMOTICONS.put("🚯", R.drawable.emoji_android_7_0_1f6af);
        EMOTICONS.put("🚱", R.drawable.emoji_android_7_0_1f6b1);
        EMOTICONS.put("🚷", R.drawable.emoji_android_7_0_1f6b7);
        EMOTICONS.put("⤴️", R.drawable.emoji_android_7_0_2934);
        EMOTICONS.put("🛐", R.drawable.emoji_android_7_0_1f6d0);
        EMOTICONS.put("🔼", R.drawable.emoji_android_7_0_1f53c);
        EMOTICONS.put("🔽", R.drawable.emoji_android_7_0_1f53d);
        EMOTICONS.put("⭕", R.drawable.emoji_android_7_0_2b55);
        EMOTICONS.put("✅", R.drawable.emoji_android_7_0_2705);
        EMOTICONS.put("✔️", R.drawable.emoji_android_7_0_2714);
        EMOTICONS.put("❔", R.drawable.emoji_android_7_0_2754);
        EMOTICONS.put("❕", R.drawable.emoji_android_7_0_2755);
        EMOTICONS.put("#️⃣", R.drawable.emoji_android_7_0_23_fe0f_20e3);
        EMOTICONS.put("0️⃣", R.drawable.emoji_android_7_0_30_fe0f_20e3);
        EMOTICONS.put("1️⃣", R.drawable.emoji_android_7_0_31_fe0f_20e3);
        EMOTICONS.put("2️⃣", R.drawable.emoji_android_7_0_32_fe0f_20e3);
        EMOTICONS.put("3️⃣", R.drawable.emoji_android_7_0_33_fe0f_20e3);
        EMOTICONS.put("4️⃣", R.drawable.emoji_android_7_0_34_fe0f_20e3);
        EMOTICONS.put("5️⃣", R.drawable.emoji_android_7_0_35_fe0f_20e3);
        EMOTICONS.put("6️⃣", R.drawable.emoji_android_7_0_36_fe0f_20e3);
        EMOTICONS.put("7️⃣", R.drawable.emoji_android_7_0_37_fe0f_20e3);
        EMOTICONS.put("8️⃣", R.drawable.emoji_android_7_0_38_fe0f_20e3);
        EMOTICONS.put("9️⃣", R.drawable.emoji_android_7_0_39_fe0f_20e3);
        EMOTICONS.put("🆎", R.drawable.emoji_android_7_0_1f18e);
        EMOTICONS.put("🅱️", R.drawable.emoji_android_7_0_1f171);
        EMOTICONS.put("🆑", R.drawable.emoji_android_7_0_1f191);
        EMOTICONS.put("🆓", R.drawable.emoji_android_7_0_1f193);
        EMOTICONS.put("🆔", R.drawable.emoji_android_7_0_1f194);
        EMOTICONS.put("🆕", R.drawable.emoji_android_7_0_1f195);
        EMOTICONS.put("🆖", R.drawable.emoji_android_7_0_1f196);
        EMOTICONS.put("🅾️", R.drawable.emoji_android_7_0_1f17e);
        EMOTICONS.put("🆗", R.drawable.emoji_android_7_0_1f197);
        EMOTICONS.put("🆘", R.drawable.emoji_android_7_0_1f198);
        EMOTICONS.put("🆙", R.drawable.emoji_android_7_0_1f199);
        EMOTICONS.put("🆚", R.drawable.emoji_android_7_0_1f19a);
        EMOTICONS.put("▪️", R.drawable.emoji_android_7_0_25aa);
        EMOTICONS.put("▫️", R.drawable.emoji_android_7_0_25ab);
        EMOTICONS.put("◻️", R.drawable.emoji_android_7_0_25fb);
        EMOTICONS.put("◼️", R.drawable.emoji_android_7_0_25fc);
        EMOTICONS.put("◽", R.drawable.emoji_android_7_0_25fd);
        EMOTICONS.put("◾", R.drawable.emoji_android_7_0_25fe);
        EMOTICONS.put("⬛", R.drawable.emoji_android_7_0_2b1b);
        EMOTICONS.put("⬜", R.drawable.emoji_android_7_0_2b1c);
        EMOTICONS.put("🔶", R.drawable.emoji_android_7_0_1f536);
        EMOTICONS.put("🔷", R.drawable.emoji_android_7_0_1f537);
        EMOTICONS.put("🔸", R.drawable.emoji_android_7_0_1f538);
        EMOTICONS.put("🔹", R.drawable.emoji_android_7_0_1f539);
        EMOTICONS.put("🔺", R.drawable.emoji_android_7_0_1f53a);
        EMOTICONS.put("🔻", R.drawable.emoji_android_7_0_1f53b);
        EMOTICONS.put("💠", R.drawable.emoji_android_7_0_1f4a0);
        EMOTICONS.put("🔲", R.drawable.emoji_android_7_0_1f532);
        EMOTICONS.put("🔳", R.drawable.emoji_android_7_0_1f533);
        EMOTICONS.put("⚪", R.drawable.emoji_android_7_0_26aa);
        EMOTICONS.put("⚫", R.drawable.emoji_android_7_0_26ab);
        EMOTICONS.put("🔴", R.drawable.emoji_android_7_0_1f534);
        EMOTICONS.put("🔵", R.drawable.emoji_android_7_0_1f535);
        EMOTICONS.put("🎌", R.drawable.emoji_android_7_0_1f38c);
        EMOTICONS.put("🏳️", R.drawable.emoji_android_7_0_1f3f3);
        EMOTICONS.put("🇦🇨", R.drawable.emoji_android_7_0_1f1e6_1f1e8);
        EMOTICONS.put("🇦🇩", R.drawable.emoji_android_7_0_1f1e6_1f1e9);
        EMOTICONS.put("🇦🇪", R.drawable.emoji_android_7_0_1f1e6_1f1ea);
        EMOTICONS.put("🇦🇫", R.drawable.emoji_android_7_0_1f1e6_1f1eb);
        EMOTICONS.put("🇦🇬", R.drawable.emoji_android_7_0_1f1e6_1f1ec);
        EMOTICONS.put("🇦🇮", R.drawable.emoji_android_7_0_1f1e6_1f1ee);
        EMOTICONS.put("🇦🇱", R.drawable.emoji_android_7_0_1f1e6_1f1f1);
        EMOTICONS.put("🇦🇲", R.drawable.emoji_android_7_0_1f1e6_1f1f2);
        EMOTICONS.put("🇦🇴", R.drawable.emoji_android_7_0_1f1e6_1f1f4);
        EMOTICONS.put("🇦🇶", R.drawable.emoji_android_7_0_1f1e6_1f1f6);
        EMOTICONS.put("🇦🇷", R.drawable.emoji_android_7_0_1f1e6_1f1f7);
        EMOTICONS.put("🇦🇸", R.drawable.emoji_android_7_0_1f1e6_1f1f8);
        EMOTICONS.put("🇦🇹", R.drawable.emoji_android_7_0_1f1e6_1f1f9);
        EMOTICONS.put("🇦🇺", R.drawable.emoji_android_7_0_1f1e6_1f1fa);
        EMOTICONS.put("🇦🇼", R.drawable.emoji_android_7_0_1f1e6_1f1fc);
        EMOTICONS.put("🇦🇽", R.drawable.emoji_android_7_0_1f1e6_1f1fd);
        EMOTICONS.put("🇦🇿", R.drawable.emoji_android_7_0_1f1e6_1f1ff);
        EMOTICONS.put("🇧🇦", R.drawable.emoji_android_7_0_1f1e7_1f1e6);
        EMOTICONS.put("🇧🇧", R.drawable.emoji_android_7_0_1f1e7_1f1e7);
        EMOTICONS.put("🇧🇩", R.drawable.emoji_android_7_0_1f1e7_1f1e9);
        EMOTICONS.put("🇧🇪", R.drawable.emoji_android_7_0_1f1e7_1f1ea);
        EMOTICONS.put("🇧🇫", R.drawable.emoji_android_7_0_1f1e7_1f1eb);
        EMOTICONS.put("🇧🇬", R.drawable.emoji_android_7_0_1f1e7_1f1ec);
        EMOTICONS.put("🇧🇭", R.drawable.emoji_android_7_0_1f1e7_1f1ed);
        EMOTICONS.put("🇧🇮", R.drawable.emoji_android_7_0_1f1e7_1f1ee);
        EMOTICONS.put("🇧🇯", R.drawable.emoji_android_7_0_1f1e7_1f1ef);
        EMOTICONS.put("🇧🇲", R.drawable.emoji_android_7_0_1f1e7_1f1f2);
        EMOTICONS.put("🇧🇳", R.drawable.emoji_android_7_0_1f1e7_1f1f3);
        EMOTICONS.put("🇧🇴", R.drawable.emoji_android_7_0_1f1e7_1f1f4);
        EMOTICONS.put("🇧🇷", R.drawable.emoji_android_7_0_1f1e7_1f1f7);
        EMOTICONS.put("🇧🇸", R.drawable.emoji_android_7_0_1f1e7_1f1f8);
        EMOTICONS.put("🇧🇹", R.drawable.emoji_android_7_0_1f1e7_1f1f9);
        EMOTICONS.put("🇧🇻", R.drawable.emoji_android_7_0_1f1e7_1f1fb);
        EMOTICONS.put("🇧🇼", R.drawable.emoji_android_7_0_1f1e7_1f1fc);
        EMOTICONS.put("🇧🇾", R.drawable.emoji_android_7_0_1f1e7_1f1fe);
        EMOTICONS.put("🇧🇿", R.drawable.emoji_android_7_0_1f1e7_1f1ff);
        EMOTICONS.put("🇨🇦", R.drawable.emoji_android_7_0_1f1e8_1f1e6);
        EMOTICONS.put("🇨🇨", R.drawable.emoji_android_7_0_1f1e8_1f1e8);
        EMOTICONS.put("🇨🇩", R.drawable.emoji_android_7_0_1f1e8_1f1e9);
        EMOTICONS.put("🇨🇫", R.drawable.emoji_android_7_0_1f1e8_1f1eb);
        EMOTICONS.put("🇨🇬", R.drawable.emoji_android_7_0_1f1e8_1f1ec);
        EMOTICONS.put("🇨🇭", R.drawable.emoji_android_7_0_1f1e8_1f1ed);
        EMOTICONS.put("🇨🇮", R.drawable.emoji_android_7_0_1f1e8_1f1ee);
        EMOTICONS.put("🇨🇰", R.drawable.emoji_android_7_0_1f1e8_1f1f0);
        EMOTICONS.put("🇨🇱", R.drawable.emoji_android_7_0_1f1e8_1f1f1);
        EMOTICONS.put("🇨🇲", R.drawable.emoji_android_7_0_1f1e8_1f1f2);
        EMOTICONS.put("🇨🇳", R.drawable.emoji_android_7_0_1f1e8_1f1f3);
        EMOTICONS.put("🇨🇴", R.drawable.emoji_android_7_0_1f1e8_1f1f4);
        EMOTICONS.put("🇨🇵", R.drawable.emoji_android_7_0_1f1e8_1f1f5);
        EMOTICONS.put("🇨🇷", R.drawable.emoji_android_7_0_1f1e8_1f1f7);
        EMOTICONS.put("🇨🇺", R.drawable.emoji_android_7_0_1f1e8_1f1fa);
        EMOTICONS.put("🇨🇻", R.drawable.emoji_android_7_0_1f1e8_1f1fb);
        EMOTICONS.put("🇨🇼", R.drawable.emoji_android_7_0_1f1e8_1f1fc);
        EMOTICONS.put("🇨🇽", R.drawable.emoji_android_7_0_1f1e8_1f1fd);
        EMOTICONS.put("🇨🇾", R.drawable.emoji_android_7_0_1f1e8_1f1fe);
        EMOTICONS.put("🇨🇿", R.drawable.emoji_android_7_0_1f1e8_1f1ff);
        EMOTICONS.put("🇩🇪", R.drawable.emoji_android_7_0_1f1e9_1f1ea);
        EMOTICONS.put("🇩🇯", R.drawable.emoji_android_7_0_1f1e9_1f1ef);
        EMOTICONS.put("🇩🇰", R.drawable.emoji_android_7_0_1f1e9_1f1f0);
        EMOTICONS.put("🇩🇲", R.drawable.emoji_android_7_0_1f1e9_1f1f2);
        EMOTICONS.put("🇩🇴", R.drawable.emoji_android_7_0_1f1e9_1f1f4);
        EMOTICONS.put("🇩🇿", R.drawable.emoji_android_7_0_1f1e9_1f1ff);
        EMOTICONS.put("🇪🇨", R.drawable.emoji_android_7_0_1f1ea_1f1e8);
        EMOTICONS.put("🇪🇪", R.drawable.emoji_android_7_0_1f1ea_1f1ea);
        EMOTICONS.put("🇪🇬", R.drawable.emoji_android_7_0_1f1ea_1f1ec);
        EMOTICONS.put("🇪🇷", R.drawable.emoji_android_7_0_1f1ea_1f1f7);
        EMOTICONS.put("🇪🇸", R.drawable.emoji_android_7_0_1f1ea_1f1f8);
        EMOTICONS.put("🇪🇹", R.drawable.emoji_android_7_0_1f1ea_1f1f9);
        EMOTICONS.put("🇪🇺", R.drawable.emoji_android_7_0_1f1ea_1f1fa);
        EMOTICONS.put("🇫🇮", R.drawable.emoji_android_7_0_1f1eb_1f1ee);
        EMOTICONS.put("🇫🇯", R.drawable.emoji_android_7_0_1f1eb_1f1ef);
        EMOTICONS.put("🇫🇲", R.drawable.emoji_android_7_0_1f1eb_1f1f2);
        EMOTICONS.put("🇫🇴", R.drawable.emoji_android_7_0_1f1eb_1f1f4);
        EMOTICONS.put("🇫🇷", R.drawable.emoji_android_7_0_1f1eb_1f1f7);
        EMOTICONS.put("🇬🇦", R.drawable.emoji_android_7_0_1f1ec_1f1e6);
        EMOTICONS.put("🇬🇧", R.drawable.emoji_android_7_0_1f1ec_1f1e7);
        EMOTICONS.put("🇬🇩", R.drawable.emoji_android_7_0_1f1ec_1f1e9);
        EMOTICONS.put("🇬🇪", R.drawable.emoji_android_7_0_1f1ec_1f1ea);
        EMOTICONS.put("🇬🇬", R.drawable.emoji_android_7_0_1f1ec_1f1ec);
        EMOTICONS.put("🇬🇭", R.drawable.emoji_android_7_0_1f1ec_1f1ed);
        EMOTICONS.put("🇬🇮", R.drawable.emoji_android_7_0_1f1ec_1f1ee);
        EMOTICONS.put("🇬🇱", R.drawable.emoji_android_7_0_1f1ec_1f1f1);
        EMOTICONS.put("🇬🇲", R.drawable.emoji_android_7_0_1f1ec_1f1f2);
        EMOTICONS.put("🇬🇳", R.drawable.emoji_android_7_0_1f1ec_1f1f3);
        EMOTICONS.put("🇬🇶", R.drawable.emoji_android_7_0_1f1ec_1f1f6);
        EMOTICONS.put("🇬🇷", R.drawable.emoji_android_7_0_1f1ec_1f1f7);
        EMOTICONS.put("🇬🇹", R.drawable.emoji_android_7_0_1f1ec_1f1f9);
        EMOTICONS.put("🇬🇺", R.drawable.emoji_android_7_0_1f1ec_1f1fa);
        EMOTICONS.put("🇬🇼", R.drawable.emoji_android_7_0_1f1ec_1f1fc);
        EMOTICONS.put("🇬🇾", R.drawable.emoji_android_7_0_1f1ec_1f1fe);
        EMOTICONS.put("🇭🇰", R.drawable.emoji_android_7_0_1f1ed_1f1f0);
        EMOTICONS.put("🇭🇲", R.drawable.emoji_android_7_0_1f1ed_1f1f2);
        EMOTICONS.put("🇭🇳", R.drawable.emoji_android_7_0_1f1ed_1f1f3);
        EMOTICONS.put("🇭🇷", R.drawable.emoji_android_7_0_1f1ed_1f1f7);
        EMOTICONS.put("🇭🇹", R.drawable.emoji_android_7_0_1f1ed_1f1f9);
        EMOTICONS.put("🇭🇺", R.drawable.emoji_android_7_0_1f1ed_1f1fa);
        EMOTICONS.put("🇮🇨", R.drawable.emoji_android_7_0_1f1ee_1f1e8);
        EMOTICONS.put("🇮🇩", R.drawable.emoji_android_7_0_1f1ee_1f1e9);
        EMOTICONS.put("🇮🇪", R.drawable.emoji_android_7_0_1f1ee_1f1ea);
        EMOTICONS.put("🇮🇱", R.drawable.emoji_android_7_0_1f1ee_1f1f1);
        EMOTICONS.put("🇮🇲", R.drawable.emoji_android_7_0_1f1ee_1f1f2);
        EMOTICONS.put("🇮🇳", R.drawable.emoji_android_7_0_1f1ee_1f1f3);
        EMOTICONS.put("🇮🇴", R.drawable.emoji_android_7_0_1f1ee_1f1f4);
        EMOTICONS.put("🇮🇶", R.drawable.emoji_android_7_0_1f1ee_1f1f6);
        EMOTICONS.put("🇮🇷", R.drawable.emoji_android_7_0_1f1ee_1f1f7);
        EMOTICONS.put("🇮🇸", R.drawable.emoji_android_7_0_1f1ee_1f1f8);
        EMOTICONS.put("🇮🇹", R.drawable.emoji_android_7_0_1f1ee_1f1f9);
        EMOTICONS.put("🇯🇪", R.drawable.emoji_android_7_0_1f1ef_1f1ea);
        EMOTICONS.put("🇯🇲", R.drawable.emoji_android_7_0_1f1ef_1f1f2);
        EMOTICONS.put("🇯🇴", R.drawable.emoji_android_7_0_1f1ef_1f1f4);
        EMOTICONS.put("🇯🇵", R.drawable.emoji_android_7_0_1f1ef_1f1f5);
        EMOTICONS.put("🇰🇪", R.drawable.emoji_android_7_0_1f1f0_1f1ea);
        EMOTICONS.put("🇰🇬", R.drawable.emoji_android_7_0_1f1f0_1f1ec);
        EMOTICONS.put("🇰🇭", R.drawable.emoji_android_7_0_1f1f0_1f1ed);
        EMOTICONS.put("🇰🇮", R.drawable.emoji_android_7_0_1f1f0_1f1ee);
        EMOTICONS.put("🇰🇲", R.drawable.emoji_android_7_0_1f1f0_1f1f2);
        EMOTICONS.put("🇰🇳", R.drawable.emoji_android_7_0_1f1f0_1f1f3);
        EMOTICONS.put("🇰🇵", R.drawable.emoji_android_7_0_1f1f0_1f1f5);
        EMOTICONS.put("🇰🇷", R.drawable.emoji_android_7_0_1f1f0_1f1f7);
        EMOTICONS.put("🇰🇼", R.drawable.emoji_android_7_0_1f1f0_1f1fc);
        EMOTICONS.put("🇰🇾", R.drawable.emoji_android_7_0_1f1f0_1f1fe);
        EMOTICONS.put("🇰🇿", R.drawable.emoji_android_7_0_1f1f0_1f1ff);
        EMOTICONS.put("🇱🇦", R.drawable.emoji_android_7_0_1f1f1_1f1e6);
        EMOTICONS.put("🇱🇧", R.drawable.emoji_android_7_0_1f1f1_1f1e7);
        EMOTICONS.put("🇱🇨", R.drawable.emoji_android_7_0_1f1f1_1f1e8);
        EMOTICONS.put("🇱🇮", R.drawable.emoji_android_7_0_1f1f1_1f1ee);
        EMOTICONS.put("🇱🇰", R.drawable.emoji_android_7_0_1f1f1_1f1f0);
        EMOTICONS.put("🇱🇷", R.drawable.emoji_android_7_0_1f1f1_1f1f7);
        EMOTICONS.put("🇱🇸", R.drawable.emoji_android_7_0_1f1f1_1f1f8);
        EMOTICONS.put("🇱🇹", R.drawable.emoji_android_7_0_1f1f1_1f1f9);
        EMOTICONS.put("🇱🇺", R.drawable.emoji_android_7_0_1f1f1_1f1fa);
        EMOTICONS.put("🇱🇻", R.drawable.emoji_android_7_0_1f1f1_1f1fb);
        EMOTICONS.put("🇱🇾", R.drawable.emoji_android_7_0_1f1f1_1f1fe);
        EMOTICONS.put("🇲🇦", R.drawable.emoji_android_7_0_1f1f2_1f1e6);
        EMOTICONS.put("🇲🇨", R.drawable.emoji_android_7_0_1f1f2_1f1e8);
        EMOTICONS.put("🇲🇩", R.drawable.emoji_android_7_0_1f1f2_1f1e9);
        EMOTICONS.put("🇲🇪", R.drawable.emoji_android_7_0_1f1f2_1f1ea);
        EMOTICONS.put("🇲🇬", R.drawable.emoji_android_7_0_1f1f2_1f1ec);
        EMOTICONS.put("🇲🇭", R.drawable.emoji_android_7_0_1f1f2_1f1ed);
        EMOTICONS.put("🇲🇰", R.drawable.emoji_android_7_0_1f1f2_1f1f0);
        EMOTICONS.put("🇲🇱", R.drawable.emoji_android_7_0_1f1f2_1f1f1);
        EMOTICONS.put("🇲🇲", R.drawable.emoji_android_7_0_1f1f2_1f1f2);
        EMOTICONS.put("🇲🇳", R.drawable.emoji_android_7_0_1f1f2_1f1f3);
        EMOTICONS.put("🇲🇴", R.drawable.emoji_android_7_0_1f1f2_1f1f4);
        EMOTICONS.put("🇲🇵", R.drawable.emoji_android_7_0_1f1f2_1f1f5);
        EMOTICONS.put("🇲🇷", R.drawable.emoji_android_7_0_1f1f2_1f1f7);
        EMOTICONS.put("🇲🇸", R.drawable.emoji_android_7_0_1f1f2_1f1f8);
        EMOTICONS.put("🇲🇹", R.drawable.emoji_android_7_0_1f1f2_1f1f9);
        EMOTICONS.put("🇲🇺", R.drawable.emoji_android_7_0_1f1f2_1f1fa);
        EMOTICONS.put("🇲🇻", R.drawable.emoji_android_7_0_1f1f2_1f1fb);
        EMOTICONS.put("🇲🇼", R.drawable.emoji_android_7_0_1f1f2_1f1fc);
        EMOTICONS.put("🇲🇽", R.drawable.emoji_android_7_0_1f1f2_1f1fd);
        EMOTICONS.put("🇲🇾", R.drawable.emoji_android_7_0_1f1f2_1f1fe);
        EMOTICONS.put("🇲🇿", R.drawable.emoji_android_7_0_1f1f2_1f1ff);
        EMOTICONS.put("🇳🇦", R.drawable.emoji_android_7_0_1f1f3_1f1e6);
        EMOTICONS.put("🇳🇪", R.drawable.emoji_android_7_0_1f1f3_1f1ea);
        EMOTICONS.put("🇳🇫", R.drawable.emoji_android_7_0_1f1f3_1f1eb);
        EMOTICONS.put("🇳🇬", R.drawable.emoji_android_7_0_1f1f3_1f1ec);
        EMOTICONS.put("🇳🇮", R.drawable.emoji_android_7_0_1f1f3_1f1ee);
        EMOTICONS.put("🇳🇱", R.drawable.emoji_android_7_0_1f1f3_1f1f1);
        EMOTICONS.put("🇳🇴", R.drawable.emoji_android_7_0_1f1f3_1f1f4);
        EMOTICONS.put("🇳🇵", R.drawable.emoji_android_7_0_1f1f3_1f1f5);
        EMOTICONS.put("🇳🇷", R.drawable.emoji_android_7_0_1f1f3_1f1f7);
        EMOTICONS.put("🇳🇺", R.drawable.emoji_android_7_0_1f1f3_1f1fa);
        EMOTICONS.put("🇳🇿", R.drawable.emoji_android_7_0_1f1f3_1f1ff);
        EMOTICONS.put("🇴🇲", R.drawable.emoji_android_7_0_1f1f4_1f1f2);
        EMOTICONS.put("🇵🇦", R.drawable.emoji_android_7_0_1f1f5_1f1e6);
        EMOTICONS.put("🇵🇪", R.drawable.emoji_android_7_0_1f1f5_1f1ea);
        EMOTICONS.put("🇵🇫", R.drawable.emoji_android_7_0_1f1f5_1f1eb);
        EMOTICONS.put("🇵🇬", R.drawable.emoji_android_7_0_1f1f5_1f1ec);
        EMOTICONS.put("🇵🇭", R.drawable.emoji_android_7_0_1f1f5_1f1ed);
        EMOTICONS.put("🇵🇰", R.drawable.emoji_android_7_0_1f1f5_1f1f0);
        EMOTICONS.put("🇵🇱", R.drawable.emoji_android_7_0_1f1f5_1f1f1);
        EMOTICONS.put("🇵🇳", R.drawable.emoji_android_7_0_1f1f5_1f1f3);
        EMOTICONS.put("🇵🇷", R.drawable.emoji_android_7_0_1f1f5_1f1f7);
        EMOTICONS.put("🇵🇸", R.drawable.emoji_android_7_0_1f1f5_1f1f8);
        EMOTICONS.put("🇵🇹", R.drawable.emoji_android_7_0_1f1f5_1f1f9);
        EMOTICONS.put("🇵🇼", R.drawable.emoji_android_7_0_1f1f5_1f1fc);
        EMOTICONS.put("🇵🇾", R.drawable.emoji_android_7_0_1f1f5_1f1fe);
        EMOTICONS.put("🇶🇦", R.drawable.emoji_android_7_0_1f1f6_1f1e6);
        EMOTICONS.put("🇷🇴", R.drawable.emoji_android_7_0_1f1f7_1f1f4);
        EMOTICONS.put("🇷🇸", R.drawable.emoji_android_7_0_1f1f7_1f1f8);
        EMOTICONS.put("🇷🇺", R.drawable.emoji_android_7_0_1f1f7_1f1fa);
        EMOTICONS.put("🇷🇼", R.drawable.emoji_android_7_0_1f1f7_1f1fc);
        EMOTICONS.put("🇸🇦", R.drawable.emoji_android_7_0_1f1f8_1f1e6);
        EMOTICONS.put("🇸🇧", R.drawable.emoji_android_7_0_1f1f8_1f1e7);
        EMOTICONS.put("🇸🇨", R.drawable.emoji_android_7_0_1f1f8_1f1e8);
        EMOTICONS.put("🇸🇩", R.drawable.emoji_android_7_0_1f1f8_1f1e9);
        EMOTICONS.put("🇸🇪", R.drawable.emoji_android_7_0_1f1f8_1f1ea);
        EMOTICONS.put("🇸🇬", R.drawable.emoji_android_7_0_1f1f8_1f1ec);
        EMOTICONS.put("🇸🇭", R.drawable.emoji_android_7_0_1f1f8_1f1ed);
        EMOTICONS.put("🇸🇮", R.drawable.emoji_android_7_0_1f1f8_1f1ee);
        EMOTICONS.put("🇸🇯", R.drawable.emoji_android_7_0_1f1f8_1f1ef);
        EMOTICONS.put("🇸🇰", R.drawable.emoji_android_7_0_1f1f8_1f1f0);
        EMOTICONS.put("🇸🇱", R.drawable.emoji_android_7_0_1f1f8_1f1f1);
        EMOTICONS.put("🇸🇲", R.drawable.emoji_android_7_0_1f1f8_1f1f2);
        EMOTICONS.put("🇸🇳", R.drawable.emoji_android_7_0_1f1f8_1f1f3);
        EMOTICONS.put("🇸🇴", R.drawable.emoji_android_7_0_1f1f8_1f1f4);
        EMOTICONS.put("🇸🇷", R.drawable.emoji_android_7_0_1f1f8_1f1f7);
        EMOTICONS.put("🇸🇸", R.drawable.emoji_android_7_0_1f1f8_1f1f8);
        EMOTICONS.put("🇸🇹", R.drawable.emoji_android_7_0_1f1f8_1f1f9);
        EMOTICONS.put("🇸🇻", R.drawable.emoji_android_7_0_1f1f8_1f1fb);
        EMOTICONS.put("🇸🇽", R.drawable.emoji_android_7_0_1f1f8_1f1fd);
        EMOTICONS.put("🇸🇾", R.drawable.emoji_android_7_0_1f1f8_1f1fe);
        EMOTICONS.put("🇸🇿", R.drawable.emoji_android_7_0_1f1f8_1f1ff);
        EMOTICONS.put("🇹🇦", R.drawable.emoji_android_7_0_1f1f9_1f1e6);
        EMOTICONS.put("🇹🇨", R.drawable.emoji_android_7_0_1f1f9_1f1e8);
        EMOTICONS.put("🇹🇩", R.drawable.emoji_android_7_0_1f1f9_1f1e9);
        EMOTICONS.put("🇹🇬", R.drawable.emoji_android_7_0_1f1f9_1f1ec);
        EMOTICONS.put("🇹🇭", R.drawable.emoji_android_7_0_1f1f9_1f1ed);
        EMOTICONS.put("🇹🇯", R.drawable.emoji_android_7_0_1f1f9_1f1ef);
        EMOTICONS.put("🇹🇰", R.drawable.emoji_android_7_0_1f1f9_1f1f0);
        EMOTICONS.put("🇹🇱", R.drawable.emoji_android_7_0_1f1f9_1f1f1);
        EMOTICONS.put("🇹🇲", R.drawable.emoji_android_7_0_1f1f9_1f1f2);
        EMOTICONS.put("🇹🇳", R.drawable.emoji_android_7_0_1f1f9_1f1f3);
        EMOTICONS.put("🇹🇴", R.drawable.emoji_android_7_0_1f1f9_1f1f4);
        EMOTICONS.put("🇹🇷", R.drawable.emoji_android_7_0_1f1f9_1f1f7);
        EMOTICONS.put("🇹🇹", R.drawable.emoji_android_7_0_1f1f9_1f1f9);
        EMOTICONS.put("🇹🇻", R.drawable.emoji_android_7_0_1f1f9_1f1fb);
        EMOTICONS.put("🇹🇼", R.drawable.emoji_android_7_0_1f1f9_1f1fc);
        EMOTICONS.put("🇹🇿", R.drawable.emoji_android_7_0_1f1f9_1f1ff);
        EMOTICONS.put("🇺🇦", R.drawable.emoji_android_7_0_1f1fa_1f1e6);
        EMOTICONS.put("🇺🇬", R.drawable.emoji_android_7_0_1f1fa_1f1ec);
        EMOTICONS.put("🇺🇲", R.drawable.emoji_android_7_0_1f1fa_1f1f2);
        EMOTICONS.put("🇺🇸", R.drawable.emoji_android_7_0_1f1fa_1f1f8);
        EMOTICONS.put("🇺🇾", R.drawable.emoji_android_7_0_1f1fa_1f1fe);
        EMOTICONS.put("🇺🇿", R.drawable.emoji_android_7_0_1f1fa_1f1ff);
        EMOTICONS.put("🇻🇦", R.drawable.emoji_android_7_0_1f1fb_1f1e6);
        EMOTICONS.put("🇻🇨", R.drawable.emoji_android_7_0_1f1fb_1f1e8);
        EMOTICONS.put("🇻🇪", R.drawable.emoji_android_7_0_1f1fb_1f1ea);
        EMOTICONS.put("🇻🇬", R.drawable.emoji_android_7_0_1f1fb_1f1ec);
        EMOTICONS.put("🇻🇮", R.drawable.emoji_android_7_0_1f1fb_1f1ee);
        EMOTICONS.put("🇻🇳", R.drawable.emoji_android_7_0_1f1fb_1f1f3);
        EMOTICONS.put("🇻🇺", R.drawable.emoji_android_7_0_1f1fb_1f1fa);
        EMOTICONS.put("🇼🇸", R.drawable.emoji_android_7_0_1f1fc_1f1f8);
        EMOTICONS.put("🇾🇪", R.drawable.emoji_android_7_0_1f1fe_1f1ea);
        EMOTICONS.put("🇿🇦", R.drawable.emoji_android_7_0_1f1ff_1f1e6);
        EMOTICONS.put("🇿🇲", R.drawable.emoji_android_7_0_1f1ff_1f1f2);
        EMOTICONS.put("🇿🇼", R.drawable.emoji_android_7_0_1f1ff_1f1fc);
	}
}