/*
 * Decompiled with CFR 0.152.
 */
package com.kelveden.karma;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class KarmaUtils {
    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static List<String> valueToKarmaArgument(Boolean value, String trueSwitch, String falseSwitch) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(value != false ? trueSwitch : falseSwitch);
    }

    public static List<String> valueToKarmaArgument(Integer value, String argName) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(argName, String.valueOf(value));
    }

    public static List<String> valueToKarmaArgument(Boolean value, String argName) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(argName, value.toString());
    }

    public static List<String> valueToKarmaArgument(String value, String argName) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(argName, value);
    }

    public static ProcessBuilder getKarmaProcessBuilder(String karmaExecutable, String configFileWithPath) {
        String osAgnosticPathToExe = karmaExecutable;
        if (!karmaExecutable.equals("karma")) {
            osAgnosticPathToExe = KarmaUtils.replacePathSeparatorsWithOSAgnosticSeparator(karmaExecutable);
        }
        if (KarmaUtils.isWindows()) {
            return new ProcessBuilder("cmd", "/C", osAgnosticPathToExe, "start", configFileWithPath);
        }
        return new ProcessBuilder(osAgnosticPathToExe, "start", configFileWithPath);
    }

    private static String replacePathSeparatorsWithOSAgnosticSeparator(String karmaExecutablePath) {
        String deUnixedPath = karmaExecutablePath.replace("/", File.separator);
        String deWindowsedAndDeUnixedpath = deUnixedPath.replace("\\", File.separator);
        return deWindowsedAndDeUnixedpath;
    }
}

