/*
 * Decompiled with CFR 0.152.
 */
package com.kelveden.karma;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="start", defaultPhase=LifecyclePhase.TEST)
public class StartMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}/karma.conf.js", property="configFile", required=true)
    private File configFile;
    @Parameter(property="browsers", required=false)
    private String browsers;
    @Parameter(property="autoWatch", required=false)
    private Boolean autoWatch;
    @Parameter(property="reporters", required=false)
    private String reporters;
    @Parameter(property="captureTimeout", required=false)
    private Integer captureTimeout;
    @Parameter(property="singleRun", required=false, defaultValue="true")
    private Boolean singleRun;
    @Parameter(property="reportSlowerThan", required=false)
    private Integer reportSlowerThan;
    @Parameter(property="skipKarma", required=false, defaultValue="false")
    private Boolean skipKarma;
    @Parameter(property="karmaFailureIgnore", required=false, defaultValue="false")
    private Boolean karmaFailureIgnore;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipKarma.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        Process karma = this.createKarmaProcess();
        if (!this.executeKarma(karma) && this.singleRun.booleanValue()) {
            if (this.karmaFailureIgnore.booleanValue()) {
                this.getLog().warn((CharSequence)"There were Karma test failures.");
            } else {
                throw new MojoFailureException("There were Karma test failures.");
            }
        }
        System.out.flush();
    }

    private boolean executeKarma(Process karma) throws MojoExecutionException {
        BufferedReader karmaOutputReader = null;
        try {
            karmaOutputReader = this.createKarmaOutputReader(karma);
            String line22 = karmaOutputReader.readLine();
            while (line22 != null) {
                System.out.println(line22);
                line22 = karmaOutputReader.readLine();
            }
            boolean line22 = karma.waitFor() == 0;
            return line22;
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was an error reading the output from Karma.", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("The Karma process was interrupted.", (Exception)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)karmaOutputReader);
        }
    }

    private Process createKarmaProcess() throws MojoExecutionException {
        ProcessBuilder builder = this.isWindows() ? new ProcessBuilder("cmd", "/C", "karma", "start", this.configFile.getAbsolutePath()) : new ProcessBuilder("karma", "start", this.configFile.getAbsolutePath());
        List<String> command = builder.command();
        command.addAll(this.valueToKarmaArgument(this.browsers, "--browsers"));
        command.addAll(this.valueToKarmaArgument(this.reporters, "--reporters"));
        command.addAll(this.valueToKarmaArgument(this.singleRun, "--single-run", "--no-single-run"));
        command.addAll(this.valueToKarmaArgument(this.autoWatch, "--auto-watch", "--no-auto-watch"));
        command.addAll(this.valueToKarmaArgument(this.captureTimeout, "--capture-timeout"));
        command.addAll(this.valueToKarmaArgument(this.reportSlowerThan, "--report-slower-than"));
        builder.redirectErrorStream(true);
        try {
            System.out.println(StringUtils.join(command.iterator(), (String)" "));
            return builder.start();
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was an error executing Karma.", (Exception)e);
        }
    }

    private List<String> valueToKarmaArgument(Boolean value, String trueSwitch, String falseSwitch) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value.booleanValue()) {
            return Arrays.asList(trueSwitch);
        }
        return Arrays.asList(falseSwitch);
    }

    private List<String> valueToKarmaArgument(Integer value, String argName) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(argName, String.valueOf(value));
    }

    private List<String> valueToKarmaArgument(String value, String argName) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(argName, value);
    }

    private BufferedReader createKarmaOutputReader(Process p) {
        return new BufferedReader(new InputStreamReader(p.getInputStream()));
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }
}

