/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.translucentbar.library;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.TypedValue;

public class SystemConfig {
    private static final String STATUS_BAR_HEIGHT_RES_NAME = "status_bar_height";
    private static final String NAV_BAR_HEIGHT_RES_NAME = "navigation_bar_height";
    private static final String NAV_BAR_HEIGHT_LANDSCAPE_RES_NAME = "navigation_bar_height_landscape";
    private static final String NAV_BAR_WIDTH_RES_NAME = "navigation_bar_width";
    private static final String SHOW_NAV_BAR_RES_NAME = "config_showNavigationBar";
    private final boolean mTranslucentStatusBar;
    private final int mStatusBarHeight;
    private final int mActionBarHeight;

    SystemConfig(Activity activity, boolean translucentStatusBar) {
        Resources res = activity.getResources();
        this.mStatusBarHeight = this.getInternalDimensionSize(res, STATUS_BAR_HEIGHT_RES_NAME);
        this.mActionBarHeight = this.getActionBarHeight((Context)activity);
        this.mTranslucentStatusBar = translucentStatusBar;
    }

    @TargetApi(value=14)
    private int getActionBarHeight(Context context) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14) {
            TypedValue tv = new TypedValue();
            context.getTheme().resolveAttribute(16843499, tv, true);
            result = context.getResources().getDimensionPixelSize(tv.resourceId);
        }
        return result;
    }

    private int getInternalDimensionSize(Resources res, String key) {
        int result = 0;
        int resourceId = res.getIdentifier(key, "dimen", "android");
        if (resourceId > 0) {
            result = res.getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public int getStatusBarHeight() {
        return this.mStatusBarHeight;
    }

    public int getActionBarHeight() {
        return this.mActionBarHeight;
    }

    public int getPixelInsetTop(boolean withActionBar) {
        return (this.mTranslucentStatusBar ? this.mStatusBarHeight : 0) + (withActionBar ? this.mActionBarHeight : 0);
    }
}

