/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.translucentbar.library;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.v4.app.Fragment;
import android.support.v7.widget.Toolbar;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.kelin.translucentbar.library.SystemConfig;

public class TranslucentBarManager {
    private static final String TAG_STATUS_BAR_VIEW = "status_bar_view";
    private Toolbar mToolbar;
    private ViewGroup mRoot;
    private CollapsingToolbarLayout mCollapsingToolbarLayout;
    private boolean mTranslucentStatusBar;
    private boolean mIsNeedOverStatusBar = false;
    private View mStatusBarView;
    private SystemConfig mSystemConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslucentBarManager(Activity activity) {
        Window win = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 19) {
            int[] attrs = new int[]{16843759, 16843760};
            TypedArray a = activity.obtainStyledAttributes(attrs);
            try {
                this.mTranslucentStatusBar = a.getBoolean(0, false);
            }
            finally {
                a.recycle();
            }
            WindowManager.LayoutParams winParams = win.getAttributes();
            int bits = 0x4000000;
            if ((winParams.flags & bits) != 0) {
                this.mTranslucentStatusBar = true;
            }
        }
        this.mSystemConfig = new SystemConfig(activity, this.mTranslucentStatusBar);
        this.mRoot = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        this.findToolbar((View)this.mRoot);
        this.findCollapsingToolbarLayout((View)this.mRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslucentBarManager(Fragment fragment) {
        Window win = fragment.getActivity().getWindow();
        if (Build.VERSION.SDK_INT >= 19) {
            int[] attrs = new int[]{16843759, 16843760};
            TypedArray a = fragment.getActivity().obtainStyledAttributes(attrs);
            try {
                this.mTranslucentStatusBar = a.getBoolean(0, false);
            }
            finally {
                a.recycle();
            }
            WindowManager.LayoutParams winParams = win.getAttributes();
            int bits = 0x4000000;
            if ((winParams.flags & bits) != 0) {
                this.mTranslucentStatusBar = true;
            }
        }
        this.mSystemConfig = new SystemConfig((Activity)fragment.getActivity(), this.mTranslucentStatusBar);
        ViewGroup decorViewGroup = (ViewGroup)fragment.getActivity().getWindow().getDecorView().findViewById(0x1020002);
        for (int i = 0; i < decorViewGroup.getChildCount(); ++i) {
            Object tag = decorViewGroup.getChildAt(i).getTag();
            if (tag == null || !(tag instanceof String) || !tag.toString().equals(TAG_STATUS_BAR_VIEW)) continue;
            decorViewGroup.removeViewAt(i);
            break;
        }
    }

    private void tintColor(Activity activity, @ColorRes int color) {
        if (!this.mIsNeedOverStatusBar) {
            ViewGroup contentLayout = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
            this.setupStatusBarView((Context)activity, contentLayout);
            this.mStatusBarView.setBackgroundResource(color);
            this.mStatusBarView.setVisibility(0);
            this.mToolbar.setBackgroundResource(color);
        } else {
            this.mCollapsingToolbarLayout.setContentScrimResource(color);
            this.mCollapsingToolbarLayout.setStatusBarScrimResource(color);
        }
    }

    public void translucent(Fragment fragment, View root, @ColorRes int color) {
        this.mRoot = (ViewGroup)root;
        this.findToolbar((View)this.mRoot);
        this.findCollapsingToolbarLayout((View)this.mRoot);
        this.translucent((Activity)fragment.getActivity(), color);
        this.addStatusBarShade((Activity)fragment.getActivity());
    }

    public void translucent(Activity activity, @ColorRes int color) {
        if (!this.mTranslucentStatusBar || this.mToolbar == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            this.setFitsSystemWindows((View)this.mRoot, false);
            this.mToolbar.getLayoutParams().height = this.mSystemConfig.getActionBarHeight() + this.mSystemConfig.getStatusBarHeight();
            this.mToolbar.setPadding(this.mToolbar.getPaddingLeft(), this.mSystemConfig.getStatusBarHeight(), this.mToolbar.getPaddingRight(), this.mToolbar.getPaddingBottom());
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setFitsSystemWindows((View)this.mRoot, true);
        }
        if (color <= 0) {
            TypedValue tv = new TypedValue();
            activity.getTheme().resolveAttribute(16843827, tv, true);
            this.tintColor(activity, tv.resourceId);
        } else {
            this.tintColor(activity, color);
        }
    }

    public void translucent(Activity activity) {
        this.translucent(activity, -1);
    }

    public void transparent(Activity activity, @ColorRes int color) {
        this.translucent(activity, color);
        this.removeStatusBarShade(activity);
    }

    public void transparent(Activity activity) {
        this.translucent(activity, -1);
        this.removeStatusBarShade(activity);
    }

    public void transparent(Fragment fragment, View root, @ColorRes int color) {
        this.mRoot = (ViewGroup)root;
        this.findToolbar((View)this.mRoot);
        this.findCollapsingToolbarLayout((View)this.mRoot);
        this.translucent((Activity)fragment.getActivity(), color);
        this.removeStatusBarShade((Activity)fragment.getActivity());
    }

    private void removeStatusBarShade(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(0);
            window.getDecorView().setSystemUiVisibility(1280);
        }
    }

    private void addStatusBarShade(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(Integer.MIN_VALUE);
            window.addFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
        }
    }

    private void setupStatusBarView(Context context, ViewGroup contentFrameLayout) {
        this.mStatusBarView = new View(context);
        this.mStatusBarView.setTag((Object)TAG_STATUS_BAR_VIEW);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, this.mSystemConfig.getStatusBarHeight());
        params.gravity = 48;
        this.mStatusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mStatusBarView.setVisibility(8);
        contentFrameLayout.addView(this.mStatusBarView);
    }

    private void setFitsSystemWindows(View view, boolean b) {
        ViewGroup viewGroup;
        view.setFitsSystemWindows(b);
        if (view instanceof ViewGroup && (viewGroup = (ViewGroup)view).getChildCount() > 0) {
            View child = viewGroup.getChildAt(0);
            if (viewGroup instanceof CollapsingToolbarLayout) {
                child.setFitsSystemWindows(b);
                return;
            }
            if (!this.mIsNeedOverStatusBar && (child instanceof AppBarLayout || child instanceof Toolbar)) {
                return;
            }
            this.setFitsSystemWindows(child, b);
        }
    }

    private void findToolbar(View view) {
        if (this.mToolbar != null) {
            return;
        }
        if (view instanceof Toolbar) {
            this.mToolbar = (Toolbar)view;
            return;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                this.findToolbar(child);
            }
        }
    }

    private void findCollapsingToolbarLayout(View view) {
        ViewGroup viewGroup;
        if (view instanceof ViewGroup && (viewGroup = (ViewGroup)view).getChildCount() > 0) {
            View child = viewGroup.getChildAt(0);
            if (child instanceof CollapsingToolbarLayout && viewGroup instanceof AppBarLayout && !(((CollapsingToolbarLayout)child).getChildAt(0) instanceof Toolbar)) {
                this.mCollapsingToolbarLayout = (CollapsingToolbarLayout)child;
                this.mIsNeedOverStatusBar = true;
            }
            this.findCollapsingToolbarLayout(child);
        }
    }
}

