/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.scrollablepanel.library;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.kelin.scrollablepanel.library.PanelAdapter;
import com.kelin.scrollablepanel.library.R;
import java.util.HashSet;

public class ScrollablePanel
extends FrameLayout {
    protected RecyclerView recyclerView;
    protected RecyclerView headerRecyclerView;
    protected PanelLineAdapter panelLineAdapter;
    protected PanelAdapter panelAdapter;
    protected FrameLayout firstItemView;

    public ScrollablePanel(Context context, PanelAdapter panelAdapter) {
        super(context);
        this.panelAdapter = panelAdapter;
        this.initView();
    }

    public ScrollablePanel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ScrollablePanel(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_scrollable_panel, (ViewGroup)this, true);
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recycler_content_list);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
        this.firstItemView = (FrameLayout)this.findViewById(R.id.first_item);
        this.headerRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_header_list);
        this.headerRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        if (this.panelAdapter != null) {
            this.panelLineAdapter = new PanelLineAdapter(this.panelAdapter, this.headerRecyclerView);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.panelLineAdapter);
            this.setUpFirstItemView(this.panelAdapter);
        }
    }

    private void setUpFirstItemView(PanelAdapter panelAdapter) {
        RecyclerView.ViewHolder viewHolder = panelAdapter.onCreateViewHolder((ViewGroup)this.firstItemView, panelAdapter.getItemViewType(0, 0));
        panelAdapter.onBindViewHolder(viewHolder, 0, 0);
        this.firstItemView.addView(viewHolder.itemView);
    }

    public void setPanelAdapter(PanelAdapter panelAdapter) {
        if (this.panelLineAdapter != null) {
            this.panelLineAdapter.setPanelAdapter(panelAdapter);
            this.panelLineAdapter.notifyDataSetChanged();
        } else {
            this.panelLineAdapter = new PanelLineAdapter(panelAdapter, this.headerRecyclerView);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.panelLineAdapter);
        }
        this.panelAdapter = panelAdapter;
        this.setUpFirstItemView(panelAdapter);
    }

    private static class PanelLineAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private PanelAdapter panelAdapter;
        private RecyclerView headerRecyclerView;
        private HashSet<RecyclerView> observerList = new HashSet();

        public PanelLineAdapter(PanelAdapter panelAdapter, RecyclerView headerRecyclerView) {
            this.panelAdapter = panelAdapter;
            this.headerRecyclerView = headerRecyclerView;
            this.initRecyclerView(headerRecyclerView);
            this.setUpHeaderRecyclerView();
        }

        public void setPanelAdapter(PanelAdapter panelAdapter) {
            this.panelAdapter = panelAdapter;
            this.setUpHeaderRecyclerView();
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemCount() {
            return this.panelAdapter.getRowCount() - 1;
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            ViewHolder viewHolder = new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.listitem_content_row, parent, false));
            this.initRecyclerView(viewHolder.recyclerView);
            return viewHolder;
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            PanelLineItemAdapter lineItemAdapter = (PanelLineItemAdapter)holder.recyclerView.getAdapter();
            if (lineItemAdapter == null) {
                lineItemAdapter = new PanelLineItemAdapter(position + 1, this.panelAdapter);
                holder.recyclerView.setAdapter((RecyclerView.Adapter)lineItemAdapter);
            } else {
                lineItemAdapter.setRow(position + 1);
                lineItemAdapter.notifyDataSetChanged();
            }
            if (holder.firstColumnItemVH == null) {
                RecyclerView.ViewHolder viewHolder;
                holder.firstColumnItemVH = viewHolder = this.panelAdapter.onCreateViewHolder((ViewGroup)holder.firstColumnItemView, this.panelAdapter.getItemViewType(position + 1, 0));
                this.panelAdapter.onBindViewHolder(holder.firstColumnItemVH, position + 1, 0);
                holder.firstColumnItemView.addView(viewHolder.itemView);
            } else {
                this.panelAdapter.onBindViewHolder(holder.firstColumnItemVH, position + 1, 0);
            }
        }

        private void setUpHeaderRecyclerView() {
            if (this.panelAdapter != null) {
                PanelLineItemAdapter lineItemAdapter = new PanelLineItemAdapter(0, this.panelAdapter);
                this.headerRecyclerView.setAdapter((RecyclerView.Adapter)lineItemAdapter);
            }
        }

        public void initRecyclerView(RecyclerView recyclerView) {
            this.observerList.add(recyclerView);
            recyclerView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    switch (motionEvent.getAction()) {
                        case 0: 
                        case 5: {
                            for (RecyclerView rv : PanelLineAdapter.this.observerList) {
                                rv.stopScroll();
                            }
                            break;
                        }
                    }
                    return false;
                }
            });
            recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    LinearLayoutManager linearLayoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                    int firstPos = linearLayoutManager.findFirstVisibleItemPosition();
                    View firstVisibleItem = linearLayoutManager.getChildAt(0);
                    if (firstVisibleItem != null) {
                        int firstRight = linearLayoutManager.getDecoratedRight(firstVisibleItem);
                        for (RecyclerView rv : PanelLineAdapter.this.observerList) {
                            LinearLayoutManager layoutManager;
                            if (recyclerView == rv || (layoutManager = (LinearLayoutManager)rv.getLayoutManager()) == null) continue;
                            layoutManager.scrollToPositionWithOffset(firstPos + 1, firstRight);
                        }
                    }
                }

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                    super.onScrollStateChanged(recyclerView, newState);
                }
            });
        }

        static class ViewHolder
        extends RecyclerView.ViewHolder {
            public RecyclerView recyclerView;
            public FrameLayout firstColumnItemView;
            public RecyclerView.ViewHolder firstColumnItemVH;

            public ViewHolder(View view) {
                super(view);
                this.recyclerView = (RecyclerView)view.findViewById(R.id.recycler_line_list);
                this.firstColumnItemView = (FrameLayout)view.findViewById(R.id.first_column_item);
                this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext(), 0, false));
            }
        }
    }

    private static class PanelLineItemAdapter
    extends RecyclerView.Adapter {
        private PanelAdapter panelAdapter;
        private int row;

        public PanelLineItemAdapter(int row, PanelAdapter panelAdapter) {
            this.row = row;
            this.panelAdapter = panelAdapter;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return this.panelAdapter.onCreateViewHolder(parent, viewType);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            this.panelAdapter.onBindViewHolder(holder, this.row, position + 1);
        }

        public int getItemViewType(int position) {
            return this.panelAdapter.getItemViewType(this.row, position + 1);
        }

        public int getItemCount() {
            return this.panelAdapter.getColumnCount() - 1;
        }

        public void setRow(int row) {
            this.row = row;
        }
    }
}

