/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.calendarlistview.library;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.kelin.calendarlistview.library.PinnedSectionedHeaderAdapter;

public abstract class SectionedBaseAdapter
extends BaseAdapter
implements PinnedSectionedHeaderAdapter {
    private final SparseArray<Integer> mSectionPositionCache;
    private final SparseArray<Integer> mSectionCache = new SparseArray();
    private final SparseArray<Integer> mSectionCountCache;
    private int mCount = -1;
    private int mSectionCount = -1;

    public SectionedBaseAdapter() {
        this.mSectionPositionCache = new SparseArray();
        this.mSectionCountCache = new SparseArray();
    }

    public void notifyDataSetChanged() {
        this.mSectionCache.clear();
        this.mSectionPositionCache.clear();
        this.mSectionCountCache.clear();
        this.mCount = -1;
        this.mSectionCount = -1;
        super.notifyDataSetChanged();
    }

    public void notifyDataSetInvalidated() {
        this.mSectionCache.clear();
        this.mSectionPositionCache.clear();
        this.mSectionCountCache.clear();
        this.mCount = -1;
        this.mSectionCount = -1;
        super.notifyDataSetInvalidated();
    }

    @Override
    public final int getCount() {
        if (this.mCount >= 0) {
            return this.mCount;
        }
        int count = 0;
        for (int i = 0; i < this.internalGetSectionCount(); ++i) {
            count += this.internalGetCountForSection(i);
            ++count;
        }
        this.mCount = count;
        return count;
    }

    public final Object getItem(int position) {
        return this.getItem(this.getSectionForPosition(position), this.getPositionInSectionForPosition(position));
    }

    public final long getItemId(int position) {
        return this.getItemId(this.getSectionForPosition(position), this.getPositionInSectionForPosition(position));
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        if (this.isSectionHeader(position)) {
            return this.getSectionHeaderView(this.getSectionForPosition(position), convertView, parent);
        }
        return this.getItemView(this.getSectionForPosition(position), this.getPositionInSectionForPosition(position), convertView, parent);
    }

    public final int getItemViewType(int position) {
        if (this.isSectionHeader(position)) {
            return this.getItemViewTypeCount() + this.getSectionHeaderViewType(this.getSectionForPosition(position));
        }
        return this.getItemViewType(this.getSectionForPosition(position), this.getPositionInSectionForPosition(position));
    }

    public final int getViewTypeCount() {
        return this.getItemViewTypeCount() + this.getSectionHeaderViewTypeCount();
    }

    @Override
    public final int getSectionForPosition(int position) {
        Integer cachedSection = (Integer)this.mSectionCache.get(position);
        if (cachedSection != null) {
            return cachedSection;
        }
        int sectionStart = 0;
        for (int i = 0; i < this.internalGetSectionCount(); ++i) {
            int sectionCount = this.internalGetCountForSection(i);
            int sectionEnd = sectionStart + sectionCount + 1;
            if (position >= sectionStart && position < sectionEnd) {
                this.mSectionCache.put(position, (Object)i);
                return i;
            }
            sectionStart = sectionEnd;
        }
        return 0;
    }

    public int getPositionInSectionForPosition(int position) {
        Integer cachedPosition = (Integer)this.mSectionPositionCache.get(position);
        if (cachedPosition != null) {
            return cachedPosition;
        }
        int sectionStart = 0;
        for (int i = 0; i < this.internalGetSectionCount(); ++i) {
            int sectionCount = this.internalGetCountForSection(i);
            int sectionEnd = sectionStart + sectionCount + 1;
            if (position >= sectionStart && position < sectionEnd) {
                int positionInSection = position - sectionStart - 1;
                this.mSectionPositionCache.put(position, (Object)positionInSection);
                return positionInSection;
            }
            sectionStart = sectionEnd;
        }
        return 0;
    }

    @Override
    public final boolean isSectionHeader(int position) {
        int sectionStart = 0;
        for (int i = 0; i < this.internalGetSectionCount(); ++i) {
            if (position == sectionStart) {
                return true;
            }
            if (position < sectionStart) {
                return false;
            }
            sectionStart += this.internalGetCountForSection(i) + 1;
        }
        return false;
    }

    public int getItemViewType(int section, int position) {
        return 0;
    }

    public int getItemViewTypeCount() {
        return 1;
    }

    @Override
    public int getSectionHeaderViewType(int section) {
        return 0;
    }

    public int getSectionHeaderViewTypeCount() {
        return 1;
    }

    public abstract Object getItem(int var1, int var2);

    public abstract long getItemId(int var1, int var2);

    public abstract int getSectionCount();

    public abstract int getCountForSection(int var1);

    public abstract View getItemView(int var1, int var2, View var3, ViewGroup var4);

    @Override
    public abstract View getSectionHeaderView(int var1, View var2, ViewGroup var3);

    private int internalGetCountForSection(int section) {
        Integer cachedSectionCount = (Integer)this.mSectionCountCache.get(section);
        if (cachedSectionCount != null) {
            return cachedSectionCount;
        }
        int sectionCount = this.getCountForSection(section);
        this.mSectionCountCache.put(section, (Object)sectionCount);
        return sectionCount;
    }

    private int internalGetSectionCount() {
        if (this.mSectionCount >= 0) {
            return this.mSectionCount;
        }
        this.mSectionCount = this.getSectionCount();
        return this.mSectionCount;
    }
}

