/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.calendarlistview.library;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.HeaderViewListAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.kelin.calendarlistview.library.LoadingFooter;
import com.kelin.calendarlistview.library.PinnedSectionedHeaderAdapter;
import com.kelin.calendarlistview.library.R;
import com.kelin.calendarlistview.library.SectionedBaseAdapter;
import java.util.ArrayList;
import java.util.List;

public class PinnedHeaderListView
extends ListView
implements AbsListView.OnScrollListener {
    private int mTriggerRefreshHeight;
    private boolean mTracking = false;
    private float mStartY = 0.0f;
    private int mCurOffsetY = 0;
    private boolean mIsRefreshing = false;
    private Animation mAnimRotate;
    private Animation mAnimRotateBack;
    private boolean mCanRefresh = false;
    private PullDownStateListener mRefreshListener;
    private PullUpStateListener mPullUpListener;
    private View mPullHeader = null;
    private View mFirstHeader;
    private View mContainer = null;
    private ImageView mBackgroundImageView = null;
    private int mMaxHeaderHeight = Integer.MAX_VALUE;
    private boolean mPullDownEnabled = true;
    private boolean mCanPullDown = true;
    private boolean mAnimating;
    private String mPullString;
    private String mRefreshingString;
    private String mReleaseString;
    private TextView mMajorText;
    private TextView mMinorText;
    private ImageView mIndicator;
    private ViewGroup.LayoutParams mContainerLayoutParams;
    protected LoadingFooter mLoadingFooter;
    protected LoadingFooter mLoadingHeader;
    private List<AbsListView.OnScrollListener> mOnScrollListeners = new ArrayList<AbsListView.OnScrollListener>();
    private PinnedSectionedHeaderAdapter mAdapter;
    private View mCurrentHeader;
    private int mCurrentHeaderViewType = 0;
    private float mHeaderOffset;
    private boolean mShouldPin = true;
    private int mCurrentSection = 0;
    protected boolean smoothScrolling = false;
    private OnSectionChangedListener onSectionChangedListener;
    private Rect mRect = new Rect();

    public PinnedHeaderListView(Context context) {
        super(context);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public PinnedHeaderListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public PinnedHeaderListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    public void setPinHeaders(boolean shouldPin) {
        this.mShouldPin = shouldPin;
    }

    public void setAdapter(ListAdapter adapter) {
        this.mAdapter = (PinnedSectionedHeaderAdapter)adapter;
        super.setAdapter(adapter);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int section;
        this.pullToRefreshListViewOnScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        if (this.mOnScrollListeners != null && this.mOnScrollListeners.size() > 0) {
            for (AbsListView.OnScrollListener listener : this.mOnScrollListeners) {
                listener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0 || !this.mShouldPin || firstVisibleItem < this.getHeaderViewsCount()) {
            this.mCurrentHeader = null;
            this.mHeaderOffset = 0.0f;
            for (int i = firstVisibleItem; i < firstVisibleItem + visibleItemCount; ++i) {
                View header = this.getChildAt(i);
                if (header == null) continue;
                header.setVisibility(0);
            }
            return;
        }
        int viewType = this.mAdapter.getSectionHeaderViewType(section = this.mAdapter.getSectionForPosition(firstVisibleItem -= this.getHeaderViewsCount()));
        this.mCurrentHeader = this.getSectionHeaderView(section, this.mCurrentHeaderViewType != viewType ? null : this.mCurrentHeader);
        this.ensurePinnedHeaderLayout(this.mCurrentHeader);
        this.mCurrentHeaderViewType = viewType;
        this.mHeaderOffset = 0.0f;
        for (int i = firstVisibleItem; i < firstVisibleItem + visibleItemCount; ++i) {
            if (!this.mAdapter.isSectionHeader(i)) continue;
            View header = this.getChildAt(i - firstVisibleItem);
            float headerTop = header.getTop();
            float pinnedHeaderHeight = this.mCurrentHeader.getMeasuredHeight();
            header.setVisibility(0);
            if (pinnedHeaderHeight >= headerTop && headerTop > 0.0f) {
                this.mHeaderOffset = headerTop - (float)header.getHeight();
                continue;
            }
            if (!(headerTop <= 0.0f)) continue;
            header.setVisibility(4);
        }
        this.invalidate();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mOnScrollListeners != null && this.mOnScrollListeners.size() > 0) {
            for (AbsListView.OnScrollListener item : this.mOnScrollListeners) {
                item.onScrollStateChanged(view, scrollState);
            }
        }
    }

    private View getSectionHeaderView(int section, View oldView) {
        boolean shouldLayout = section != this.mCurrentSection || oldView == null;
        View view = this.mAdapter.getSectionHeaderView(section, oldView, (ViewGroup)this);
        if (shouldLayout) {
            if (this.onSectionChangedListener != null && !this.smoothScrolling) {
                this.onSectionChangedListener.onSectionChanged(section, this.mCurrentSection);
            }
            this.ensurePinnedHeaderLayout(view);
            this.mCurrentSection = section;
        }
        return view;
    }

    private void ensurePinnedHeaderLayout(View header) {
        if (header.isLayoutRequested()) {
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000);
            ViewGroup.LayoutParams layoutParams = header.getLayoutParams();
            int heightSpec = layoutParams != null && layoutParams.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            header.measure(widthSpec, heightSpec);
            int height = header.getMeasuredHeight();
            header.layout(0, 0, this.getWidth(), height);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mAdapter == null || !this.mShouldPin || this.mCurrentHeader == null) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate(0.0f, this.mHeaderOffset);
        canvas.clipRect(0, 0, this.getWidth(), this.mCurrentHeader.getMeasuredHeight());
        this.mCurrentHeader.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    public void addOnScrollListener(AbsListView.OnScrollListener l) {
        if (this.mOnScrollListeners != null) {
            this.mOnScrollListeners.add(l);
        }
    }

    public void removeOnScrollListener(AbsListView.OnScrollListener l) {
        if (this.mOnScrollListeners != null && this.mOnScrollListeners.contains(l)) {
            this.mOnScrollListeners.remove(l);
        }
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        super.setOnItemClickListener((AdapterView.OnItemClickListener)listener);
    }

    public void setOnSectionChangedListener(OnSectionChangedListener onSectionChangedListener) {
        this.onSectionChangedListener = onSectionChangedListener;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.mCanPullDown) {
            return super.dispatchTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                if (!this.mPullDownEnabled) break;
                this.mCanRefresh = false;
                if (this.mIsRefreshing || !this.isOnTop()) break;
                this.prepareTracking(ev);
                break;
            }
            case 2: {
                if (this.mTracking) {
                    float curY = ev.getY();
                    if (!(curY - this.mStartY > 10.0f)) break;
                    this.requestDisallowInterceptTouchEvent(true);
                    this.mCurOffsetY = (int)((curY - this.mStartY) / 2.0f);
                    if (this.mCurOffsetY < this.mMaxHeaderHeight) {
                        this.setContainerHeight(this.mCurOffsetY);
                        if (this.mCurOffsetY >= this.mTriggerRefreshHeight) {
                            if (!this.mCanRefresh) {
                                this.mMajorText.setText((CharSequence)this.mReleaseString);
                                this.mIndicator.startAnimation(this.mAnimRotate);
                                this.mCanRefresh = true;
                            }
                        } else if (this.mCanRefresh) {
                            this.mMajorText.setText((CharSequence)this.mPullString);
                            this.mIndicator.startAnimation(this.mAnimRotateBack);
                            this.mCanRefresh = false;
                        }
                    } else {
                        this.mCurOffsetY = Math.max(0, this.mMaxHeaderHeight);
                    }
                    ev.setAction(3);
                    super.dispatchTouchEvent(ev);
                    return true;
                }
                if (!this.mPullDownEnabled || this.mTracking || this.mIsRefreshing || !this.isOnTop()) break;
                this.prepareTracking(ev);
                break;
            }
            case 1: 
            case 3: {
                this.startBuncingBack();
                if (!this.mTracking) break;
                if (this.mCanRefresh && this.mRefreshListener != null) {
                    this.mRefreshListener.onRefresh(this);
                }
                this.stopTracking();
            }
        }
        try {
            return super.dispatchTouchEvent(ev);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.setHeaderDividersEnabled(false);
        Resources resources = this.getResources();
        this.mLoadingFooter = new LoadingFooter(context);
        this.mLoadingFooter.setState(LoadingFooter.State.Idle);
        this.addFooterView(this.mLoadingFooter.getView());
        this.mLoadingHeader = new LoadingFooter(context);
        this.mLoadingHeader.setState(LoadingFooter.State.Loading);
        this.mTriggerRefreshHeight = 0;
        this.mTriggerRefreshHeight = resources.getDimensionPixelSize(R.dimen.pulldown_trigger_refresh_height);
        this.mPullHeader = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pulldown_header, null);
        this.mPullHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.mContainer = this.mPullHeader.findViewById(R.id.pull_header);
        this.mContainerLayoutParams = this.mContainer.getLayoutParams();
        this.setContainerHeight(0);
        this.mBackgroundImageView = (ImageView)this.mPullHeader.findViewById(R.id.img_bkg);
        this.mMajorText = (TextView)this.mPullHeader.findViewById(R.id.pull_header_major_text);
        this.mMinorText = (TextView)this.mPullHeader.findViewById(R.id.pull_header_minor_text);
        this.mIndicator = (ImageView)this.mPullHeader.findViewById(R.id.pullheader_indicator);
        this.mFirstHeader = this.mPullHeader;
        this.addHeaderView(this.mPullHeader);
        this.mPullString = resources.getString(R.string.pulldown_pull);
        this.mRefreshingString = resources.getString(R.string.pulldown_refreshing);
        this.mReleaseString = resources.getString(R.string.pulldown_release);
        this.mAnimRotate = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.rotate_180);
        this.mAnimRotate.setFillAfter(true);
        this.mAnimRotateBack = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.rotate_back_180);
        this.mAnimRotateBack.setFillAfter(true);
    }

    public LoadingFooter getLoadingFooter() {
        return this.mLoadingFooter;
    }

    public void pullToRefreshListViewOnScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mLoadingFooter.getState() == LoadingFooter.State.Loading || this.mLoadingFooter.getState() == LoadingFooter.State.TheEnd) {
            return;
        }
        if (firstVisibleItem + visibleItemCount >= totalItemCount && totalItemCount != 0 && totalItemCount != this.getHeaderViewsCount() + this.getFooterViewsCount()) {
            this.mLoadingFooter.setState(LoadingFooter.State.Loading);
            if (this.mPullUpListener != null) {
                this.mPullUpListener.onLoadMore(this);
            }
        }
    }

    public void setPullDownEnabled(boolean mPullDownEnabled) {
        this.mPullDownEnabled = mPullDownEnabled;
    }

    private void setContainerHeight(int height) {
        this.mContainerLayoutParams.height = height;
        this.mContainer.setLayoutParams(this.mContainerLayoutParams);
    }

    private int getContainerHeight() {
        return this.mContainerLayoutParams.height;
    }

    private boolean isOnTop() {
        return this.getFirstVisiblePosition() <= 0 && this.mFirstHeader.getTop() >= 0;
    }

    private void prepareTracking(MotionEvent ev) {
        this.mMajorText.setText((CharSequence)this.mPullString);
        this.mTracking = true;
        this.mStartY = ev.getY();
        if (this.mRefreshListener != null) {
            this.mRefreshListener.onPullDownStarted(this);
        }
    }

    private void stopTracking() {
        this.mTracking = false;
        this.requestDisallowInterceptTouchEvent(false);
    }

    public void setBackgroundImage(Bitmap bitmap) {
        this.mBackgroundImageView.setImageBitmap(bitmap);
    }

    public void setIndicatorRes(int resId) {
        this.mIndicator.setImageResource(resId);
    }

    public View getPullHeader() {
        return this.mPullHeader;
    }

    public TextView getMajorTextView() {
        return this.mMajorText;
    }

    public void setMajorText(String text) {
        this.mMajorText.setText((CharSequence)text);
    }

    public void setMinorText(String text) {
        this.mMinorText.setText((CharSequence)text);
    }

    public void setPullString(String mPullString) {
        this.mPullString = mPullString;
    }

    public void setRefreshingString(String mRefreshingString) {
        this.mRefreshingString = mRefreshingString;
    }

    public void setReleaseString(String mReleaseString) {
        this.mReleaseString = mReleaseString;
    }

    public void setPullDownStateListener(PullDownStateListener listener) {
        this.mRefreshListener = listener;
    }

    public void setPullUpStateListener(PullUpStateListener listener) {
        this.mPullUpListener = listener;
    }

    public boolean isRefreshing() {
        return this.mIsRefreshing;
    }

    public void setRefreshing1(boolean refreshing) {
        if (this.mIsRefreshing == refreshing) {
            return;
        }
        this.mIsRefreshing = refreshing;
        if (this.mIsRefreshing) {
            this.addHeaderView(this.mLoadingHeader.getView());
        } else {
            this.removeHeaderView(this.mLoadingHeader.getView());
        }
    }

    public void setRefreshing(boolean refreshing) {
        if (this.mIsRefreshing == refreshing) {
            return;
        }
        this.mIsRefreshing = refreshing;
        View prog = this.findViewById(R.id.pull_header_prog);
        if (this.mIsRefreshing) {
            if (this.getContainerHeight() < this.mTriggerRefreshHeight) {
                this.mCurOffsetY = this.mTriggerRefreshHeight;
                this.animateExpand();
            }
            this.mIndicator.clearAnimation();
            this.mIndicator.setVisibility(4);
            prog.setVisibility(0);
            this.mMajorText.setText((CharSequence)this.mRefreshingString);
        } else {
            this.mIndicator.setVisibility(0);
            this.mMajorText.setText((CharSequence)this.mPullString);
            prog.setVisibility(4);
            if (!this.mAnimating) {
                this.startBuncingBack();
            }
        }
    }

    public void animateExpand() {
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)((Object)this), (String)"containerHeight", (int[])new int[]{this.mTriggerRefreshHeight});
        animator.setDuration(200L);
        animator.start();
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                PinnedHeaderListView.this.mAnimating = true;
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                PinnedHeaderListView.this.mAnimating = false;
            }

            public void onAnimationCancel(Animator animation) {
                PinnedHeaderListView.this.mAnimating = false;
            }
        });
    }

    public void startBuncingBack() {
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)((Object)this), (String)"containerHeight", (int[])new int[]{0});
        animator.setDuration(200L);
        animator.start();
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                PinnedHeaderListView.this.mAnimating = true;
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                PinnedHeaderListView.this.mAnimating = false;
            }

            public void onAnimationCancel(Animator animation) {
                PinnedHeaderListView.this.mAnimating = false;
            }
        });
    }

    public void smoothScrollToPosition(final int position) {
        this.smoothScrolling = true;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                PinnedHeaderListView.this.setSelection(position);
                PinnedHeaderListView.this.smoothScrolling = false;
            }
        }, 1000L);
        View child = this.getChildAtPosition((AdapterView)this, position);
        if (child != null && (child.getTop() == 0 || child.getTop() > 0 && !this.canScrollVertically(1))) {
            return;
        }
        this.addOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(final AbsListView view, int scrollState) {
                if (scrollState == 0) {
                    PinnedHeaderListView.this.removeOnScrollListener(this);
                    new Handler().post(new Runnable(){

                        @Override
                        public void run() {
                            view.setSelection(position);
                        }
                    });
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                PinnedHeaderListView.this.smoothScrollToPositionFromTop(position, 0);
            }
        });
    }

    public View getChildAtPosition(AdapterView view, int position) {
        int index = position - view.getFirstVisiblePosition();
        if (index >= 0 && index < view.getChildCount()) {
            return view.getChildAt(index);
        }
        return null;
    }

    public static interface OnSectionChangedListener {
        public void onSectionChanged(int var1, int var2);
    }

    public static abstract class PullUpStateListener {
        public void onPullUpStarted(PinnedHeaderListView listView) {
        }

        public abstract void onLoadMore(PinnedHeaderListView var1);

        public void onBouncingEnd(PinnedHeaderListView listView) {
        }
    }

    public static abstract class PullDownStateListener {
        public void onPullDownStarted(PinnedHeaderListView listView) {
        }

        public abstract void onRefresh(PinnedHeaderListView var1);

        public void onBouncingEnd(PinnedHeaderListView listView) {
        }
    }

    public static abstract class OnItemClickListener
    implements AdapterView.OnItemClickListener {
        public void onItemClick(AdapterView<?> adapterView, View view, int rawPosition, long id2) {
            SectionedBaseAdapter adapter;
            if (adapterView.getAdapter().getClass().equals(HeaderViewListAdapter.class)) {
                HeaderViewListAdapter wrapperAdapter = (HeaderViewListAdapter)adapterView.getAdapter();
                adapter = (SectionedBaseAdapter)wrapperAdapter.getWrappedAdapter();
            } else {
                adapter = (SectionedBaseAdapter)adapterView.getAdapter();
            }
            int section = adapter.getSectionForPosition(rawPosition);
            int position = adapter.getPositionInSectionForPosition(rawPosition);
            if (position == -1) {
                this.onSectionClick(adapterView, view, section, id2);
            } else {
                this.onItemClick(adapterView, view, section, position, id2);
            }
        }

        public abstract void onItemClick(AdapterView<?> var1, View var2, int var3, int var4, long var5);

        public abstract void onSectionClick(AdapterView<?> var1, View var2, int var3, long var4);
    }
}

