/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.calendarlistview.library;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.kelin.calendarlistview.library.BaseCalendarItemAdapter;
import com.kelin.calendarlistview.library.BaseCalendarItemModel;
import com.kelin.calendarlistview.library.CalendarHelper;
import com.kelin.calendarlistview.library.CalendarListView;
import com.kelin.calendarlistview.library.R;
import java.lang.reflect.ParameterizedType;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TreeMap;

public class CalendarView
extends FrameLayout {
    private static final int ROW_ITEM_COUNT = 7;
    private static final int COLUMN_ITEM_COUNT = 5;
    private static final int ITEM_HEIGHT = 40;
    public static int mItemWidth = 0;
    public static int mItemHeight = 0;
    private TreeMap<String, BaseCalendarItemModel> dayModelTreeMap;
    private OnDateSelectedListener onDateSelectedListener;
    protected BaseCalendarItemAdapter calendarItemAdapter;
    protected GridView calendarGridView;
    protected View selectedFloatingView;
    private TextView floatingMonthTips;
    private GestureDetector gestureDetector;
    private String currentMonth;
    private String selectedDate;
    private boolean isMonthChanging = false;
    private Class<?> entityClass;
    private CalendarListView.OnMonthChangedListener onMonthChangedListener;

    public CalendarView(Context context) {
        super(context);
        mItemHeight = mItemWidth = CalendarHelper.width / 7;
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new FlingListener());
    }

    protected void setOnMonthChangedListener(CalendarListView.OnMonthChangedListener onMonthChangedListener) {
        this.onMonthChangedListener = onMonthChangedListener;
    }

    protected String getSelectedDate() {
        return this.selectedDate;
    }

    protected void setOnDateSelectedListener(OnDateSelectedListener onDateSelectedListener) {
        this.onDateSelectedListener = onDateSelectedListener;
    }

    protected TreeMap<String, BaseCalendarItemModel> getDayModelTreeMap() {
        return this.dayModelTreeMap;
    }

    public TextView getFloatingMonthTips() {
        return this.floatingMonthTips;
    }

    public View getSelectedFloatingView() {
        return this.selectedFloatingView;
    }

    protected void initView() {
        View content = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_calendar_view, (ViewGroup)this, true);
        this.calendarGridView = (GridView)content.findViewById(R.id.gridview);
        this.selectedFloatingView = content.findViewById(R.id.selected_view);
        this.floatingMonthTips = (TextView)this.findViewById(R.id.floating_month_tip);
        this.floatingMonthTips.setVisibility(8);
        this.floatingMonthTips.post(new Runnable(){

            @Override
            public void run() {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)CalendarView.this.floatingMonthTips.getLayoutParams();
                layoutParams.topMargin = 2 * mItemHeight - CalendarView.this.floatingMonthTips.getHeight() / 2;
                CalendarView.this.floatingMonthTips.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
        this.calendarGridView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.dayModelTreeMap.size() * mItemHeight / 7));
        this.calendarGridView.setAdapter((ListAdapter)this.calendarItemAdapter);
        this.calendarGridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CalendarView.this.animateSelectedViewToPos(position);
                CalendarView.this.selectedDate = CalendarView.this.calendarItemAdapter.getIndexToTimeMap().get(position);
                if (CalendarView.this.onDateSelectedListener != null) {
                    CalendarView.this.onDateSelectedListener.onDateSelected(CalendarView.this, view, CalendarView.this.selectedDate, position);
                }
            }
        });
        this.selectedFloatingView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(mItemWidth, mItemHeight));
    }

    protected void animateSelectedViewToDate(String date) {
        this.selectedDate = date;
        int position = this.calendarItemAdapter.getIndexToTimeMap().indexOf(date);
        this.animateSelectedViewToPos(position);
    }

    protected void animateSelectedViewToPos(int position) {
        int left = mItemWidth * (position % 7);
        int top = mItemHeight * (position / 7);
        PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((String)"X", (float[])new float[]{this.selectedFloatingView.getX(), left});
        PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((String)"Y", (float[])new float[]{this.selectedFloatingView.getY(), top});
        ObjectAnimator.ofPropertyValuesHolder((Object)this.selectedFloatingView, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY}).setDuration(200L).start();
    }

    protected void animateCalendarViewToDate(String date) {
        int position = this.calendarItemAdapter.getIndexToTimeMap().indexOf(date);
        int row = position / 7;
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{-(this.getHeight() * row / (this.getHeight() / mItemHeight))});
        objectAnimator2.setTarget((Object)this);
        objectAnimator2.setDuration(300L).start();
    }

    protected void initCalendarView() {
        Calendar calendar = Calendar.getInstance();
        long selectedTime = calendar.getTimeInMillis();
        this.selectedDate = CalendarHelper.YEAR_MONTH_DAY_FORMAT.format(selectedTime);
        this.currentMonth = CalendarHelper.YEAR_MONTH_FORMAT.format(selectedTime);
        TreeMap<String, BaseCalendarItemModel> calendarItemModelTreeMap = this.getDefaultCalendarDataListByYearMonth(this.currentMonth);
        for (BaseCalendarItemModel model : calendarItemModelTreeMap.values()) {
            if (!CalendarHelper.areEqualDays(model.getTimeMill(), selectedTime)) continue;
            model.setStatus(BaseCalendarItemModel.Status.SELECTED);
        }
        this.setDayModelTreeMap(calendarItemModelTreeMap);
        int pos = this.calendarItemAdapter.getIndexToTimeMap().indexOf(this.selectedDate);
        this.animateSelectedViewToPos(pos);
    }

    private void setDayModelTreeMap(TreeMap<String, BaseCalendarItemModel> dayModelTreeMap) {
        this.dayModelTreeMap = dayModelTreeMap;
        this.updateCalendarView();
    }

    protected void setCalendarItemAdapter(BaseCalendarItemAdapter calendarItemAdapter) {
        this.calendarItemAdapter = calendarItemAdapter;
        this.entityClass = (Class)((ParameterizedType)((Object)((Object)calendarItemAdapter)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.initCalendarView();
    }

    private void updateCalendarView() {
        this.initView();
        this.calendarItemAdapter.setDayModelList(this.dayModelTreeMap);
        this.calendarItemAdapter.notifyDataSetChanged();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.gestureDetector.onTouchEvent(ev);
        return super.dispatchTouchEvent(ev);
    }

    private TreeMap<String, BaseCalendarItemModel> getDefaultCalendarDataListByYearMonth(String yearMonth) {
        int calendarViewRow = 5;
        int calendarViewColumn = 7;
        Calendar calToday = Calendar.getInstance();
        Calendar calStartDate = Calendar.getInstance();
        calToday.setFirstDayOfWeek(1);
        calStartDate.setFirstDayOfWeek(1);
        long time = 0L;
        try {
            time = CalendarHelper.YEAR_MONTH_FORMAT.parse(yearMonth).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        calStartDate.setTimeInMillis(time);
        calStartDate.set(5, 1);
        calStartDate.set(11, 0);
        calStartDate.set(12, 0);
        calStartDate.set(13, 0);
        Calendar activeCalendar = (Calendar)calStartDate.clone();
        calStartDate.add(7, -(calStartDate.get(7) - 1));
        Calendar calEndDate = (Calendar)calStartDate.clone();
        calEndDate.add(5, calendarViewRow * calendarViewColumn - 1);
        Calendar calCalendar = Calendar.getInstance();
        calCalendar.setTimeInMillis(calStartDate.getTimeInMillis());
        TreeMap<String, BaseCalendarItemModel> dayModelList = new TreeMap<String, BaseCalendarItemModel>();
        for (int i = 0; i < calendarViewRow * calendarViewColumn; ++i) {
            BaseCalendarItemModel baseCalendarItemModel = null;
            try {
                baseCalendarItemModel = (BaseCalendarItemModel)this.entityClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            baseCalendarItemModel.setCurrentMonth(CalendarHelper.areEqualMonth(calCalendar, activeCalendar));
            baseCalendarItemModel.setToday(CalendarHelper.areEqualDays(calCalendar.getTimeInMillis(), calToday.getTimeInMillis()));
            baseCalendarItemModel.setTimeMill(calCalendar.getTimeInMillis());
            baseCalendarItemModel.setHoliday(1 == calCalendar.get(7) || 7 == calCalendar.get(7));
            baseCalendarItemModel.setDayNumber(String.valueOf(calCalendar.get(5)));
            calCalendar.add(5, 1);
            dayModelList.put(CalendarHelper.YEAR_MONTH_DAY_FORMAT.format(baseCalendarItemModel.getTimeMill()), baseCalendarItemModel);
        }
        return dayModelList;
    }

    protected void changeMonth(int offset, final String date, final CalendarListView.Status status) {
        this.selectedDate = date;
        this.isMonthChanging = true;
        CalendarView oldCalendarView = new CalendarView(this.getContext());
        oldCalendarView.setCalendarItemAdapter(this.calendarItemAdapter);
        FrameLayout container = (FrameLayout)this.getParent();
        container.addView((View)oldCalendarView);
        oldCalendarView.setTranslationY(this.getTranslationY());
        Calendar calendar = CalendarHelper.getCalendarByYearMonthDay(this.selectedDate);
        this.currentMonth = CalendarHelper.YEAR_MONTH_FORMAT.format(calendar.getTime());
        TreeMap<String, BaseCalendarItemModel> calendarItemModelTreeMap = this.getDefaultCalendarDataListByYearMonth(this.currentMonth);
        this.setDayModelTreeMap(calendarItemModelTreeMap);
        this.setTranslationY(this.getTranslationY() + (float)(offset * this.getHeight()));
        this.animateCalendarViewToNewMonth(oldCalendarView, offset, oldCalendarView.getTranslationY(), new CalendarListView.OnMonthChangedListener(){

            @Override
            public void onMonthChanged(String yearMonth) {
                if (status == CalendarListView.Status.LIST_OPEN) {
                    CalendarView.this.animateCalendarViewToDate(date);
                }
                CalendarView.this.animateSelectedViewToDate(date);
            }
        });
    }

    private void animateCalendarViewToNewMonth(final CalendarView oldCalendarView, int offset, float translationY, final CalendarListView.OnMonthChangedListener monthChangeListener) {
        this.floatingMonthTips.setText((CharSequence)this.currentMonth);
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)this.floatingMonthTips, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 0.0f});
        alpha.setDuration(1500L);
        alpha.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        alpha.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                CalendarView.this.floatingMonthTips.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                CalendarView.this.floatingMonthTips.setVisibility(8);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        alpha.start();
        ObjectAnimator objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{translationY});
        objectAnimator1.setTarget((Object)this);
        objectAnimator1.setDuration(800L).start();
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{oldCalendarView.getTranslationY() - (float)(offset * this.getHeight())});
        objectAnimator2.setTarget((Object)oldCalendarView);
        objectAnimator2.setDuration(800L).start();
        objectAnimator2.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                FrameLayout container = (FrameLayout)CalendarView.this.getParent();
                container.removeView((View)oldCalendarView);
                CalendarView.this.isMonthChanging = false;
                if (CalendarView.this.onMonthChangedListener != null) {
                    CalendarView.this.onMonthChangedListener.onMonthChanged(CalendarView.this.currentMonth);
                }
                if (monthChangeListener != null) {
                    monthChangeListener.onMonthChanged(CalendarView.this.currentMonth);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public SelectedRowColumn getSelectedRowColumn() {
        Calendar firstItemCalendar = CalendarHelper.getCalendarByYearMonthDay(this.dayModelTreeMap.firstKey());
        Calendar selectedItemCalendar = CalendarHelper.getCalendarByYearMonthDay(this.selectedDate);
        int diff = CalendarHelper.getDiffDayByTimeStamp(firstItemCalendar.getTimeInMillis(), selectedItemCalendar.getTimeInMillis());
        SelectedRowColumn selectedRowColumn = new SelectedRowColumn();
        selectedRowColumn.column = diff % 7;
        selectedRowColumn.row = diff / 7;
        return selectedRowColumn;
    }

    public static interface OnDateSelectedListener {
        public void onDateSelected(CalendarView var1, View var2, String var3, int var4);
    }

    public static class SelectedRowColumn {
        public int row;
        public int column;
    }

    private class FlingListener
    extends GestureDetector.SimpleOnGestureListener {
        private FlingListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!CalendarView.this.isMonthChanging && Math.abs(velocityY) > Math.abs(velocityX)) {
                Calendar calendar = CalendarHelper.getCalendarByYearMonthDay(CalendarView.this.selectedDate);
                calendar.add(2, velocityY < 0.0f ? 1 : -1);
                CalendarView.this.changeMonth(velocityY < 0.0f ? 1 : -1, CalendarHelper.YEAR_MONTH_DAY_FORMAT.format(calendar.getTime()), CalendarListView.Status.LIST_CLOSE);
            }
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return super.onScroll(e1, e2, distanceX, distanceY);
        }
    }
}

