/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.calendarlistview.library;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.database.DataSetObserver;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.kelin.calendarlistview.library.BaseCalendarItemAdapter;
import com.kelin.calendarlistview.library.BaseCalendarListAdapter;
import com.kelin.calendarlistview.library.CalendarHelper;
import com.kelin.calendarlistview.library.CalendarView;
import com.kelin.calendarlistview.library.LoadingFooter;
import com.kelin.calendarlistview.library.PinnedHeaderListView;
import com.kelin.calendarlistview.library.R;

public class CalendarListView
extends FrameLayout {
    private static final int WEEK_ITEM_TEXT_SIZE = 12;
    protected PinnedHeaderListView listView;
    protected CalendarView calendarView;
    protected LinearLayout weekBar;
    private GestureDetector gestureDetector;
    private String currentSelectedDate;
    private float startY;
    private float downY;
    private float dy;
    private Status status = Status.LIST_CLOSE;
    protected BaseCalendarListAdapter calendarListAdapter;
    protected BaseCalendarItemAdapter calendarItemAdapter;
    private onListPullListener onListPullListener;
    private OnCalendarViewItemClickListener onCalendarViewItemClickListener;

    public CalendarListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        CalendarHelper.init(context);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new FlingListener());
        LayoutInflater.from((Context)context).inflate(R.layout.layout_calendar_listview, (ViewGroup)this);
        this.listView = (PinnedHeaderListView)this.findViewById(R.id.listview);
        FrameLayout frameLayout = (FrameLayout)this.findViewById(R.id.calendar_view_container);
        this.calendarView = new CalendarView(context);
        frameLayout.addView((View)this.calendarView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.initListener();
        this.initWeekBar();
    }

    public void setCalendarListViewAdapter(BaseCalendarItemAdapter calendarItemAdapter, final BaseCalendarListAdapter calendarListAdapter) {
        this.calendarListAdapter = calendarListAdapter;
        this.calendarItemAdapter = calendarItemAdapter;
        this.listView.setAdapter((ListAdapter)calendarListAdapter);
        this.calendarView.setCalendarItemAdapter(calendarItemAdapter);
        this.listView.getAdapter().registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                int listPos;
                super.onChanged();
                if (TextUtils.isEmpty((CharSequence)CalendarListView.this.currentSelectedDate)) {
                    CalendarListView.this.currentSelectedDate = calendarListAdapter.getDateBySection(0);
                    int diffMonth = CalendarHelper.getDiffMonthByTime(CalendarListView.this.calendarView.getSelectedDate(), CalendarListView.this.currentSelectedDate);
                    if (diffMonth != 0) {
                        CalendarListView.this.calendarView.changeMonth(diffMonth, CalendarListView.this.currentSelectedDate, CalendarListView.this.status);
                    }
                    CalendarListView.this.calendarView.animateSelectedViewToDate(CalendarListView.this.currentSelectedDate);
                }
                if ((listPos = CalendarListView.this.calendarListAdapter.getDataListIndexByDate(CalendarListView.this.currentSelectedDate).intValue()) >= 0) {
                    CalendarListView.this.listView.smoothScrollToPosition(listPos);
                }
                CalendarListView.this.listView.setRefreshing(false);
                CalendarListView.this.listView.getLoadingFooter().setState(LoadingFooter.State.Idle);
            }
        });
    }

    public String getCurrentSelectedDate() {
        return this.currentSelectedDate;
    }

    public void setOnMonthChangedListener(OnMonthChangedListener onMonthChangedListener) {
        this.calendarView.setOnMonthChangedListener(onMonthChangedListener);
    }

    public void setOnListPullListener(onListPullListener onListPullListener2) {
        this.onListPullListener = onListPullListener2;
    }

    public void setOnCalendarViewItemClickListener(OnCalendarViewItemClickListener onCalendarViewItemClickListener) {
        this.onCalendarViewItemClickListener = onCalendarViewItemClickListener;
    }

    public void setWeekBar(LinearLayout weekBar) {
        this.weekBar = weekBar;
    }

    public LinearLayout getWeekBar() {
        return this.weekBar;
    }

    protected void initListener() {
        this.calendarView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int listViewHeight = CalendarListView.this.getHeight() - CalendarListView.this.weekBar.getHeight() - CalendarView.mItemHeight;
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)CalendarListView.this.listView.getLayoutParams();
                layoutParams.height = listViewHeight;
                CalendarListView.this.listView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
        this.calendarView.setOnDateSelectedListener(new CalendarView.OnDateSelectedListener(){

            @Override
            public void onDateSelected(CalendarView calendarView, View view, String time, int pos) {
                if (!CalendarListView.this.listView.smoothScrolling) {
                    CalendarListView.this.currentSelectedDate = time;
                    int listPos = CalendarListView.this.calendarListAdapter.getDataListIndexByDate(time);
                    OnCalendarViewItemClickListener.SelectedDateRegion selectedDateRegion = CalendarListView.this.calendarListAdapter.getSelectedDateTypeByDate(time);
                    if (selectedDateRegion == OnCalendarViewItemClickListener.SelectedDateRegion.INSIDE) {
                        CalendarListView.this.listView.smoothScrollToPosition(listPos);
                    }
                    if (CalendarListView.this.onCalendarViewItemClickListener != null) {
                        CalendarListView.this.onCalendarViewItemClickListener.onDateSelected(view, time, listPos, selectedDateRegion);
                    }
                }
            }
        });
        this.listView.setOnSectionChangedListener(new PinnedHeaderListView.OnSectionChangedListener(){

            @Override
            public void onSectionChanged(int newSection, int oldSection) {
                CalendarListView.this.currentSelectedDate = CalendarListView.this.calendarListAdapter.getDateBySection(newSection);
                String lastSelectDate = CalendarListView.this.calendarListAdapter.getDateBySection(oldSection);
                int diffMonth = CalendarHelper.getDiffMonthByTime(lastSelectDate, CalendarListView.this.currentSelectedDate);
                if (diffMonth == 0) {
                    diffMonth = CalendarHelper.getDiffMonthByTime(CalendarListView.this.calendarView.getSelectedDate(), CalendarListView.this.currentSelectedDate);
                }
                CalendarListView.this.changeMonth(diffMonth);
            }
        });
        this.listView.addOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0 && !CalendarListView.this.calendarView.getSelectedDate().equals(CalendarListView.this.currentSelectedDate)) {
                    Log.v((String)"Test", (String)"ChangeMonth");
                    int diffMonth = CalendarHelper.getDiffMonthByTime(CalendarListView.this.calendarView.getSelectedDate(), CalendarListView.this.currentSelectedDate);
                    CalendarListView.this.changeMonth(diffMonth);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.listView.setPullUpStateListener(new PinnedHeaderListView.PullUpStateListener(){

            @Override
            public void onLoadMore(PinnedHeaderListView listView) {
                CalendarListView.this.onListPullListener.onLoadMore();
            }
        });
        this.listView.setPullDownStateListener(new PinnedHeaderListView.PullDownStateListener(){

            @Override
            public void onRefresh(PinnedHeaderListView listView) {
                listView.setRefreshing(true);
                CalendarListView.this.onListPullListener.onRefresh();
            }
        });
    }

    protected void changeMonth(int diffMonth) {
        if (diffMonth != 0) {
            this.calendarView.changeMonth(diffMonth, this.currentSelectedDate, this.status);
        } else {
            if (this.status == Status.LIST_OPEN) {
                this.calendarView.animateCalendarViewToDate(this.currentSelectedDate);
            }
            this.calendarView.animateSelectedViewToDate(this.currentSelectedDate);
        }
    }

    protected void initWeekBar() {
        this.weekBar = (LinearLayout)this.findViewById(R.id.week_bar);
        String[] weeks = this.getResources().getStringArray(R.array.week);
        for (int i = 0; i < weeks.length; ++i) {
            String week = weeks[i];
            TextView textView = new TextView(this.getContext());
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
            textView.setText((CharSequence)week);
            textView.setTextSize(12.0f);
            if (i == 0 || i == weeks.length - 1) {
                textView.setTextColor(this.getResources().getColor(R.color.red_ff725f));
            } else {
                textView.setTextColor(this.getResources().getColor(17170444));
            }
            textView.setGravity(17);
            this.weekBar.addView((View)textView);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        CalendarView.SelectedRowColumn selectedRowColumn = this.calendarView.getSelectedRowColumn();
        switch (ev.getAction()) {
            case 0: {
                this.dy = ev.getY();
                if (this.status == Status.LIST_CLOSE && this.dy < (float)(this.weekBar.getBottom() + this.calendarView.getBottom())) {
                    return super.dispatchTouchEvent(ev);
                }
                if (this.status == Status.LIST_OPEN && this.dy > (float)(this.weekBar.getBottom() + CalendarView.mItemHeight)) {
                    return super.dispatchTouchEvent(ev);
                }
                this.startY = ev.getRawY();
                this.downY = ev.getRawY();
                this.gestureDetector.onTouchEvent(ev);
                break;
            }
            case 2: {
                float curY = ev.getRawY();
                if (this.status == Status.LIST_CLOSE && curY > this.startY) {
                    return super.dispatchTouchEvent(ev);
                }
                if (this.status == Status.LIST_OPEN && curY < this.startY) {
                    if (this.dy > (float)(this.weekBar.getBottom() + CalendarView.mItemHeight)) {
                        return super.dispatchTouchEvent(ev);
                    }
                    return true;
                }
                if (this.status == Status.LIST_CLOSE && this.dy < (float)(this.weekBar.getBottom() + this.calendarView.getBottom())) {
                    return super.dispatchTouchEvent(ev);
                }
                if (this.status == Status.LIST_OPEN && this.dy > (float)(this.weekBar.getBottom() + CalendarView.mItemHeight)) {
                    return super.dispatchTouchEvent(ev);
                }
                this.gestureDetector.onTouchEvent(ev);
                if (Math.abs(this.listView.getTranslationY()) >= (float)(this.calendarView.getHeight() - CalendarView.mItemHeight) && curY < this.startY) {
                    this.listView.setTranslationY(-(this.calendarView.getHeight() - CalendarView.mItemHeight));
                }
                if (curY > this.startY && this.listView.getTranslationY() >= 0.0f) {
                    this.listView.setTranslationY(0.0f);
                }
                this.listView.setTranslationY(this.listView.getTranslationY() + (curY - this.startY));
                this.calendarView.setTranslationY(this.calendarView.getTranslationY() + (float)selectedRowColumn.row * (curY - this.startY) / (float)(this.calendarView.getHeight() / CalendarView.mItemHeight - 1));
                this.startY = curY;
                this.status = Status.DRAGGING;
                return true;
            }
            case 1: {
                float curY = ev.getRawY();
                if (this.status != Status.DRAGGING) {
                    return super.dispatchTouchEvent(ev);
                }
                this.gestureDetector.onTouchEvent(ev);
                if (this.status == Status.ANIMATING) {
                    return super.dispatchTouchEvent(ev);
                }
                if (curY < this.downY) {
                    if (Math.abs(curY - this.downY) > (float)(this.calendarView.getHeight() / 2)) {
                        this.animationToTop(selectedRowColumn);
                        break;
                    }
                    this.animationToBottom();
                    break;
                }
                if (Math.abs(curY - this.downY) < (float)(this.calendarView.getHeight() / 2)) {
                    this.animationToTop(selectedRowColumn);
                    break;
                }
                this.animationToBottom();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void animationToTop(CalendarView.SelectedRowColumn selectedRowColumn) {
        this.status = Status.ANIMATING;
        ObjectAnimator objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{-(this.calendarView.getHeight() - CalendarView.mItemHeight)});
        objectAnimator1.setTarget((Object)this.listView);
        objectAnimator1.setDuration(300L).start();
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{-(this.calendarView.getHeight() * selectedRowColumn.row / (this.calendarView.getHeight() / CalendarView.mItemHeight))});
        objectAnimator2.setTarget((Object)this.calendarView);
        objectAnimator2.setDuration(300L).start();
        objectAnimator2.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                CalendarListView.this.status = Status.LIST_OPEN;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void animationToBottom() {
        this.status = Status.ANIMATING;
        ObjectAnimator objectAnimator1 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator1.setTarget((Object)this.listView);
        objectAnimator1.setDuration(300L).start();
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator2.setTarget((Object)this.calendarView);
        objectAnimator2.setDuration(300L).start();
        objectAnimator2.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                CalendarListView.this.status = Status.LIST_CLOSE;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    public static enum Status {
        LIST_OPEN,
        LIST_CLOSE,
        DRAGGING,
        ANIMATING;

    }

    public static interface OnMonthChangedListener {
        public void onMonthChanged(String var1);
    }

    public static interface onListPullListener {
        public void onRefresh();

        public void onLoadMore();
    }

    public static interface OnCalendarViewItemClickListener {
        public void onDateSelected(View var1, String var2, int var3, SelectedDateRegion var4);

        public static enum SelectedDateRegion {
            BEFORE,
            AFTER,
            INSIDE;

        }
    }

    private class FlingListener
    extends GestureDetector.SimpleOnGestureListener {
        private FlingListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (CalendarListView.this.status != Status.ANIMATING) {
                if (velocityY < 0.0f) {
                    CalendarListView.this.animationToTop(CalendarListView.this.calendarView.getSelectedRowColumn());
                } else {
                    CalendarListView.this.animationToBottom();
                }
            }
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return super.onScroll(e1, e2, distanceX, distanceY);
        }
    }
}

