/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.calendarlistview.library;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.TextView;
import com.kelin.calendarlistview.library.CalendarHelper;
import com.kelin.calendarlistview.library.CalendarListView;
import com.kelin.calendarlistview.library.R;
import com.kelin.calendarlistview.library.SectionedBaseAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public abstract class BaseCalendarListAdapter<T>
extends SectionedBaseAdapter {
    public static final int CALENDAR_HEADER_HEIGHT = 30;
    protected LayoutInflater inflater;
    protected TreeMap<String, List<T>> dateDataMap = new TreeMap();
    protected TreeMap<String, Integer> dateMapToPos = new TreeMap();
    protected List<String> indexToTimeList = new ArrayList<String>();

    public void setDateDataMap(TreeMap<String, List<T>> dateDataMap) {
        this.dateDataMap = dateDataMap;
        this.indexToTimeList = new ArrayList<String>(dateDataMap.keySet());
        int pos = 0;
        for (String key : this.indexToTimeList) {
            this.dateMapToPos.put(key, pos);
            pos += dateDataMap.get(key).size() + 1;
        }
    }

    public BaseCalendarListAdapter(Context context) {
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    @Override
    public Object getItem(int section, int position) {
        return null;
    }

    @Override
    public long getItemId(int section, int position) {
        return 0L;
    }

    @Override
    public int getCountForSection(int section) {
        String date = this.indexToTimeList.get(section);
        return this.dateDataMap.get(date).size();
    }

    @Override
    public int getSectionCount() {
        return this.dateDataMap.size();
    }

    @Override
    public View getItemView(int section, int position, View convertView, ViewGroup parent) {
        String date = this.indexToTimeList.get(section);
        return this.getItemView(this.dateDataMap.get(date).get(position), date, position, convertView, parent);
    }

    public abstract View getItemView(T var1, String var2, int var3, View var4, ViewGroup var5);

    @Override
    public View getSectionHeaderView(int section, View convertView, ViewGroup parent) {
        String date = this.indexToTimeList.get(section);
        return this.getSectionHeaderView(date, convertView, parent);
    }

    public Integer getDataListIndexByDate(String date) {
        int i;
        for (i = 0; i < this.indexToTimeList.size(); ++i) {
            String key = this.indexToTimeList.get(i);
            if (key.compareTo(date) <= 0) continue;
            if (i > 0) {
                return this.dateMapToPos.get(this.indexToTimeList.get(i - 1)) + 1;
            }
            if (i != 0) continue;
            return 1;
        }
        return this.dateMapToPos.get(this.indexToTimeList.get(i - 1)) + 1;
    }

    protected CalendarListView.OnCalendarViewItemClickListener.SelectedDateRegion getSelectedDateTypeByDate(String date) {
        String key = this.indexToTimeList.get(0);
        if (key.compareTo(date) > 0) {
            return CalendarListView.OnCalendarViewItemClickListener.SelectedDateRegion.BEFORE;
        }
        key = this.indexToTimeList.get(this.indexToTimeList.size() - 1);
        if (key.compareTo(date) < 0) {
            return CalendarListView.OnCalendarViewItemClickListener.SelectedDateRegion.AFTER;
        }
        return CalendarListView.OnCalendarViewItemClickListener.SelectedDateRegion.INSIDE;
    }

    public String getDateBySection(int section) {
        return this.indexToTimeList.get(section);
    }

    public View getSectionHeaderView(String date, View convertView, ViewGroup parent) {
        HeaderViewHolder headerViewHolder;
        if (convertView != null) {
            headerViewHolder = (HeaderViewHolder)convertView.getTag();
        } else {
            convertView = this.inflater.inflate(R.layout.listitem_calendar_header, null);
            convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, CalendarHelper.dp2px(30)));
            headerViewHolder = new HeaderViewHolder();
            headerViewHolder.dateText = (TextView)convertView.findViewById(R.id.calendar_header_text_date);
            convertView.setTag((Object)headerViewHolder);
        }
        headerViewHolder.dateText.setText((CharSequence)date);
        return convertView;
    }

    private static class HeaderViewHolder {
        TextView dateText;

        private HeaderViewHolder() {
        }
    }
}

