/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.calendarlistview.library;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.kelin.calendarlistview.library.BaseCalendarItemModel;
import com.kelin.calendarlistview.library.CalendarView;
import com.kelin.calendarlistview.library.R;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class BaseCalendarItemAdapter<T extends BaseCalendarItemModel>
extends BaseAdapter {
    protected Context mContext;
    protected TreeMap<String, T> dayModelList = new TreeMap();
    protected List<String> indexToTimeMap = new ArrayList<String>();

    public BaseCalendarItemAdapter(Context context) {
        this.mContext = context;
    }

    public TreeMap<String, T> getDayModelList() {
        return this.dayModelList;
    }

    public void setDayModelList(TreeMap<String, T> dayModelList) {
        this.dayModelList = dayModelList;
        this.indexToTimeMap.clear();
        for (String time : this.dayModelList.keySet()) {
            this.indexToTimeMap.add(time);
        }
    }

    public List<String> getIndexToTimeMap() {
        return this.indexToTimeMap;
    }

    public int getCount() {
        return this.dayModelList.size();
    }

    public Object getItem(int position) {
        return position;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(String date, T model, View convertView, ViewGroup parent) {
        View view = convertView;
        if (view == null) {
            view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.griditem_calendar_item, null);
        }
        TextView dayNum = (TextView)view.findViewById(R.id.tv_day_num);
        dayNum.setText((CharSequence)((BaseCalendarItemModel)model).getDayNumber());
        view.setBackgroundResource(R.drawable.bg_shape_calendar_item_normal);
        if (((BaseCalendarItemModel)model).isToday()) {
            dayNum.setTextColor(this.mContext.getResources().getColor(R.color.red_ff725f));
            dayNum.setText((CharSequence)this.mContext.getResources().getString(R.string.today));
        }
        if (((BaseCalendarItemModel)model).isHoliday()) {
            dayNum.setTextColor(this.mContext.getResources().getColor(R.color.red_ff725f));
        }
        if (((BaseCalendarItemModel)model).getStatus() == BaseCalendarItemModel.Status.DISABLE) {
            dayNum.setTextColor(this.mContext.getResources().getColor(0x1060000));
        }
        if (!((BaseCalendarItemModel)model).isCurrentMonth()) {
            dayNum.setTextColor(this.mContext.getResources().getColor(R.color.gray_bbbbbb));
            view.setClickable(true);
        }
        return view;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        String date = this.indexToTimeMap.get(position);
        View view = this.getView(date, (BaseCalendarItemModel)this.dayModelList.get(date), convertView, parent);
        AbsListView.LayoutParams layoutParams = new AbsListView.LayoutParams(CalendarView.mItemWidth, CalendarView.mItemHeight);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return view;
    }
}

