/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.calendarlistview.library;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.kelin.calendarlistview.library.R;

public class LoadingFooter {
    protected View mLoadingFooter;
    protected ProgressBar mLoadingProgressBar;
    protected TextView mLoadingText;
    protected State mState = State.Idle;

    public LoadingFooter(Context context) {
        this.mLoadingFooter = LayoutInflater.from((Context)context).inflate(R.layout.listfooter_loading, null);
        this.mLoadingFooter.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.mLoadingProgressBar = (ProgressBar)this.mLoadingFooter.findViewById(R.id.progress_loading);
        this.mLoadingText = (TextView)this.mLoadingFooter.findViewById(R.id.text_loading);
        this.mLoadingFooter.setVisibility(8);
    }

    protected void init(String noMoreDataMessage, int loadingTextColor) {
        this.mLoadingText.setText((CharSequence)noMoreDataMessage);
        this.mLoadingText.setTextColor(loadingTextColor);
        this.setState(State.Idle);
    }

    public View getView() {
        return this.mLoadingFooter;
    }

    public State getState() {
        return this.mState;
    }

    public void setState(final State state, long delay) {
        this.mLoadingFooter.postDelayed(new Runnable(){

            @Override
            public void run() {
                LoadingFooter.this.setState(state);
            }
        }, delay);
    }

    public void setState(State status) {
        if (this.mState == status) {
            return;
        }
        this.mState = status;
        this.mLoadingFooter.setVisibility(0);
        switch (status) {
            case Loading: {
                this.mLoadingProgressBar.setVisibility(0);
                this.mLoadingText.setVisibility(8);
                break;
            }
            case TheEnd: {
                this.mLoadingText.setVisibility(0);
                this.mLoadingProgressBar.setVisibility(8);
                this.mLoadingText.startAnimation(LoadingFooter.getFadeInAnimation(null, 100L));
                break;
            }
            default: {
                this.mLoadingFooter.setVisibility(8);
            }
        }
    }

    public static Animation getFadeInAnimation(Animation.AnimationListener listener, long duration) {
        AlphaAnimation mFadeInAnimation = new AlphaAnimation(0.0f, 1.0f);
        mFadeInAnimation.setDuration(duration);
        mFadeInAnimation.setAnimationListener(listener);
        return mFadeInAnimation;
    }

    public static enum State {
        Idle,
        TheEnd,
        Loading;

    }
}

