/*
 * Decompiled with CFR 0.152.
 */
package com.kelin.calendarlistview.library;

import android.content.Context;
import android.util.DisplayMetrics;
import com.kelin.calendarlistview.library.BaseCalendarItemModel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TreeMap;

public final class CalendarHelper {
    private static final int ROW_ITEM_COUNT = 7;
    private static final int COLUMN_ITEM_COUNT = 6;
    public static final long ONE_DAY_TIME = 86400000L;
    public static float density;
    public static int width;
    public static int height;
    public static final SimpleDateFormat YEAR_MONTH_FORMAT;
    public static final SimpleDateFormat YEAR_MONTH_DAY_FORMAT;

    private CalendarHelper() {
    }

    public static void init(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        width = metrics.widthPixels;
        height = metrics.heightPixels;
        density = metrics.density;
    }

    public static int dp2px(int dp) {
        return (int)((float)dp * density);
    }

    public static <T extends BaseCalendarItemModel> TreeMap<String, T> getDefaultCalendarDataListByMonthOffset(String yearMonth, Class<T> clazz) {
        int calendarViewRow = 6;
        int calendarViewColumn = 7;
        Calendar calToday = Calendar.getInstance();
        Calendar calStartDate = Calendar.getInstance();
        calToday.setFirstDayOfWeek(1);
        calStartDate.setFirstDayOfWeek(1);
        long time = 0L;
        try {
            time = YEAR_MONTH_FORMAT.parse(yearMonth).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        calStartDate.setTimeInMillis(time);
        calStartDate.set(5, 1);
        calStartDate.set(11, 0);
        calStartDate.set(12, 0);
        calStartDate.set(13, 0);
        Calendar activeCalendar = (Calendar)calStartDate.clone();
        calStartDate.add(7, -(calStartDate.get(7) - 1));
        Calendar calEndDate = (Calendar)calStartDate.clone();
        calEndDate.add(5, calendarViewRow * calendarViewColumn - 1);
        Calendar calCalendar = Calendar.getInstance();
        calCalendar.setTimeInMillis(calStartDate.getTimeInMillis());
        TreeMap<String, BaseCalendarItemModel> dayModelList = new TreeMap<String, BaseCalendarItemModel>();
        if (calEndDate.get(5) >= calendarViewColumn) {
            --calendarViewRow;
        }
        for (int i = 0; i < calendarViewRow * calendarViewColumn; ++i) {
            BaseCalendarItemModel baseCalendarItemModel = null;
            try {
                baseCalendarItemModel = (BaseCalendarItemModel)clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            baseCalendarItemModel.setCurrentMonth(CalendarHelper.areEqualMonth(calCalendar, activeCalendar));
            baseCalendarItemModel.setToday(CalendarHelper.areEqualDays(calCalendar.getTimeInMillis(), calToday.getTimeInMillis()));
            baseCalendarItemModel.setTimeMill(calCalendar.getTimeInMillis());
            baseCalendarItemModel.setHoliday(1 == calCalendar.get(7) || 7 == calCalendar.get(7));
            baseCalendarItemModel.setDayNumber(String.valueOf(calCalendar.get(5)));
            calCalendar.add(5, 1);
            dayModelList.put(YEAR_MONTH_DAY_FORMAT.format(baseCalendarItemModel.getTimeMill()), baseCalendarItemModel);
        }
        return dayModelList;
    }

    public static Calendar getCalendarByYearMonth(String yearMonth) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTimeInMillis(YEAR_MONTH_FORMAT.parse(yearMonth).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return calendar;
    }

    public static Calendar getCalendarByYearMonthDay(String yearMonthDay) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTimeInMillis(YEAR_MONTH_DAY_FORMAT.parse(yearMonthDay).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return calendar;
    }

    public static boolean areEqualDays(long time1, long time2) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return sdf.format(time1).equals(sdf.format(time2));
    }

    public static boolean areEqualMonth(Calendar c1, Calendar c2) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-yyyy");
        return sdf.format(c1.getTime()).equals(sdf.format(c2.getTime()));
    }

    public static int getDiffDayByTimeStamp(long startTimeStamp, long endTimeStamp) {
        return Math.round((float)(endTimeStamp - startTimeStamp) * 1.0f / 8.64E7f);
    }

    public static int getDiffMonthByTime(String startTime, String endTime) {
        Calendar startCalendar = CalendarHelper.getCalendarByYearMonthDay(startTime);
        Calendar endCalendar = CalendarHelper.getCalendarByYearMonthDay(endTime);
        return 12 * (endCalendar.get(1) - startCalendar.get(1)) + endCalendar.get(2) - startCalendar.get(2);
    }

    static {
        YEAR_MONTH_FORMAT = new SimpleDateFormat("yyyy-MM");
        YEAR_MONTH_DAY_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    }
}

