/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.config;

import com.katanox.tabour.base.IEventHandlerBase;
import com.katanox.tabour.config.EventPollerProperties;
import com.katanox.tabour.config.TabourAutoConfigs;
import com.katanox.tabour.factory.BusType;
import com.katanox.tabour.factory.EventHandlerFactory;
import com.katanox.tabour.integration.sqs.config.SqsAutoConfigurationLifecycle;
import com.katanox.tabour.integration.sqs.config.SqsConfiguration;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventHandlerRegistry;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="tabour.sqs", name={"enable-consumption"}, havingValue="true")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J \u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/katanox/tabour/integration/sqs/config/SqsConsumptionConfiguration;", "", "tabourAutoConfigs", "Lcom/katanox/tabour/config/TabourAutoConfigs;", "(Lcom/katanox/tabour/config/TabourAutoConfigs;)V", "getTabourAutoConfigs", "()Lcom/katanox/tabour/config/TabourAutoConfigs;", "sqsLifecycle", "Lcom/katanox/tabour/integration/sqs/config/SqsAutoConfigurationLifecycle;", "registry", "Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventHandlerRegistry;", "sqsMessageHandlerRegistry", "eventConsumerFactory", "Lcom/katanox/tabour/factory/EventHandlerFactory;", "eventPollerProperties", "Lcom/katanox/tabour/config/EventPollerProperties;", "sqsConfiguration", "Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "tabour"})
public class SqsConsumptionConfiguration {
    @NotNull
    private final TabourAutoConfigs tabourAutoConfigs;

    public SqsConsumptionConfiguration(@NotNull TabourAutoConfigs tabourAutoConfigs) {
        Intrinsics.checkNotNullParameter((Object)tabourAutoConfigs, (String)"tabourAutoConfigs");
        this.tabourAutoConfigs = tabourAutoConfigs;
    }

    @NotNull
    public TabourAutoConfigs getTabourAutoConfigs() {
        return this.tabourAutoConfigs;
    }

    @Bean
    @NotNull
    public SqsEventHandlerRegistry sqsMessageHandlerRegistry(@NotNull EventHandlerFactory eventConsumerFactory, @NotNull EventPollerProperties eventPollerProperties, @NotNull SqsConfiguration sqsConfiguration) {
        Intrinsics.checkNotNullParameter((Object)eventConsumerFactory, (String)"eventConsumerFactory");
        Intrinsics.checkNotNullParameter((Object)eventPollerProperties, (String)"eventPollerProperties");
        Intrinsics.checkNotNullParameter((Object)sqsConfiguration, (String)"sqsConfiguration");
        List<IEventHandlerBase> list = eventConsumerFactory.getEventHandlers(BusType.SQS);
        TabourAutoConfigs tabourAutoConfigs = this.getTabourAutoConfigs();
        return new SqsEventHandlerRegistry(list, sqsConfiguration, tabourAutoConfigs, eventPollerProperties);
    }

    @Bean
    @NotNull
    public SqsAutoConfigurationLifecycle sqsLifecycle(@NotNull SqsEventHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return new SqsAutoConfigurationLifecycle(registry);
    }
}

