/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.factory;

import com.katanox.tabour.base.IEventPublisherBase;
import com.katanox.tabour.exception.PublisherNotFoundException;
import com.katanox.tabour.factory.BusType;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/katanox/tabour/factory/EventPublisherFactory;", "", "services", "", "Lcom/katanox/tabour/base/IEventPublisherBase;", "(Ljava/util/List;)V", "eventPublishers", "", "Lcom/katanox/tabour/factory/BusType;", "getEventPublisher", "type", "tabour"})
public final class EventPublisherFactory {
    @NotNull
    private final Map<BusType, IEventPublisherBase> eventPublishers;

    public EventPublisherFactory(@NotNull List<? extends IEventPublisherBase> services) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        this.eventPublishers = new EnumMap(BusType.class);
        for (IEventPublisherBase iEventPublisherBase : services) {
            Map<BusType, IEventPublisherBase> map = this.eventPublishers;
            BusType busType = iEventPublisherBase.getType();
            map.put(busType, iEventPublisherBase);
        }
    }

    @NotNull
    public final IEventPublisherBase getEventPublisher(@NotNull BusType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        IEventPublisherBase iEventPublisherBase = this.eventPublishers.get((Object)type);
        if (iEventPublisherBase == null) {
            throw new PublisherNotFoundException(Intrinsics.stringPlus((String)"Unknown service type: ", (Object)((Object)type)));
        }
        return iEventPublisherBase;
    }
}

