/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.core.publisher;

import com.katanox.tabour.base.IEventPublisherBase;
import com.katanox.tabour.config.TabourAutoConfigs;
import com.katanox.tabour.extentions.RetryKt;
import com.katanox.tabour.factory.BusType;
import com.katanox.tabour.integration.sqs.core.publisher.SqsEventPublisher;
import com.katanox.tabour.integration.sqs.core.publisher.SqsEventPublisherKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0012J\b\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0012J\"\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0016J(\u0010\u0015\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0012J(\u0010\u0017\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/katanox/tabour/integration/sqs/core/publisher/SqsEventPublisher;", "Lcom/katanox/tabour/base/IEventPublisherBase;", "sqsClient", "Lsoftware/amazon/awssdk/services/sqs/SqsClient;", "tabourConfigs", "Lcom/katanox/tabour/config/TabourAutoConfigs;", "(Lsoftware/amazon/awssdk/services/sqs/SqsClient;Lcom/katanox/tabour/config/TabourAutoConfigs;)V", "doPublish", "", "messages", "", "", "busUrl", "messagesGroupId", "getType", "Lcom/katanox/tabour/factory/BusType;", "prepareRequest", "Lsoftware/amazon/awssdk/services/sqs/model/SendMessageBatchRequest;", "kotlin.jvm.PlatformType", "messageChunk", "messageGroupId", "publish", "message", "publishBatch", "validateRequest", "request", "tabour"})
public class SqsEventPublisher
implements IEventPublisherBase {
    @NotNull
    private final SqsClient sqsClient;
    @NotNull
    private final TabourAutoConfigs tabourConfigs;

    public SqsEventPublisher(@NotNull SqsClient sqsClient, @NotNull TabourAutoConfigs tabourConfigs) {
        Intrinsics.checkNotNullParameter((Object)sqsClient, (String)"sqsClient");
        Intrinsics.checkNotNullParameter((Object)tabourConfigs, (String)"tabourConfigs");
        this.sqsClient = sqsClient;
        this.tabourConfigs = tabourConfigs;
    }

    @Override
    @NotNull
    public BusType getType() {
        return BusType.SQS;
    }

    @Override
    public void publish(@NotNull String message, @NotNull String busUrl, @Nullable String messageGroupId) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)busUrl, (String)"busUrl");
        this.publishBatch(CollectionsKt.listOf((Object)message), busUrl, messageGroupId);
    }

    @Override
    public void publishBatch(@NotNull List<String> messages, @NotNull String busUrl, @Nullable String messagesGroupId) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)busUrl, (String)"busUrl");
        this.publish(messages, busUrl, messagesGroupId);
    }

    private void publish(List<String> messages, String busUrl, String messageGroupId) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, messages, busUrl, messageGroupId, null){
            long J$0;
            double D$0;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ SqsEventPublisher this$0;
            final /* synthetic */ List<String> $messages;
            final /* synthetic */ String $busUrl;
            final /* synthetic */ String $messageGroupId;
            {
                this.this$0 = $receiver;
                this.$messages = $messages;
                this.$busUrl = $busUrl;
                this.$messageGroupId = $messageGroupId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block8: {
                    var21_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = SqsEventPublisher.access$getTabourConfigs$p(this.this$0).getTabourProperties().getMaxRetryCount();
                            var9_4 = this.this$0;
                            var10_5 = this.$messages;
                            var11_6 = this.$busUrl;
                            var12_7 = this.$messageGroupId;
                            initialDelay$iv = 100L;
                            maxDelay$iv = 1000L;
                            factor$iv = 2.0;
                            $i$f$retry = false;
                            currentDelay$iv = new Ref.LongRef();
                            currentDelay$iv.element = initialDelay$iv;
                            var15_13 = times$iv - true;
                            var16_14 = 0;
lbl18:
                            // 2 sources

                            while (var16_14 < var15_13) {
                                var17_15 = var16_14++;
                                $i$a$-repeat-RetryKt$retry$2$iv = false;
                                try {
                                    $i$a$-retry$default-SqsEventPublisher$publish$1$1 = false;
                                    SqsEventPublisher.access$doPublish(var9_4, var10_5, var11_6, var12_7);
                                    break block8;
                                }
                                catch (Exception e$iv) {
                                    RetryKt.getLogger().warn(e$iv.getMessage());
                                    this.L$0 = var9_4;
                                    this.L$1 = var10_5;
                                    this.L$2 = var11_6;
                                    this.L$3 = var12_7;
                                    this.L$4 = currentDelay$iv;
                                    this.J$0 = maxDelay$iv;
                                    this.D$0 = factor$iv;
                                    this.I$0 = var15_13;
                                    this.I$1 = var16_14;
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)currentDelay$iv.element, (Continuation)this);
                                    if (v0 == var21_2) {
                                        return var21_2;
                                    }
                                    ** GOTO lbl58
                                }
                            }
                            break;
                        }
                        case 1: {
                            $i$f$retry = false;
                            $i$a$-repeat-RetryKt$retry$2$iv = false;
                            var16_14 = this.I$1;
                            var15_13 = this.I$0;
                            factor$iv = this.D$0;
                            maxDelay$iv = this.J$0;
                            currentDelay$iv = (Ref.LongRef)this.L$4;
                            var12_7 = (String)this.L$3;
                            var11_6 = (String)this.L$2;
                            var10_5 = (List)this.L$1;
                            var9_4 = (SqsEventPublisher)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl58:
                            // 2 sources

                            currentDelay$iv.element = RangesKt.coerceAtMost((long)((long)((double)currentDelay$iv.element * factor$iv)), (long)maxDelay$iv);
                            ** GOTO lbl18
                        }
                    }
                    $i$a$-retry$default-SqsEventPublisher$publish$1$1 = false;
                    SqsEventPublisher.access$doPublish(var9_4, var10_5, var11_6, var12_7);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private void doPublish(List<String> messages, String busUrl, String messagesGroupId) {
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)messages, (int)10);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List messageChunk = (List)element$iv;
            boolean bl = false;
            SqsEventPublisherKt.access$getLogger$p().debug("sending messages chunk " + messages + " to SQS queue " + busUrl);
            SendMessageBatchRequest request = this.prepareRequest(busUrl, messageChunk, messagesGroupId);
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
            this.validateRequest(request);
            SendMessageBatchResponse result = this.sqsClient.sendMessageBatch(request);
            if (result.sdkHttpResponse().statusCode() != 200) {
                throw new RuntimeException("got error response from SQS queue " + busUrl + ": " + result.responseMetadata());
            }
            KLogger kLogger = SqsEventPublisherKt.access$getLogger$p();
            List list = result.successful();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"result.successful()");
            kLogger.debug(Intrinsics.stringPlus((String)"Sent messages  with IDs ", (Object)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, (Function1)doPublish.1.1.INSTANCE, (int)30, null)));
        }
    }

    private void validateRequest(SendMessageBatchRequest request) {
        if (!(request.queueUrl() != null)) {
            boolean $i$a$-require-SqsEventPublisher$validateRequest$32 = false;
            String $i$a$-require-SqsEventPublisher$validateRequest$32 = "attribute queueUrl of pre-configured request must not be set!";
            throw new IllegalArgumentException($i$a$-require-SqsEventPublisher$validateRequest$32.toString());
        }
        if (!request.hasEntries()) {
            boolean bl = false;
            String string = "message body of pre-configured request must not be set!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private SendMessageBatchRequest prepareRequest(String busUrl, List<String> messageChunk, String messageGroupId) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Iterable iterable = messageChunk;
        SendMessageBatchRequest.Builder builder = SendMessageBatchRequest.builder().queueUrl(busUrl);
        boolean $i$f$mapIndexed = false;
        void var6_7 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void message;
            void index;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SendMessageBatchRequestEntry.Builder entry = SendMessageBatchRequestEntry.builder().id(String.valueOf((int)index)).messageBody((String)message);
            if (messageGroupId != null) {
                boolean bl2 = false;
                entry.messageGroupId(messageGroupId);
            }
            collection.add((SendMessageBatchRequestEntry)entry.build());
        }
        return (SendMessageBatchRequest)builder.entries((Collection)((List)destination$iv$iv)).build();
    }

    public static final /* synthetic */ TabourAutoConfigs access$getTabourConfigs$p(SqsEventPublisher $this) {
        return $this.tabourConfigs;
    }

    public static final /* synthetic */ void access$doPublish(SqsEventPublisher $this, List messages, String busUrl, String messagesGroupId) {
        $this.doPublish(messages, busUrl, messagesGroupId);
    }
}

