/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.core.consumer;

import com.katanox.tabour.config.EventPollerProperties;
import com.katanox.tabour.config.TabourAutoConfigs;
import com.katanox.tabour.extentions.RetryKt;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventHandler;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventPoller;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventPollerKt;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016H\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventPoller;", "Lkotlinx/coroutines/CoroutineScope;", "queueUrl", "", "eventHandler", "Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventHandler;", "client", "Lsoftware/amazon/awssdk/services/sqs/SqsClient;", "pollerConfigs", "Lcom/katanox/tabour/config/EventPollerProperties;", "tabourConfigs", "Lcom/katanox/tabour/config/TabourAutoConfigs;", "(Ljava/lang/String;Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventHandler;Lsoftware/amazon/awssdk/services/sqs/SqsClient;Lcom/katanox/tabour/config/EventPollerProperties;Lcom/katanox/tabour/config/TabourAutoConfigs;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "supervisorJob", "Lkotlinx/coroutines/CompletableJob;", "acknowledgeMessage", "", "messagesToDelete", "", "Lsoftware/amazon/awssdk/services/sqs/model/DeleteMessageBatchRequestEntry;", "handleMessage", "processMessage", "", "sqsMessage", "Lsoftware/amazon/awssdk/services/sqs/model/Message;", "retrieveMessages", "start", "Lkotlinx/coroutines/Job;", "stop", "tabour"})
public final class SqsEventPoller
implements CoroutineScope {
    @NotNull
    private final String queueUrl;
    @NotNull
    private final SqsEventHandler eventHandler;
    @NotNull
    private final SqsClient client;
    @NotNull
    private final EventPollerProperties pollerConfigs;
    @NotNull
    private final TabourAutoConfigs tabourConfigs;
    @NotNull
    private final CompletableJob supervisorJob;

    public SqsEventPoller(@NotNull String queueUrl, @NotNull SqsEventHandler eventHandler, @NotNull SqsClient client, @NotNull EventPollerProperties pollerConfigs, @NotNull TabourAutoConfigs tabourConfigs) {
        Intrinsics.checkNotNullParameter((Object)queueUrl, (String)"queueUrl");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)pollerConfigs, (String)"pollerConfigs");
        Intrinsics.checkNotNullParameter((Object)tabourConfigs, (String)"tabourConfigs");
        this.queueUrl = queueUrl;
        this.eventHandler = eventHandler;
        this.client = client;
        this.pollerConfigs = pollerConfigs;
        this.tabourConfigs = tabourConfigs;
        this.supervisorJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return Dispatchers.getIO().plus((CoroutineContext)this.supervisorJob);
    }

    @NotNull
    public final Job start() {
        return BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SqsEventPoller this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SqsEventPollerKt.access$getLogger$p().debug(Intrinsics.stringPlus((String)"starting SqsMessagePoller ", (Object)LocalDateTime.now()));
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ SqsEventPoller this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                        int n = SqsEventPoller.access$getPollerConfigs$p(this.this$0).getNumOfPollers();
                                        SqsEventPoller sqsEventPoller = this.this$0;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            int n3;
                                            int it = n3 = n2++;
                                            boolean bl = false;
                                            BuildersKt.async$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, sqsEventPoller, null){
                                                int label;
                                                final /* synthetic */ int $it;
                                                final /* synthetic */ SqsEventPoller this$0;
                                                {
                                                    this.$it = $it;
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Unable to fully structure code
                                                 */
                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                                    var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)var1_1);
                                                            SqsEventPollerKt.access$getLogger$p().debug("starting coroutine-" + this.$it + ' ' + LocalDateTime.now());
lbl7:
                                                            // 2 sources

                                                            while (true) {
                                                                SqsEventPoller.access$handleMessage(this.this$0);
                                                                v0 = SqsEventPoller.access$getPollerConfigs$p(this.this$0).getPollDelay();
                                                                if (v0 == null) continue;
                                                                it = var2_3 = v0.toMillis();
                                                                $i$a$-let-SqsEventPoller$start$1$1$1$1$1 = false;
                                                                this.label = 1;
                                                                v1 = DelayKt.delay((long)it, (Continuation)this);
                                                                if (v1 != var7_2) continue;
                                                                return var7_2;
                                                            }
                                                        }
                                                        case 1: {
                                                            $i$a$-let-SqsEventPoller$start$1$1$1$1$1 = false;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v1 = $result;
                                                            ** continue;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null).start();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                function2.L$0 = value;
                                return (Continuation)function2;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void stop() {
        SqsEventPollerKt.access$getLogger$p().info("stopping SqsMessagePoller");
        JobKt.cancelChildren$default((Job)((Job)this.supervisorJob), null, (int)1, null);
        Job.DefaultImpls.cancel$default((Job)((Job)this.supervisorJob), null, (int)1, null);
    }

    private final void handleMessage() {
        List<Message> messages = this.retrieveMessages();
        Stream<DeleteMessageBatchRequestEntry> stream = messages.parallelStream().filter(arg_0 -> SqsEventPoller.handleMessage$lambda-0(this, arg_0)).map(SqsEventPoller::handleMessage$lambda-1);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"messages\n            .pa\u2026   .build()\n            }");
        List messagesToDelete = StreamsKt.toList(stream);
        SqsEventPollerKt.access$getLogger$p().debug((Function0)new Function0<Object>((List<DeleteMessageBatchRequestEntry>)messagesToDelete){
            final /* synthetic */ List<DeleteMessageBatchRequestEntry> $messagesToDelete;
            {
                this.$messagesToDelete = $messagesToDelete;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return Intrinsics.stringPlus((String)"number of messages to be deleted ", (Object)this.$messagesToDelete.size());
            }
        });
        this.acknowledgeMessage(messagesToDelete);
    }

    private final List<Message> retrieveMessages() {
        ReceiveMessageRequest request = (ReceiveMessageRequest)ReceiveMessageRequest.builder().maxNumberOfMessages(Integer.valueOf(this.pollerConfigs.getBatchSize())).queueUrl(this.queueUrl).waitTimeSeconds(Integer.valueOf((int)this.pollerConfigs.getWaitTime().toSeconds())).visibilityTimeout(Integer.valueOf((int)this.pollerConfigs.getVisibilityTimeout().toSeconds())).build();
        List list = this.client.receiveMessage(request).messages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"client\n            .rece\u2026)\n            .messages()");
        return list;
    }

    private final boolean processMessage(Message sqsMessage) {
        boolean bl;
        try {
            String message = sqsMessage.body();
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
            this.eventHandler.onBeforeHandle(message);
            this.eventHandler.handle(message);
            SqsEventPollerKt.access$getLogger$p().debug((Function0)new Function0<Object>(sqsMessage){
                final /* synthetic */ Message $sqsMessage;
                {
                    this.$sqsMessage = $sqsMessage;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "message " + this.$sqsMessage.messageId() + " processed successfully - message has been deleted from SQS";
                }
            });
            this.eventHandler.onAfterHandle(message);
            bl = true;
        }
        catch (Exception exception) {
            SqsEventPollerKt.access$getLogger$p().error((Function0)processMessage.2.INSTANCE);
            bl = false;
        }
        return bl;
    }

    private final void acknowledgeMessage(List<DeleteMessageBatchRequestEntry> messagesToDelete) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, messagesToDelete, null){
            long J$0;
            double D$0;
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ SqsEventPoller this$0;
            final /* synthetic */ List<DeleteMessageBatchRequestEntry> $messagesToDelete;
            {
                this.this$0 = $receiver;
                this.$messagesToDelete = $messagesToDelete;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block10: {
                    var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = SqsEventPoller.access$getTabourConfigs$p(this.this$0).getTabourProperties().getMaxRetryCount();
                            var9_4 = this.$messagesToDelete;
                            var10_5 = this.this$0;
                            initialDelay$iv = 100L;
                            maxDelay$iv = 1000L;
                            factor$iv = 2.0;
                            $i$f$retry = false;
                            currentDelay$iv = new Ref.LongRef();
                            currentDelay$iv.element = initialDelay$iv;
                            var13_11 = times$iv - true;
                            var14_12 = 0;
lbl16:
                            // 2 sources

                            while (var14_12 < var13_11) {
                                var15_13 = var14_12++;
                                $i$a$-repeat-RetryKt$retry$2$iv = false;
                                try {
                                    $i$a$-retry$default-SqsEventPoller$acknowledgeMessage$1$1 = false;
                                    if (((Collection)var9_4).isEmpty() == false) {
                                        SqsEventPoller.access$getClient$p(var10_5).deleteMessageBatch((DeleteMessageBatchRequest)DeleteMessageBatchRequest.builder().queueUrl(SqsEventPoller.access$getEventHandler$p(var10_5).getSqsQueueUrl()).entries((Collection)var9_4).build());
                                    }
                                    break block10;
                                }
                                catch (Exception e$iv) {
                                    RetryKt.getLogger().warn(e$iv.getMessage());
                                    this.L$0 = var9_4;
                                    this.L$1 = var10_5;
                                    this.L$2 = currentDelay$iv;
                                    this.J$0 = maxDelay$iv;
                                    this.D$0 = factor$iv;
                                    this.I$0 = var13_11;
                                    this.I$1 = var14_12;
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)currentDelay$iv.element, (Continuation)this);
                                    if (v0 == var19_2) {
                                        return var19_2;
                                    }
                                    ** GOTO lbl54
                                }
                            }
                            break;
                        }
                        case 1: {
                            $i$f$retry = false;
                            $i$a$-repeat-RetryKt$retry$2$iv = false;
                            var14_12 = this.I$1;
                            var13_11 = this.I$0;
                            factor$iv = this.D$0;
                            maxDelay$iv = this.J$0;
                            currentDelay$iv = (Ref.LongRef)this.L$2;
                            var10_5 = (SqsEventPoller)this.L$1;
                            var9_4 = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl54:
                            // 2 sources

                            currentDelay$iv.element = RangesKt.coerceAtMost((long)((long)((double)currentDelay$iv.element * factor$iv)), (long)maxDelay$iv);
                            ** GOTO lbl16
                        }
                    }
                    $i$a$-retry$default-SqsEventPoller$acknowledgeMessage$1$1 = false;
                    if (((Collection)var9_4).isEmpty() == false) {
                        SqsEventPoller.access$getClient$p(var10_5).deleteMessageBatch((DeleteMessageBatchRequest)DeleteMessageBatchRequest.builder().queueUrl(SqsEventPoller.access$getEventHandler$p(var10_5).getSqsQueueUrl()).entries((Collection)var9_4).build());
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final boolean handleMessage$lambda-0(SqsEventPoller this$0, Message it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this$0.processMessage(it);
    }

    private static final DeleteMessageBatchRequestEntry handleMessage$lambda-1(Message it) {
        return (DeleteMessageBatchRequestEntry)DeleteMessageBatchRequestEntry.builder().id(it.messageId()).receiptHandle(it.receiptHandle()).build();
    }

    public static final /* synthetic */ EventPollerProperties access$getPollerConfigs$p(SqsEventPoller $this) {
        return $this.pollerConfigs;
    }

    public static final /* synthetic */ void access$handleMessage(SqsEventPoller $this) {
        $this.handleMessage();
    }

    public static final /* synthetic */ TabourAutoConfigs access$getTabourConfigs$p(SqsEventPoller $this) {
        return $this.tabourConfigs;
    }

    public static final /* synthetic */ SqsClient access$getClient$p(SqsEventPoller $this) {
        return $this.client;
    }

    public static final /* synthetic */ SqsEventHandler access$getEventHandler$p(SqsEventPoller $this) {
        return $this.eventHandler;
    }
}

