/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.core.consumer;

import com.katanox.tabour.config.EventPollerProperties;
import com.katanox.tabour.config.TabourAutoConfigs;
import com.katanox.tabour.integration.sqs.config.SqsConfiguration;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventHandler;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventHandlerRegistryKt;
import com.katanox.tabour.integration.sqs.core.consumer.SqsEventPoller;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.sqs.SqsClient;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventHandlerRegistry;", "", "eventHandlers", "", "Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventHandler;", "sqsConfiguration", "Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "tabourAutoConfigs", "Lcom/katanox/tabour/config/TabourAutoConfigs;", "pollerConfigs", "Lcom/katanox/tabour/config/EventPollerProperties;", "(Ljava/util/List;Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;Lcom/katanox/tabour/config/TabourAutoConfigs;Lcom/katanox/tabour/config/EventPollerProperties;)V", "pollers", "", "Lcom/katanox/tabour/integration/sqs/core/consumer/SqsEventPoller;", "createPollerForHandler", "registration", "initializePollers", "registrations", "start", "", "stop", "tabour"})
public final class SqsEventHandlerRegistry {
    @NotNull
    private final SqsConfiguration sqsConfiguration;
    @NotNull
    private final TabourAutoConfigs tabourAutoConfigs;
    @NotNull
    private final EventPollerProperties pollerConfigs;
    @NotNull
    private Set<SqsEventPoller> pollers;

    public SqsEventHandlerRegistry(@NotNull List<? extends SqsEventHandler> eventHandlers, @NotNull SqsConfiguration sqsConfiguration, @NotNull TabourAutoConfigs tabourAutoConfigs, @NotNull EventPollerProperties pollerConfigs) {
        Intrinsics.checkNotNullParameter(eventHandlers, (String)"eventHandlers");
        Intrinsics.checkNotNullParameter((Object)sqsConfiguration, (String)"sqsConfiguration");
        Intrinsics.checkNotNullParameter((Object)tabourAutoConfigs, (String)"tabourAutoConfigs");
        Intrinsics.checkNotNullParameter((Object)pollerConfigs, (String)"pollerConfigs");
        this.sqsConfiguration = sqsConfiguration;
        this.tabourAutoConfigs = tabourAutoConfigs;
        this.pollerConfigs = pollerConfigs;
        this.pollers = SetsKt.emptySet();
        this.pollers = this.initializePollers(eventHandlers);
    }

    private final Set<SqsEventPoller> initializePollers(List<? extends SqsEventHandler> registrations) {
        Set pollers = new HashSet();
        for (SqsEventHandler sqsEventHandler : registrations) {
            pollers.add(this.createPollerForHandler(sqsEventHandler));
            SqsEventHandlerRegistryKt.access$getLogger$p().info(Intrinsics.stringPlus((String)"initialized SqsMessagePoller ", (Object)sqsEventHandler.getClass().getCanonicalName()));
        }
        return pollers;
    }

    private final SqsEventPoller createPollerForHandler(SqsEventHandler registration) {
        String string = registration.getSqsQueueUrl();
        SqsClient sqsClient = this.sqsConfiguration.amazonSQSClient();
        TabourAutoConfigs tabourAutoConfigs = this.tabourAutoConfigs;
        EventPollerProperties eventPollerProperties = this.pollerConfigs;
        return new SqsEventPoller(string, registration, sqsClient, eventPollerProperties, tabourAutoConfigs);
    }

    public final void start() {
        for (SqsEventPoller poller : this.pollers) {
            poller.start();
        }
    }

    public final void stop() {
        for (SqsEventPoller poller : this.pollers) {
            poller.stop();
        }
    }
}

