/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.config;

import com.katanox.tabour.integration.sqs.config.SqsProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

@Configuration(proxyBeanMethods=false)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "", "sqsProperties", "Lcom/katanox/tabour/integration/sqs/config/SqsProperties;", "(Lcom/katanox/tabour/integration/sqs/config/SqsProperties;)V", "getSqsProperties", "()Lcom/katanox/tabour/integration/sqs/config/SqsProperties;", "amazonSQSClient", "Lsoftware/amazon/awssdk/services/sqs/SqsClient;", "credentialsProvider", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;", "tabour"})
public class SqsConfiguration {
    @NotNull
    private final SqsProperties sqsProperties;

    public SqsConfiguration(@Autowired @NotNull SqsProperties sqsProperties) {
        Intrinsics.checkNotNullParameter((Object)sqsProperties, (String)"sqsProperties");
        this.sqsProperties = sqsProperties;
    }

    @NotNull
    public SqsProperties getSqsProperties() {
        return this.sqsProperties;
    }

    @Bean
    @Primary
    @NotNull
    public SqsClient amazonSQSClient() {
        Object object = ((SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().credentialsProvider(this.credentialsProvider())).region(Region.of((String)this.getSqsProperties().getRegion()))).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder()\n            .c\u2026on))\n            .build()");
        return (SqsClient)object;
    }

    @Bean
    @NotNull
    public AwsCredentialsProvider credentialsProvider() {
        AwsBasicCredentials awsBasicCredentials = AwsBasicCredentials.create((String)this.getSqsProperties().getAccessKey(), (String)this.getSqsProperties().getSecretKey());
        if (awsBasicCredentials == null) {
            throw new NullPointerException("null cannot be cast to non-null type software.amazon.awssdk.auth.credentials.AwsCredentials");
        }
        StaticCredentialsProvider staticCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)((AwsCredentials)awsBasicCredentials));
        Intrinsics.checkNotNullExpressionValue((Object)staticCredentialsProvider, (String)"create(\n            AwsB\u2026 AwsCredentials\n        )");
        return (AwsCredentialsProvider)staticCredentialsProvider;
    }
}

