/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.thread;

import com.katanox.tabour.thread.NamedThreadFactory;
import com.katanox.tabour.thread.ThreadPools;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/katanox/tabour/thread/ThreadPools;", "", "()V", "blockingScheduledThreadPool", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "threads", "", "poolName", "", "blockingThreadPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "queueSize", "retryPolicy", "Ljava/util/concurrent/RejectedExecutionHandler;", "tabour"})
public final class ThreadPools {
    @NotNull
    public static final ThreadPools INSTANCE;

    @NotNull
    public final ThreadPoolExecutor blockingThreadPool(int threads, int queueSize, @NotNull String poolName) {
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue(queueSize), new NamedThreadFactory(null, poolName, 1, null), this.retryPolicy());
    }

    @NotNull
    public final ScheduledThreadPoolExecutor blockingScheduledThreadPool(int threads, @NotNull String poolName) {
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        return new ScheduledThreadPoolExecutor(threads, new NamedThreadFactory(null, poolName, 1, null), this.retryPolicy());
    }

    private final RejectedExecutionHandler retryPolicy() {
        return retryPolicy.1.INSTANCE;
    }

    private ThreadPools() {
    }

    static {
        ThreadPools threadPools;
        INSTANCE = threadPools = new ThreadPools();
    }
}

