/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.core.publisher;

import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.katanox.tabour.base.IEventPublisherBase;
import com.katanox.tabour.config.TabourAutoConfigs;
import com.katanox.tabour.factory.BusType;
import com.katanox.tabour.integration.sqs.config.SqsConfiguration;
import com.katanox.tabour.integration.sqs.core.publisher.SqsEventPublisherKt;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import java.io.Serializable;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0012\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J9\u0010\u0014\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0012\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0014\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u0002H\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0015R\u0012\u0010\u0003\u001a\u00020\u00048\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0012@\u0012X\u0093.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/katanox/tabour/integration/sqs/core/publisher/SqsEventPublisher;", "Lcom/katanox/tabour/base/IEventPublisherBase;", "()V", "sqsConfiguration", "Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "tabourConfigs", "Lcom/katanox/tabour/config/TabourAutoConfigs;", "doPublish", "", "T", "Ljava/io/Serializable;", "message", "busUrl", "", "preConfiguredRequest", "Lcom/amazonaws/services/sqs/model/SendMessageRequest;", "messageGroupId", "(Ljava/io/Serializable;Ljava/lang/String;Lcom/amazonaws/services/sqs/model/SendMessageRequest;Ljava/lang/String;)V", "getType", "Lcom/katanox/tabour/factory/BusType;", "publish", "(Ljava/io/Serializable;Ljava/lang/String;Ljava/lang/String;)V", "tabour"})
public class SqsEventPublisher
implements IEventPublisherBase {
    @Autowired
    private SqsConfiguration sqsConfiguration;
    @Autowired
    private TabourAutoConfigs tabourConfigs;

    @Override
    @NotNull
    public BusType getType() {
        return BusType.SQS;
    }

    @Override
    public <T extends Serializable> void publish(@NotNull T message, @NotNull String busUrl, @Nullable String messageGroupId) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)busUrl, (String)"busUrl");
        this.publish(message, busUrl, new SendMessageRequest(), messageGroupId);
    }

    private <T extends Serializable> void publish(T message, String busUrl, SendMessageRequest preConfiguredRequest, String messageGroupId) {
        boolean bl = preConfiguredRequest.getQueueUrl() == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "attribute queueUrl of pre-configured request must not be set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = preConfiguredRequest.getMessageBody() == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "message body of pre-configured request must not be set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        TabourAutoConfigs tabourAutoConfigs = this.tabourConfigs;
        if (tabourAutoConfigs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tabourConfigs");
        }
        Retry retry = tabourAutoConfigs.retryRegistry().retry("publish");
        Intrinsics.checkNotNullExpressionValue((Object)retry, (String)"tabourConfigs.retryRegistry().retry(\"publish\")");
        Retry retry2 = retry;
        retry2.getEventPublisher().onError((EventConsumer)new EventConsumer<RetryOnErrorEvent>(busUrl){
            final /* synthetic */ String $busUrl;

            public final void consumeEvent(@NotNull RetryOnErrorEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SqsEventPublisherKt.access$getLogger$p().warn("error publishing message to queue {}", (Object)this.$busUrl);
            }
            {
                this.$busUrl = string;
            }
        });
        retry2.executeRunnable(new Runnable(this, message, busUrl, preConfiguredRequest, messageGroupId){
            final /* synthetic */ SqsEventPublisher this$0;
            final /* synthetic */ Serializable $message;
            final /* synthetic */ String $busUrl;
            final /* synthetic */ SendMessageRequest $preConfiguredRequest;
            final /* synthetic */ String $messageGroupId;

            public final void run() {
                SqsEventPublisher.access$doPublish(this.this$0, this.$message, this.$busUrl, this.$preConfiguredRequest, this.$messageGroupId);
            }
            {
                this.this$0 = sqsEventPublisher;
                this.$message = serializable;
                this.$busUrl = string;
                this.$preConfiguredRequest = sendMessageRequest;
                this.$messageGroupId = string2;
            }
        });
    }

    private <T extends Serializable> void doPublish(T message, String busUrl, SendMessageRequest preConfiguredRequest, String messageGroupId) {
        SendMessageResult result;
        SqsEventPublisherKt.access$getLogger$p().debug("sending message {} to SQS queue {}", (Object)message.toString(), (Object)busUrl);
        SendMessageRequest request = preConfiguredRequest.withQueueUrl(busUrl).withMessageBody(message.toString());
        String string = messageGroupId;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            request.withMessageGroupId(it);
        }
        SqsConfiguration sqsConfiguration = this.sqsConfiguration;
        if (sqsConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sqsConfiguration");
        }
        SendMessageResult sendMessageResult = result = sqsConfiguration.amazonSQSAsync().sendMessage(request);
        Intrinsics.checkNotNullExpressionValue((Object)sendMessageResult, (String)"result");
        SdkHttpMetadata sdkHttpMetadata = sendMessageResult.getSdkHttpMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)sdkHttpMetadata, (String)"result.sdkHttpMetadata");
        if (sdkHttpMetadata.getHttpStatusCode() != 200) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "got error response from SQS queue %s: %s";
            Object[] objectArray = new Object[]{busUrl, result.getSdkHttpMetadata()};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new RuntimeException(string4);
        }
        SqsEventPublisherKt.access$getLogger$p().info("Sent message ID {}", (Object)result.getMessageId());
    }

    public static final /* synthetic */ void access$doPublish(SqsEventPublisher $this, Serializable message, String busUrl, SendMessageRequest preConfiguredRequest, String messageGroupId) {
        $this.doPublish(message, busUrl, preConfiguredRequest, messageGroupId);
    }
}

