/*
 * Decompiled with CFR 0.152.
 */
package com.katanox.tabour.integration.sqs.config;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.katanox.tabour.integration.sqs.config.SqsProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.aws.messaging.config.annotation.EnableSqs;
import org.springframework.cloud.aws.messaging.core.QueueMessagingTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@EnableSqs
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/katanox/tabour/integration/sqs/config/SqsConfiguration;", "", "sqsProperties", "Lcom/katanox/tabour/integration/sqs/config/SqsProperties;", "(Lcom/katanox/tabour/integration/sqs/config/SqsProperties;)V", "getSqsProperties", "()Lcom/katanox/tabour/integration/sqs/config/SqsProperties;", "amazonSQSAsync", "Lcom/amazonaws/services/sqs/AmazonSQSAsync;", "credentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "queueMessagingTemplate", "Lorg/springframework/cloud/aws/messaging/core/QueueMessagingTemplate;", "tabour"})
public class SqsConfiguration {
    @NotNull
    private final SqsProperties sqsProperties;

    @Bean
    @Primary
    @NotNull
    public AmazonSQSAsync amazonSQSAsync() {
        Object object = ((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withCredentials(this.credentialsProvider())).withRegion(this.getSqsProperties().getRegion())).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"AmazonSQSAsyncClientBuil\u2026ion)\n            .build()");
        return (AmazonSQSAsync)object;
    }

    @Bean
    @NotNull
    public AWSCredentialsProvider credentialsProvider() {
        return (AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.getSqsProperties().getAccessKey(), this.getSqsProperties().getSecretKey()));
    }

    @Bean
    @NotNull
    public QueueMessagingTemplate queueMessagingTemplate() {
        return new QueueMessagingTemplate(this.amazonSQSAsync());
    }

    @NotNull
    public SqsProperties getSqsProperties() {
        return this.sqsProperties;
    }

    public SqsConfiguration(@Autowired @NotNull SqsProperties sqsProperties) {
        Intrinsics.checkNotNullParameter((Object)sqsProperties, (String)"sqsProperties");
        this.sqsProperties = sqsProperties;
    }
}

